/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.build.ui.wizard;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.team.enterprise.ibmi.build.client.IBMiIntrospectPGM;
import com.ibm.team.enterprise.ibmi.build.client.IBMiIntrospectSRVPGM;
import com.ibm.team.enterprise.ibmi.build.ui.wizard.Messages;
import com.ibm.team.enterprise.ibmi.build.ui.wizard.NewLinkFileWizardFirstPage;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;

public class NewLinkFileWizard
extends Wizard
implements IWorkbenchWizard {
    protected NewLinkFileWizardFirstPage fFirstPage;
    protected IStructuredSelection selection;

    public boolean canFinish() {
        return super.canFinish();
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new NewLinkFileWizardFirstPage(Messages.NewLinkFileWizard_PageName);
        this.fFirstPage.setTitle(Messages.NewLinkFileWizard_PageTitle);
        this.fFirstPage.setDescription(Messages.NewLinkFileWizard_PageDescription);
        this.addPage((IWizardPage)this.fFirstPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.NewLinkFileWizard_WindowTitle);
        this.selection = selection;
    }

    public boolean performFinish() {
        try {
            if (this.fFirstPage.testSettings()) {
                AS400 connection = new AS400(this.fFirstPage.getHostName(), this.fFirstPage.getUserId(), this.fFirstPage.getPassword());
                if (this.fFirstPage.getType() == NewLinkFileWizardFirstPage.TYPE.PGM) {
                    this.createLinkFile(String.valueOf(this.fFirstPage.getObjectName()) + ".PGM.eelnk", new IBMiIntrospectPGM(connection, this.fFirstPage.getLibraryName(), this.fFirstPage.getObjectName(), this.fFirstPage.getTemporaryLibraryName()), true);
                } else if (this.fFirstPage.getType() == NewLinkFileWizardFirstPage.TYPE.SRVPGM) {
                    this.createLinkFile(String.valueOf(this.fFirstPage.getObjectName()) + ".SRVPGM.eelnk", new IBMiIntrospectSRVPGM(connection, this.fFirstPage.getLibraryName(), this.fFirstPage.getObjectName(), this.fFirstPage.getTemporaryLibraryName()), true);
                }
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void createLinkFile(String fileName, Object introspectObject, boolean promptOverwrite) throws IOException {
        String fileContents = null;
        try {
            String header = "\\\\\\\\\\\\\\" + Messages.NewLinkFileWizard_DoNotEditInstructions + "\\\\\\\\\\\\\\\\";
            header = String.valueOf(header) + "\n\\\\HOST_NAME=" + this.fFirstPage.getHostName();
            header = String.valueOf(header) + "\n\\\\USER_ID=" + this.fFirstPage.getUserId();
            header = String.valueOf(header) + "\n\\\\TEMP_LIBRARY=" + this.fFirstPage.getTemporaryLibraryName();
            header = String.valueOf(header) + "\n\\\\OBJECT_LIBRARY=" + this.fFirstPage.getLibraryName();
            header = String.valueOf(header) + "\n\\\\OBJECT_NAME=" + this.fFirstPage.getObjectName();
            header = String.valueOf(header) + "\n\\\\OBJECT_TYPE=" + (Object)((Object)this.fFirstPage.getType());
            header = String.valueOf(header) + "\n\\\\\\\\\\\\\\_header_end_\\\\\\\\\\\\\\\\";
            header = String.valueOf(header) + "\n\n";
            if (introspectObject instanceof IBMiIntrospectPGM) {
                ((IBMiIntrospectPGM)introspectObject).runAPI();
                fileContents = String.valueOf(header) + ((IBMiIntrospectPGM)introspectObject).getBindFileContents();
            } else if (introspectObject instanceof IBMiIntrospectSRVPGM) {
                ((IBMiIntrospectSRVPGM)introspectObject).runAPI();
                fileContents = String.valueOf(header) + ((IBMiIntrospectSRVPGM)introspectObject).getBindFileContents();
            }
        }
        catch (AS400SecurityException e) {
            e.printStackTrace();
        }
        catch (ErrorCompletingRequestException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ObjectDoesNotExistException e) {
            e.printStackTrace();
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        if (fileName != null && fileContents != null) {
            IProject project = this.getResourceFromSelection().getProject();
            IFile file = project.getFile(fileName);
            try {
                if (!file.exists()) {
                    byte[] bytes = fileContents.getBytes();
                    ByteArrayInputStream source = new ByteArrayInputStream(bytes);
                    file.create((InputStream)source, 0, null);
                } else if (!promptOverwrite || MessageDialog.open((int)3, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.NewLinkFileWizard_ConfirmOverwriteTitle, (String)Messages.NewLinkFileWizard_ConfirmOverwriteMessage, (int)0)) {
                    this.replaceFile(file, fileContents);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void replaceFile(IFile newFile, String contents) {
        byte[] bytes = contents.getBytes();
        ByteArrayInputStream source = new ByteArrayInputStream(bytes);
        try {
            newFile.setContents((InputStream)source, 2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IResource getResourceFromSelection() {
        Object context;
        if (this.selection != null && !this.selection.isEmpty() && (context = this.selection.getFirstElement()) instanceof IResource) {
            return (IResource)context;
        }
        return null;
    }
}

