/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.ibmi.build.client.scm;

import com.ibm.etools.iseries.util.AS400Factory;
import com.ibm.team.build.internal.scm.AcceptReport;
import com.ibm.team.build.internal.scm.BuildWorkspaceDescriptor;
import com.ibm.team.build.internal.scm.RepositoryManager;
import com.ibm.team.build.internal.scm.SourceControlUtility;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teami.filesystem.client.internal.operations.AcceptIReport;
import com.ibm.teami.filesystem.client.internal.operations.LoadIOperation;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class IBMISourceControlUtility {
    static {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
            new IBMISourceControlUtility();
        }
    }

    private IBMISourceControlUtility() {
    }

    public static IStatus updateFileCopyArea(ITeamRepository repository, IWorkspaceHandle workspaceHandle, boolean clearLibs, AcceptIReport report, PrintWriter writer, Hashtable<String, String> objectLibrariesPerProject, String ccsidMapping, HashMap<String, String> properties, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemStatusException {
        IStatus status = Status.OK_STATUS;
        LoadIOperation loadOp = new LoadIOperation(repository, workspaceHandle, AS400Factory.getInstance().getAS400(), clearLibs, report, writer, objectLibrariesPerProject, ccsidMapping, properties);
        try {
            status = loadOp.run(monitor);
        }
        catch (FileSystemStatusException exception) {
            throw new FileSystemStatusException(exception.getStatus()){
                private static final long serialVersionUID = 1L;

                public String getMessage() {
                    StringBuffer messages = new StringBuffer(super.getMessage());
                    messages.append(System.getProperty("line.separator"));
                    IBMISourceControlUtility.getChildStatusMessages(new IStatus[]{exception.getStatus()}, messages);
                    return messages.toString();
                }
            };
        }
        return status;
    }

    private static void getChildStatusMessages(IStatus[] children, StringBuffer messages) {
        String newLine = System.getProperty("line.separator");
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            messages.append(status.getMessage());
            messages.append(newLine);
            IBMISourceControlUtility.getChildStatusMessages(status.getChildren(), messages);
            ++n2;
        }
    }

    public static AcceptIReport checkForIncoming(RepositoryManager manager, BuildWorkspaceDescriptor workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        AcceptReport report = SourceControlUtility.checkForIncoming((RepositoryManager)manager, (BuildWorkspaceDescriptor)workspace, (IProgressMonitor)monitor);
        return IBMISourceControlUtility.reportToIReport(report, manager, workspace, monitor);
    }

    public static AcceptIReport acceptAllIncoming(RepositoryManager manager, BuildWorkspaceDescriptor workspace, String snapshotName, IProgressMonitor monitor) throws TeamRepositoryException {
        AcceptReport report = SourceControlUtility.acceptAllIncoming((RepositoryManager)manager, (BuildWorkspaceDescriptor)workspace, (String)snapshotName, (IProgressMonitor)monitor);
        return IBMISourceControlUtility.reportToIReport(report, manager, workspace, monitor);
    }

    private static AcceptIReport reportToIReport(AcceptReport report, RepositoryManager manager, BuildWorkspaceDescriptor workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        AcceptIReport iReport = new AcceptIReport();
        iReport.addAcceptChangeSets(Arrays.asList(report.getAcceptChangeSets()));
        IBaselineHandle[] ibh = report.getComponentBaselines();
        IWorkspaceConnection connection = workspace.getConnection(manager, false, monitor);
        IBaselineHandle[] iBaselineHandleArray = ibh;
        int n = ibh.length;
        int n2 = 0;
        while (n2 < n) {
            IBaselineHandle bh = iBaselineHandleArray[n2];
            IBaseline baselineOfComponent = (IBaseline)connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)bh, 0, monitor);
            iReport.addComponentBaseline(baselineOfComponent);
            ++n2;
        }
        iReport.addDiscardChangeSets(Arrays.asList(report.getDiscardChangeSets()));
        iReport.addSnapshot(report.getSnapshot());
        iBaselineHandleArray = report.getComponentAdds();
        n = iBaselineHandleArray.length;
        n2 = 0;
        while (n2 < n) {
            IBaselineHandle ch = iBaselineHandleArray[n2];
            iReport.componentAdd((IComponentHandle)ch);
            ++n2;
        }
        return iReport;
    }
}

