/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.build.client;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.UserSpace;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import com.ibm.team.enterprise.ibmi.build.client.Messages;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public abstract class IBMiIntrospectionAbstract {
    private String program = null;
    private String library = null;
    private String tempLib = null;
    private AS400 conn = null;
    private final List<ISeriesHostObjectBasic> modules = new ArrayList<ISeriesHostObjectBasic>();
    private final List<ISeriesHostObjectBasic> srvpgms = new ArrayList<ISeriesHostObjectBasic>();
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ");
    protected String API = "QSYS.LIB/QSYS.LIB/QBNLSPGM.PGM";
    protected String MODULES_ONLY = "SPGL0100";
    protected String SRVPGM_ONLY = "SPGL0200";
    protected String PREFIX = "";
    protected String TYPE = "";
    protected int ProjectMSG_DEBUG = 4;
    protected int ProjectMSG_VERBOSE = 3;
    protected int ProjectMSG_INFO = 2;
    protected int ProjectMSG_ERR = 0;

    public IBMiIntrospectionAbstract(AS400 conn, String library, String pgmName, String tempLib) {
        this.program = pgmName;
        this.library = library;
        this.tempLib = tempLib;
        this.conn = conn;
        this.initialize();
    }

    public int runAPI() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        return this.runAPI(null);
    }

    public int runAPI(Object task) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        int count = 0;
        if (this.program != null && this.tempLib != null && this.conn != null) {
            this.getList(this.modules, task, this.MODULES_ONLY, "*MODULE");
            this.getList(this.srvpgms, task, this.SRVPGM_ONLY, "*SRVPGM");
        } else {
            this.log(task, Messages.INTROSPECTION_REQUIRED_PARAMETER_IS_MISSING, this.ProjectMSG_ERR);
        }
        return count;
    }

    private void getList(List<ISeriesHostObjectBasic> list, Object task, String formatName, String minedObjectType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        byte[][] programName = new byte[][]{new AS400Text(10).toBytes((Object)this.program), new AS400Text(10).toBytes((Object)this.library)};
        byte[][] userSpaceName = new byte[][]{new AS400Text(10).toBytes((Object)this.program), new AS400Text(10).toBytes((Object)this.tempLib)};
        ProgramParameter[] parameterList = new ProgramParameter[]{new ProgramParameter(IBMiIntrospectionAbstract.convert2to1(userSpaceName)), new ProgramParameter(new AS400Text(8).toBytes((Object)formatName)), new ProgramParameter(IBMiIntrospectionAbstract.convert2to1(programName)), new ProgramParameter(new byte[32], 0)};
        UserSpace US = new UserSpace(this.conn, "/QSYS.LIB/" + this.tempLib + ".LIB/" + this.program + ".USRSPC");
        US.setMustUseProgramCall(true);
        US.setMustUseSockets(true);
        US.create(256, true, "", (byte)0, "Created by IBM i Introspect " + this.PREFIX + " Ant utility", "*USE");
        ProgramCall pgm = new ProgramCall(this.conn);
        this.log(task, String.valueOf(this.PREFIX) + ">> " + this.getCommand(), this.ProjectMSG_DEBUG);
        Boolean success = pgm.run(this.API, parameterList);
        if (!success.booleanValue()) {
            AS400Message[] msgList = pgm.getMessageList();
            this.log(task, "  Unable to get object information for " + this.PREFIX + ": " + this.library + "/" + this.program, this.ProjectMSG_ERR);
            int i1 = 0;
            while (i1 < msgList.length) {
                this.log(task, "  <<" + msgList[i1].getText(), this.ProjectMSG_ERR);
                ++i1;
            }
        } else {
            int list_offset = this.readInt(US, 124);
            int list_count = this.readInt(US, 132);
            int list_sizePer = this.readInt(US, 136);
            this.log(task, "  Retrieved object information for " + this.PREFIX + ": " + this.library + "/" + this.program + ".  Using API-format [" + this.API + "-" + formatName + "]", this.ProjectMSG_DEBUG);
            int i = 0;
            while (i < list_count) {
                list.add(this.convert2IHOB(this.readString(US, list_offset + 20 + 10, 10), this.readString(US, list_offset + 20, 10), minedObjectType));
                list_offset += list_sizePer;
                ++i;
            }
        }
        US.close();
    }

    public String getCommand() {
        return "API=" + this.API + ", userspace=" + this.tempLib + "/" + this.program + ".USRSPC";
    }

    private int readInt(UserSpace US, int offset) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        AS400Bin4 ib4 = new AS400Bin4();
        byte[] b4 = new byte[4];
        US.read(b4, offset);
        return ib4.toInt(b4);
    }

    private String readString(UserSpace US, int offset, int size) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        AS400Text textConverter = new AS400Text(size);
        byte[] ba = new byte[size];
        US.read(ba, offset);
        return ((String)textConverter.toObject(ba)).trim();
    }

    private static byte[] convert2to1(byte[][] data2) {
        int size = 0;
        byte[][] byArray = data2;
        int n = data2.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] e = byArray[n2];
            size += e.length;
            ++n2;
        }
        byte[] data1 = new byte[size];
        int i = 0;
        byte[][] byArray2 = data2;
        int n3 = data2.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] e;
            byte[] byArray3 = e = byArray2[n4];
            int n5 = e.length;
            int n6 = 0;
            while (n6 < n5) {
                byte eb = byArray3[n6];
                data1[i++] = eb;
                ++n6;
            }
            ++n4;
        }
        return data1;
    }

    protected abstract void initialize();

    protected abstract void log(Object var1, String var2, int var3);

    public List<ISeriesHostObjectBasic> getSrvpgms() {
        return this.srvpgms;
    }

    public List<ISeriesHostObjectBasic> getModules() {
        return this.modules;
    }

    public void dump() {
        System.out.println("Introspection for " + this.library + "/" + this.program + this.TYPE + "\nModules:");
        for (ISeriesHostObjectBasic o : this.modules) {
            System.out.println(o.toString());
        }
        System.out.println("SRVPGM's:");
        for (ISeriesHostObjectBasic o : this.srvpgms) {
            System.out.println(o.toString());
        }
    }

    public String getBindFileContents() {
        StringBuffer sb = new StringBuffer("");
        sb.append("// " + NLS.bind((String)Messages.INTROSPECTION_COMMENT1, (Object)(String.valueOf(this.library) + "/" + this.program + this.TYPE)));
        sb.append("\n// " + NLS.bind((String)Messages.INTROSPECTION_COMMENT2, (Object)DATE_FORMAT.format(new Date())));
        sb.append("\n// " + NLS.bind((String)Messages.INTROSPECTION_COMMENT3, (Object)this.conn.getSystemName()));
        sb.append("\n\nMODULE(");
        for (ISeriesHostObjectBasic o : this.modules) {
            if (o.getLibrary().startsWith("QSYS")) continue;
            sb.append(String.valueOf(o.getName()) + " ");
        }
        sb.append(")\nBNDSRVPGM(");
        for (ISeriesHostObjectBasic o : this.srvpgms) {
            if (o.getLibrary().startsWith("QSYS")) continue;
            sb.append(String.valueOf(o.getName()) + " ");
        }
        sb.append(")");
        return sb.toString();
    }

    public ISeriesHostObjectBasic convert2IHOB(String lib, String object, String type) {
        ISeriesHostObjectBasic o = new ISeriesHostObjectBasic();
        o.setLibrary(lib);
        o.setFile(object);
        o.setName(object);
        o.setType(type);
        return o;
    }
}

