/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.feed.ui;

import com.ibm.team.enterprise.common.common.feed.ChangeEventHelper;
import com.ibm.team.enterprise.internal.feed.ui.nls.Messages;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IFeedManagerConfigurer;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.FeedFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IFeedServiceConstants;
import com.ibm.team.repository.common.Location;
import java.net.URI;
import org.eclipse.osgi.util.NLS;

public class EnterpriseExtensionsFeedConfigurer
implements IFeedManagerConfigurer,
ITeamRepositoryService.IRepositoryServiceListener,
ITeamRepository.ILoginParticipant {
    private FeedManager feedManager;

    public void configure(FeedManager manager) {
        ITeamRepository[] teamRepositories;
        this.feedManager = manager;
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
        ITeamRepository[] iTeamRepositoryArray = teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = teamRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository = iTeamRepositoryArray[n2];
            teamRepository.addLoginParticipant((ITeamRepository.ILoginParticipant)this);
            if (teamRepository.loggedIn()) {
                this.addDefaultEEChannel(teamRepository);
            }
            ++n2;
        }
    }

    private Channel addDefaultEEChannel(ITeamRepository teamRepository) {
        String url;
        Channel channel = this.getEEChannel(teamRepository);
        if (channel == null && (channel = this.feedManager.getChannel(url = this.getDefaultEEChannelUrl(teamRepository))) == null) {
            channel = this.createChannel(url, this.getDefaultBuildFeedTitle(teamRepository), Messages.EnterpriseFeedConfigurer_DEFAULT_FEED_DESCRIPTION);
            this.feedManager.addChannel(channel);
            this.feedManager.loadNews(channel);
        }
        return channel;
    }

    private Channel getEEChannel(ITeamRepository teamRepository) {
        Channel[] channelArray = this.feedManager.getChannels();
        int n = channelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            String channelRepositoryUri = this.getRepositoryUri(channel);
            if (channelRepositoryUri != null && this.equalRepositoryUris(teamRepository.getRepositoryURI(), channelRepositoryUri) && this.isEEProvider(channel)) {
                return channel;
            }
            ++n2;
        }
        return null;
    }

    private String getRepositoryUri(Channel channel) {
        String repositoryUri = null;
        String url = channel.getUrl();
        try {
            url = url.replace("{$user}", "x");
            Location location = Location.location((URI)new URI(url));
            repositoryUri = location.getRepoUri();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return repositoryUri;
    }

    private boolean equalRepositoryUris(String uri1, String uri2) {
        boolean equal = false;
        if (uri1.equals(uri2)) {
            equal = true;
        } else {
            if (uri1.endsWith("/")) {
                uri1 = uri1.substring(0, uri1.length() - 1);
            }
            if (uri2.endsWith("/")) {
                uri2 = uri2.substring(0, uri2.length() - 1);
            }
            equal = uri1.equals(uri2);
        }
        return equal;
    }

    private boolean isEEProvider(Channel channel) {
        return ChangeEventHelper.isEEProvider((String)channel.getUrl());
    }

    private String getDefaultEEChannelUrl(ITeamRepository teamRepository) {
        StringBuffer url = new StringBuffer();
        url.append(teamRepository.getRepositoryURI());
        url.append("service/");
        url.append(IFeedServiceConstants.SERVICE_NAME);
        url.append("?");
        url.append("provider");
        url.append("=");
        url.append("ee");
        url.append("&user=").append("{$user}");
        return url.toString();
    }

    private Channel createChannel(String url, String title, String description) {
        Channel channel = FeedFactory.eINSTANCE.createChannel();
        channel.setUrl(url);
        channel.setTitle(title);
        channel.setDescription(description);
        channel.setForceDownload(true);
        channel.setCategory("com.ibm.team.feed.core.SystemFeed");
        channel.setUpdateInterval(3);
        return channel;
    }

    private String getDefaultBuildFeedTitle(ITeamRepository repository) {
        String repoName = repository.getName();
        if (repoName == null || repoName.length() == 0) {
            String repoURI = repository.getRepositoryURI();
            int startIndex = repoURI.indexOf("//") + 2;
            repoName = repoURI.substring(startIndex, repoURI.indexOf("/", startIndex));
        }
        return NLS.bind((String)Messages.EnterpriseFeedConfigurer_DEFAULT_FEED_TITLE, (Object)repoName);
    }

    private void removeAllEnterpriseChannels(ITeamRepository teamRepository) {
        Channel[] channelArray = this.feedManager.getChannels();
        int n = channelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            String channelRepositoryUri = this.getRepositoryUri(channel);
            if (channelRepositoryUri != null && this.equalRepositoryUris(teamRepository.getRepositoryURI(), channelRepositoryUri) && this.isEEProvider(channel)) {
                this.feedManager.removeChannel(channel);
            }
            ++n2;
        }
    }

    public void handleLogin(ITeamRepository repository) {
        this.addDefaultEEChannel(repository);
    }

    public void handleLogout(ITeamRepository repository) {
    }

    public void addedRepository(ITeamRepository repository) {
        repository.addLoginParticipant((ITeamRepository.ILoginParticipant)this);
        this.addDefaultEEChannel(repository);
    }

    public void removedRepository(ITeamRepository repository) {
        repository.removeLoginParticipant((ITeamRepository.ILoginParticipant)this);
        this.removeAllEnterpriseChannels(repository);
    }
}

