/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.dialogs.tags.PromptForTagDialog;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryByTag;
import com.ibm.team.build.internal.ui.tags.TagContentProposalProvider;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.IMenuAction;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;

public class ShowBuildResultsWithTagAction
extends Action
implements IMenuAction {
    private List<IBuildDefinitionHandle> _buildDefinitionHandles;
    private List<BuildDomainQueryNode> _buildDefinitionQueryNodes;
    private IWorkbenchPartSite _partSite;
    private String _queryName;
    private IProjectAreaHandle _projectAreaHandle;

    public void ShowBuildsWithTagAction(String actionName, List<IBuildDefinitionHandle> buildDefinitionHandles, List<BuildDomainQueryNode> buildDefinitionQueryNodes, IWorkbenchPartSite parentPart) {
        ValidationHelper.validateNotNull((String)"buildDefinitionHandles", buildDefinitionHandles);
        ValidationHelper.validateNotEmpty((String)"buildDefinitionHandles", (Object[])buildDefinitionHandles.toArray());
        ValidationHelper.validateNotNullElements((String)"buildDefinitionHandles", (Object[])buildDefinitionHandles.toArray());
        ValidationHelper.validateNotNull((String)"buildDefinitionQueryNodes", buildDefinitionQueryNodes);
        ValidationHelper.validateNotEmpty((String)"buildDefinitionQueryNodes", (Object[])buildDefinitionQueryNodes.toArray());
        ValidationHelper.validateNotNullElements((String)"buildDefinitionQueryNodes", (Object[])buildDefinitionQueryNodes.toArray());
        this._buildDefinitionHandles = buildDefinitionHandles;
        this._buildDefinitionQueryNodes = buildDefinitionQueryNodes;
        this._partSite = parentPart;
    }

    public ShowBuildResultsWithTagAction(String actionName, IProjectAreaHandle projectAreaHandle, IWorkbenchPartSite parentPart) {
        super(actionName);
        ValidationHelper.validateNotNull((String)"projectAreaHandle", (Object)projectAreaHandle);
        this._projectAreaHandle = projectAreaHandle;
        this._buildDefinitionHandles = null;
        this._buildDefinitionQueryNodes = null;
        this._partSite = parentPart;
    }

    public ShowBuildResultsWithTagAction() {
        this(Messages.BuildDomainActionHelper_TAG_QUERY_ACTION_NAME);
    }

    public ShowBuildResultsWithTagAction(String text) {
        super(text);
    }

    public ShowBuildResultsWithTagAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public ShowBuildResultsWithTagAction(String text, int style) {
        super(text, style);
    }

    public void runWithEvent(Event arg0) {
        IStructuredSelection structuredSelection;
        Object obj;
        IWorkbenchPage workbenchPage = this._partSite.getPage();
        ISelection selection = workbenchPage.getSelection();
        if (selection instanceof IStructuredSelection && (obj = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IEnterpriseExtensionsNode) {
            this._projectAreaHandle = ((IEnterpriseExtensionsNode)obj).getProjectAreaHandle();
            ITeamRepository teamRepository = (ITeamRepository)this._projectAreaHandle.getOrigin();
            String tag = this.promptForTag(this._partSite.getShell(), teamRepository);
            if (!tag.equals("")) {
                BuildQueryByTag query;
                if (this._buildDefinitionHandles == null) {
                    this._queryName = NLS.bind((String)Messages.ShowBuildsWithTagAction_ACTION_NAME_ALL_BUILDS, (Object)tag);
                    query = new BuildQueryByTag(this._queryName, null, AdaptableBuildQueryRow.Factory, this._projectAreaHandle, tag, teamRepository);
                } else {
                    this._queryName = this._buildDefinitionQueryNodes.size() == 1 ? NLS.bind((String)Messages.BuildDomainActionHelper_TAG_QUERY_NAME_ONE_DEFINITION, (Object)this._buildDefinitionQueryNodes.get(0).getLabel(), (Object)tag) : NLS.bind((String)Messages.BuildDomainActionHelper_TAG_QUERY_NAME_MULTIPLE_DEFINITIONS, (Object)tag);
                    this._queryName = TextProcessor.process((String)this._queryName);
                    query = new BuildQueryByTag(this._queryName, null, AdaptableBuildQueryRow.Factory, this._buildDefinitionHandles.toArray(new IBuildDefinitionHandle[this._buildDefinitionHandles.size()]), tag, teamRepository);
                }
                BuildQueryView.displayQuery((BuildQuery)query, (IWorkbenchPage)this._partSite.getPage());
            }
        }
    }

    public String getActionForID() {
        return null;
    }

    public String getId() {
        return "show.builds.tag.and.definition";
    }

    protected ITeamRepository getTeamRepository() {
        if (this._buildDefinitionHandles == null) {
            return (ITeamRepository)this._projectAreaHandle.getOrigin();
        }
        return (ITeamRepository)this._buildDefinitionHandles.get(0).getOrigin();
    }

    protected String promptForTag(Shell shell, ITeamRepository teamRepository) {
        String tag = "";
        TagContentProposalProvider tagProvider = null;
        tagProvider = new TagContentProposalProvider(teamRepository, this._projectAreaHandle);
        PromptForTagDialog dialog = new PromptForTagDialog(shell, tagProvider);
        this.openDialog(dialog);
        if (dialog.getReturnCode() == 0) {
            tag = dialog.getTags();
        }
        return tag;
    }

    protected int openDialog(PromptForTagDialog dialog) {
        return dialog.open();
    }

    public String getQueryName() {
        return this._queryName;
    }

    public void setPartSite(IWorkbenchPartSite partSite) {
        this._partSite = partSite;
    }
}

