/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.enterprise.deployment.dialogs.RequestDeployDialog;
import com.ibm.team.enterprise.deployment.internal.ui.nls.Messages;
import com.ibm.team.enterprise.deployment.ui.DeploymentDefinitionQueryNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class RequestDeployAction
extends Action {
    private final ISelectionProvider fSelectionProvider;
    private final Shell fShell;

    public RequestDeployAction(ISelectionProvider selectionProvider, Shell shell, boolean showIcon) {
        ValidationHelper.validateNotNull((String)"shell", (Object)shell);
        this.fSelectionProvider = selectionProvider;
        this.fShell = shell;
        this.setText(this.getActionText());
        this.setToolTipText(this.getActionText());
        if (showIcon) {
            this.setImageDescriptor(BuildUIPlugin.getImageDescriptor((String)"icons/elcl16/rquebuild.gif"));
        }
        this.setEnabled(true);
    }

    protected String getActionText() {
        return Messages.DeploymentDefinitionActionHelper_LOAD_AND_DEPLOY;
    }

    public void run() {
        IBuildDefinitionHandle buildDefinition = null;
        IStructuredSelection selection = this.getSelection();
        if (selection.getFirstElement() instanceof DeploymentDefinitionQueryNode) {
            DeploymentDefinitionQueryNode node = (DeploymentDefinitionQueryNode)((Object)selection.getFirstElement());
            BuildQueryByDefinition queryByType = (BuildQueryByDefinition)node.getQuery();
            buildDefinition = (IBuildDefinitionHandle)queryByType.getBuildDefinitionHandles().get(0);
        }
        RequestDeployDialog dialog = this.createDialog(this.getShell(), buildDefinition);
        dialog.open();
    }

    protected IStructuredSelection getSelection() {
        if (this.fSelectionProvider == null) {
            return StructuredSelection.EMPTY;
        }
        ISelection selection = this.fSelectionProvider.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected RequestDeployDialog createDialog(Shell shell, IBuildDefinitionHandle buildDefinition) {
        return new RequestDeployDialog(shell, buildDefinition);
    }
}

