/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.enterprise.automation.internal.ui.view.ISelectResultInput;
import com.ibm.team.enterprise.automation.internal.ui.view.SelectResultView;
import com.ibm.team.enterprise.automation.internal.ui.view.Util;
import com.ibm.team.enterprise.build.client.deployment.IDeploymentJFSClient;
import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.IMenuAction;
import com.ibm.team.enterprise.deployment.dialogs.QueryDeployedPackagesDialog;
import com.ibm.team.enterprise.deployment.internal.ui.DeploymentSelectResultInput;
import com.ibm.team.enterprise.deployment.ui.DeploymentDefinitionQueryNode;
import com.ibm.team.enterprise.deployment.ui.actions.Messages;
import com.ibm.team.enterprise.packaging.common.jfs.IPackageHandle;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;

public class QueryDeployedPackagesAction
extends Action
implements IMenuAction {
    private ISelection selection;
    private Shell shell;
    private IWorkbenchPartSite _partSite = null;
    UIUpdaterJob _uiJob = null;

    public QueryDeployedPackagesAction(ISelection selection, Shell shell) {
        super(Messages.QueryDeployedPackagesAction_LABEL);
        this.selection = selection;
        this.shell = shell;
    }

    public QueryDeployedPackagesAction() {
        super(Messages.QueryDeployedPackagesAction_LABEL);
    }

    public void run() {
        if (this.selection == null && this._partSite != null) {
            IWorkbenchPage workbenchPage = this._partSite.getPage();
            this.selection = workbenchPage.getSelection();
            this.shell = workbenchPage.getWorkbenchWindow().getShell();
        }
        if (this.selection instanceof IStructuredSelection && !this.selection.isEmpty()) {
            QueryDeployedPackagesDialog dlg;
            IBuildDefinition deploymentDefinition = null;
            ITeamRepository repository = null;
            Object object = ((IStructuredSelection)this.selection).getFirstElement();
            if (object instanceof DeploymentDefinitionQueryNode) {
                DeploymentDefinitionQueryNode deploymentNode = (DeploymentDefinitionQueryNode)((Object)object);
                deploymentDefinition = deploymentNode.getBuildDefinition();
                repository = deploymentNode.getTeamRepository();
            } else if (object instanceof IEnterpriseExtensionsNode) {
                IEnterpriseExtensionsNode node = (IEnterpriseExtensionsNode)object;
                repository = node.getTeamRepository();
            }
            if (repository != null && (dlg = new QueryDeployedPackagesDialog(this.shell, repository, deploymentDefinition)).open() == 0) {
                try {
                    deploymentDefinition = dlg.getDeploymentDefinition();
                    IBuildEngine buildEngine = dlg.getBuildEngine();
                    IBuildDefinition packageDefinition = dlg.getPackageDefinition();
                    IPackageHandle packageHandle = dlg.getPackageHandle();
                    final UUID deploymentDefinitionUUID = deploymentDefinition == null ? null : deploymentDefinition.getItemId();
                    final UUID packageDefinitionUUID = packageDefinition == null ? null : packageDefinition.getItemId();
                    final UUID buildEngineUUID = buildEngine == null ? null : buildEngine.getItemId();
                    final UUID packageResultUUID = packageHandle == null ? null : packageHandle.getBuildResultUUID();
                    final IDeploymentJFSClient deploymentJFSClient = (IDeploymentJFSClient)repository.getClientLibrary(IDeploymentJFSClient.class);
                    final ITeamRepository finalRepository = repository;
                    if (this._uiJob != null) {
                        this._uiJob.cancel();
                    } else {
                        this._uiJob = new UIUpdaterJob(""){
                            List<SelectResult> results;
                            DeploymentSelectResultInput input;
                            {
                                super($anonymous0);
                                this.results = null;
                                this.input = null;
                            }

                            public IStatus runInBackground(IProgressMonitor monitor) {
                                try {
                                    this.results = deploymentJFSClient.queryAllDeployedPackages(packageDefinitionUUID, deploymentDefinitionUUID, packageResultUUID, buildEngineUUID);
                                    this.input = new DeploymentSelectResultInput(this.results, finalRepository);
                                }
                                catch (TeamRepositoryException e) {
                                    e.printStackTrace();
                                }
                                return super.runInBackground(monitor);
                            }

                            public IStatus runInUI(IProgressMonitor monitor) {
                                SelectResultView view = Util.openQueryView();
                                view.setInput((ISelectResultInput)this.input);
                                return super.runInUI(monitor);
                            }
                        };
                    }
                    this._uiJob.schedule();
                    this._uiJob.join();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setPartSite(IWorkbenchPartSite partSite) {
        this._partSite = partSite;
    }

    public String getActionForID() {
        return "com.ibm.team.enterprise.deployment.ui.deployment";
    }
}

