/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import com.ibm.team.enterprise.deployment.internal.ui.nls.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;

public class DeploymentOptionsRequestBuildSection
extends RequestBuildSection {
    private static final String ibmiDef = "com.ibm.team.enterprise.deployment.ibmi";
    private static final String zOSDef = "com.ibm.team.enterprise.deployment.zos";
    private static final String luwDef = "com.ibm.team.enterprise.deployment.luw";
    private static final String zOSDef_NONSEQ = "com.ibm.team.enterprise.deployment.nonseq.zos";
    private static final String templateDefPropertyId = "com.ibm.team.build.internal.template.id";
    private static final String versionProperty = "team.deploy.common.definition.version";
    private Composite fDeploymentOptionsComposite;
    Button openSummaryWorkItemButton;
    Boolean openSummaryWorkItem;

    public DeploymentOptionsRequestBuildSection(RequestBuildSectionSite site) {
        super(site);
    }

    protected String getSectionName() {
        return Messages.DEPLOYMENT_OPTIONS_SECTION_TITLE;
    }

    public void createContent(Composite parent) {
        super.createContent(parent);
        ((GridData)this.getSection().getLayoutData()).exclude = true;
        this.getSection().setVisible(false);
    }

    protected void createSectionContent(Section section) {
        if (this.fDeploymentOptionsComposite != null && !this.fDeploymentOptionsComposite.isDisposed()) {
            this.fDeploymentOptionsComposite.dispose();
        }
        this.fDeploymentOptionsComposite = new Composite((Composite)section, 0);
        this.fDeploymentOptionsComposite.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 10;
        this.fDeploymentOptionsComposite.setLayout((Layout)layout);
        section.setClient((Control)this.fDeploymentOptionsComposite);
        if (this.isDeploymentDefinition()) {
            ((GridData)this.getSection().getLayoutData()).exclude = false;
            this.getSection().setVisible(true);
            this.openSummaryWorkItemButton = new Button(this.fDeploymentOptionsComposite, 32);
            this.openSummaryWorkItemButton.setText(Messages.OPEN_SUMMARY_WORK_ITEM);
            this.openSummaryWorkItemButton.setLayoutData((Object)new GridData(768));
            this.openSummaryWorkItem = Boolean.parseBoolean(this.getSite().getBuildDefinition().getProperty("team.deploy.common.openSummaryWorkItem").getValue());
            this.openSummaryWorkItemButton.setSelection(this.openSummaryWorkItem.booleanValue());
            this.openSummaryWorkItemButton.addSelectionListener(this.getSummaryWorkItemListener());
            this.getSection().setExpanded(true);
        }
    }

    protected SelectionListener getSummaryWorkItemListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentOptionsRequestBuildSection.this.openSummaryWorkItem = DeploymentOptionsRequestBuildSection.this.openSummaryWorkItemButton.getSelection();
            }
        };
    }

    public void applyProperties(IBuildDefinition buildDefinition) {
        if (this.isDeploymentDefinition()) {
            buildDefinition.setProperty("team.deploy.common.openSummaryWorkItem", Boolean.toString(this.openSummaryWorkItem));
        }
    }

    protected boolean isDeploymentDefinition() {
        String version;
        String templateId;
        IBuildProperty property;
        IBuildDefinition buildDef = this.getSite().getBuildDefinition();
        if (buildDef != null && (property = buildDef.getProperty(templateDefPropertyId)) != null && (templateId = property.getValue()) != null && (templateId.equals(ibmiDef) || templateId.equals(luwDef) || templateId.equals(zOSDef) || templateId.equals(zOSDef_NONSEQ)) && buildDef.getConfigurationElement("com.ibm.team.enterprise.deployment") != null && (property = buildDef.getProperty(versionProperty)) != null && (version = property.getValue()) != null) {
            return version.compareTo("3.0.0") > 0;
        }
        return false;
    }
}

