/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.enterprise.automation.ui.AbstractAutomationNode;
import com.ibm.team.enterprise.automation.ui.AutomationDefinitionQueryNode;
import com.ibm.team.enterprise.automation.ui.AutomationUtil;
import com.ibm.team.enterprise.deployment.internal.ui.nls.Messages;
import com.ibm.team.enterprise.deployment.ui.DeploymentDefinitionQueryNode;
import com.ibm.team.enterprise.deployment.ui.DeploymentUIPlugin;
import com.ibm.team.enterprise.deployment.ui.listeners.DeploymentNodeChangeListener;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class DeploymentNode
extends AbstractAutomationNode {
    public static final String DEPLOYMENT_DEPLOY_OPERATION_ID = "com.ibm.teamz.deployment.deploy";

    public String getLabel() {
        return Messages.DEPLOYMENTS_NODE_LABEL;
    }

    public Image getIcon() {
        return DeploymentUIPlugin.getImage("icons/obj16/deployments_obj.gif");
    }

    public boolean includeBuildDefinition(IBuildDefinition definition) {
        return AutomationUtil.getInstance().includeExistingDefinition(definition, "com.ibm.team.enterprise.deployment");
    }

    protected AutomationDefinitionQueryNode createAutomationDefinitionQueryNode(ITeamRepository repository, IBuildDefinitionStatusRecord record) {
        return new DeploymentDefinitionQueryNode(repository, record);
    }

    protected String[] getOperationIds() {
        return new String[]{DEPLOYMENT_DEPLOY_OPERATION_ID};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDefinitionListeners(IProjectAreaHandle projectAreaHandle, List<BuildDefinitionQueryNode> nodes) {
        DeploymentNodeChangeListener deploymentChangeListener = new DeploymentNodeChangeListener((EnterpriseExtensionsDomainContentProvider)this.getDomain().getContentProvider(), projectAreaHandle, this, nodes);
        DeploymentNode deploymentNode = this;
        synchronized (deploymentNode) {
            ((EnterpriseExtensionsDomainContentProvider)this.getDomain().getContentProvider()).addDeploymentListener(projectAreaHandle, (AbstractBuildDefinitionChangeListener)deploymentChangeListener);
        }
        this.addDefinitionItemListener(projectAreaHandle, deploymentChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDefinitionListeners(IProjectAreaHandle projectAreaHandle) {
        DeploymentNodeChangeListener oldDeploymentChangeListener;
        DeploymentNode deploymentNode = this;
        synchronized (deploymentNode) {
            oldDeploymentChangeListener = (DeploymentNodeChangeListener)((EnterpriseExtensionsDomainContentProvider)this.getDomain().getContentProvider()).removeDeploymentListener(projectAreaHandle);
        }
        if (oldDeploymentChangeListener != null) {
            this.removeDefinitionItemListener(projectAreaHandle, oldDeploymentChangeListener);
        }
    }

    private void addDefinitionItemListener(IProjectAreaHandle projectAreaHandle, DeploymentNodeChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().addItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }

    private void removeDefinitionItemListener(IProjectAreaHandle projectAreaHandle, DeploymentNodeChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().removeItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }
}

