/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.ui;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.enterprise.automation.ui.AutomationDefinitionQueryNode;
import com.ibm.team.enterprise.deployment.internal.ui.nls.Messages;
import com.ibm.team.enterprise.deployment.ui.DeploymentUIPlugin;
import com.ibm.team.enterprise.deployment.ui.actions.QueryDeployedPackagesAction;
import com.ibm.team.enterprise.deployment.ui.actions.RequestDeployAction;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;

public class DeploymentDefinitionQueryNode
extends AutomationDefinitionQueryNode {
    private static final String templateDefPropertyId = "com.ibm.team.build.internal.template.id";

    public DeploymentDefinitionQueryNode(ITeamRepository repository, IBuildDefinitionStatusRecord record) {
        super(repository, record);
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        super.contributeContextMenuActions(manager, selection);
        List<BuildDomainQueryNode> queryNodes = this.getQueryNodesFromSelection(selection);
        List<IBuildDefinitionHandle> buildDefinitionHandles = this.getBuildDefinitionsFromQueryNodes(queryNodes);
        if ((queryNodes.size() <= 1 || queryNodes.size() != buildDefinitionHandles.size()) && queryNodes.size() <= 1) {
            BuildDomainQueryNode queryNode = queryNodes.get(0);
            if (queryNode.getQuery() instanceof BuildQueryByDefinition) {
                IContributionItem[] items;
                BuildQueryByDefinition queryByType = (BuildQueryByDefinition)queryNode.getQuery();
                ITeamRepository teamRepository = (ITeamRepository)((IBuildDefinitionHandle)queryByType.getBuildDefinitionHandles().get(0)).getOrigin();
                IContributionItem[] iContributionItemArray = items = manager.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    if (item instanceof ActionContributionItem) {
                        IAction action = ((ActionContributionItem)item).getAction();
                        String actionId = action.getId();
                        if (actionId.equals("request.build.type")) {
                            action.setText(Messages.DeploymentDefinitionActionHelper_LOAD_AND_DEPLOY);
                            manager.insertAfter("request.build.type", (IAction)new RequestDeployAction((ISelectionProvider)this.getViewer(), this.getViewer().getControl().getShell(), false));
                            manager.remove(item);
                        } else if (actionId.equals("open.build.definition")) {
                            action.setText(Messages.DeploymentDefinitionActionHelper_OPEN);
                        } else if (actionId.equals("open.latest.build")) {
                            action.setText(Messages.DeploymentDefinitionActionHelper_OPEN_LATEST_BUILD);
                        } else if (actionId.equals("show.builds.tag.and.definition")) {
                            action.setText(Messages.DeploymentDefinitionActionHelper_TAG_QUERY);
                        } else if (actionId.equals("jazz.open")) {
                            action.setText(Messages.DeploymentDefinitionActionHelper_SHOW_RESULTS);
                        }
                    }
                    ++n2;
                }
                try {
                    String templateId;
                    IBuildProperty property;
                    IBuildDefinition buildDef = (IBuildDefinition)teamRepository.itemManager().fetchCompleteItem((IItemHandle)queryByType.getBuildDefinitionHandles().get(0), 0, null);
                    if (buildDef != null && (property = buildDef.getProperty(templateDefPropertyId)) != null && (templateId = property.getValue()).contains("nonseq")) {
                        manager.insertAfter("show.builds.tag.and.definition", (IAction)new QueryDeployedPackagesAction((ISelection)selection, this.getViewer().getControl().getShell()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            manager.remove("move.build.items.to.folder");
        }
    }

    private List<BuildDomainQueryNode> getQueryNodesFromSelection(IStructuredSelection selection) {
        ArrayList<BuildDomainQueryNode> queryNodes = new ArrayList<BuildDomainQueryNode>();
        List list = selection.toList();
        for (Object object : list) {
            if (!(object instanceof BuildDomainQueryNode)) continue;
            queryNodes.add((BuildDomainQueryNode)object);
        }
        return queryNodes;
    }

    private List<IBuildDefinitionHandle> getBuildDefinitionsFromQueryNodes(List<BuildDomainQueryNode> queryNodes) {
        ArrayList<IBuildDefinitionHandle> buildDefinitionHandles = new ArrayList<IBuildDefinitionHandle>();
        for (BuildDomainQueryNode node : queryNodes) {
            BuildQuery query = node.getQuery();
            if (!(query instanceof BuildQueryByDefinition)) continue;
            BuildQueryByDefinition queryByType = (BuildQueryByDefinition)query;
            buildDefinitionHandles.addAll(queryByType.getBuildDefinitionHandles());
        }
        return buildDefinitionHandles;
    }

    public Image getImage() {
        Image undecoratedImage = DeploymentUIPlugin.getImage("icons/obj16/deployment_obj.gif");
        if (this.getStatus() == null) {
            return undecoratedImage;
        }
        return BuildCompositeImageRegistry.getImage((Image)undecoratedImage, (BuildStatus)this.getStatus());
    }
}

