/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.ui;

import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.editors.result.BuildResultPage;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.enterprise.automation.ui.table.IAutomationObjectsNode;
import com.ibm.team.enterprise.deployment.internal.ui.nls.Messages;
import com.ibm.team.enterprise.deployment.ui.DeployedObjectsIBMiTree;
import com.ibm.team.enterprise.deployment.ui.DeployedObjectsUnixTree;
import com.ibm.team.enterprise.deployment.ui.DeployedObjectsZTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class DeployedObjectsPage
extends BuildResultPage {
    private IBuildResultContribution[] fContributions;
    private IBuildResultContribution summaryContribution;
    private IProgressMonitor monitor;
    ITeamRepository repository;
    boolean isZosWorkItemDeploy = false;

    public DeployedObjectsPage(FormEditor editor, String id, String title, String[] contributionIds, IBuildResultContext buildResultContext, IBuildResultContribution[] fContributions, IBuildResultContribution summaryContribution, boolean isZosWorkItemDeploy, IProgressMonitor monitor) {
        super(editor, id, title, contributionIds, buildResultContext);
        this.fContributions = fContributions;
        this.summaryContribution = summaryContribution;
        this.monitor = monitor;
        this.isZosWorkItemDeploy = isZosWorkItemDeploy;
        this.repository = this.getBuildResultContext().getTeamRepository();
    }

    public void reset(String title, IBuildResultContribution[] contributions, IBuildResultContribution summaryContribution, boolean isZosWorkItemDeploy, IProgressMonitor monitor) {
        this.setPartName(title);
        this.summaryContribution = summaryContribution;
        this.fContributions = contributions;
        this.isZosWorkItemDeploy = isZosWorkItemDeploy;
        this.monitor = monitor;
    }

    protected void doCreatePageContent(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.setBorderStyle(2048);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.addSummary(parent, toolkit);
        if (this.fContributions.length > 0) {
            this.addDeployObjectsControl(parent, toolkit);
        }
    }

    public AbstractBuildResultPage.PageGroup getPageGroup() {
        return AbstractBuildResultPage.PageGroup.ADDITIONS;
    }

    private void addSummary(Composite body, FormToolkit toolkit) {
        Section section = toolkit.createSection(body, 256);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        section.setText(Messages.DeployedObjectsPage_SUMMARY_TITLE);
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.createSummaryLabel(composite, Messages.DeployedObjectsPage_PACKAGE_LABEL, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_LABEL), toolkit);
        this.createSummaryLabel(composite, Messages.DeployedObjectsPage_APPLICATION_NAME, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME), toolkit);
        this.createSummaryLabel(composite, Messages.DeployedObjectsPage_VERSION, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION), toolkit);
        this.createSummaryLabel(composite, Messages.DeployedObjectsPage_APPLICATION_DESCRIPTION, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_DESCRIPTION), toolkit);
        this.createSummaryLabel(composite, Messages.DeployedObjectsPage_HOSTNAME, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_HOST_NAME), toolkit);
        this.createSummaryLabel(composite, Messages.DeployedObjectsPage_PACKAGE_DIR, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_DIR), toolkit);
        String timestamp = this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP);
        this.createSummaryLabel(composite, Messages.DeployedObjectsPage_TIMESTAMP, timestamp, toolkit);
        String summaryWorkitemId = this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_SUMMARY_WORKITEM);
        if (summaryWorkitemId == null || summaryWorkitemId.equals("-1")) {
            this.createSummaryLabel(composite, Messages.DeployedObjectsPage_SUMMARY_WORK_ITEM, Messages.DeployedObjectsSummaryPage_SUMMARY_WORK_ITEM_NOT_CREATED, toolkit);
        } else {
            this.createHyperlink(composite, Messages.DeployedObjectsPage_SUMMARY_WORK_ITEM, summaryWorkitemId, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_SUMMARY_WORKITEM_UUID), toolkit);
        }
    }

    private void createHyperlink(Composite parent, String label, String workItemNumber, final String workItemUUID, FormToolkit toolkit) {
        if (workItemNumber != null && workItemUUID != null) {
            toolkit.createLabel(parent, label);
            Hyperlink summaryHyperlink = toolkit.createHyperlink(parent, workItemNumber, 0);
            summaryHyperlink.setEnabled(true);
            summaryHyperlink.setUnderlined(true);
            summaryHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemUUID), null);
                    ArrayList<String> properties = new ArrayList<String>();
                    properties.add(IWorkItem.PROJECT_AREA_PROPERTY);
                    properties.add(IWorkItem.ID_PROPERTY);
                    try {
                        IWorkItem workItem = (IWorkItem)DeployedObjectsPage.this.repository.itemManager().fetchPartialItem((IItemHandle)workItemHandle, 0, properties, DeployedObjectsPage.this.monitor);
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null) {
                            WorkItemUI.open((IWorkbenchPage)window.getActivePage(), (Object)workItem);
                        }
                    }
                    catch (TeamRepositoryException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
    }

    private void createSummaryLabel(Composite parent, String label, String value, FormToolkit toolkit) {
        if (value == null) {
            return;
        }
        toolkit.createLabel(parent, label);
        toolkit.createLabel(parent, value);
    }

    private void addDeployObjectsControl(Composite body, FormToolkit toolkit) {
        Section section = toolkit.createSection(body, 256);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section);
        String typeId = this.summaryContribution.getExtendedContributionTypeId();
        if (typeId.equals(AutomationResultContribution.DEPLOYMENT_OVERVIEW_EXTENDED_CONTRIBUTION_ID)) {
            section.setText(Messages.DeployedObjectsContributionProvider_SUMMARY_TITLE);
        } else {
            section.setText(Messages.RollbackObjectsContributionProvider_SUMMARY_TITLE);
        }
        if (this.fContributions.length == 0) {
            toolkit.createLabel((Composite)section, Messages.DeployedObjectsTable_NO_OBJECTS_DEPLOYED);
        } else {
            Composite outerComposite = toolkit.createComposite((Composite)section);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outerComposite);
            GridLayoutFactory.fillDefaults().applyTo(outerComposite);
            section.setClient((Control)outerComposite);
            if (this.summaryContribution.getLabel().equals("ibmi")) {
                toolkit.createLabel(outerComposite, Messages.DeployedObjectsTable_DOUBLECLICK_MSG);
                DeployedObjectsIBMiTree tree = new DeployedObjectsIBMiTree(toolkit, false, this.fContributions);
                tree.createContents(outerComposite);
                TreeViewer treeViewer = tree.getTreeViewer();
                treeViewer.addDoubleClickListener(this.getDoubleClickListener(treeViewer));
                tree.getTree().setToolTipText(Messages.DeployedObjectsTable_DOUBLECLICK_MSG);
            } else if (this.summaryContribution.getLabel().equals("luw")) {
                DeployedObjectsUnixTree tree = new DeployedObjectsUnixTree(toolkit, false, this.fContributions);
                tree.createContents(outerComposite);
            } else if (this.summaryContribution.getLabel().equals("zos")) {
                toolkit.createLabel(outerComposite, Messages.DeployedObjectsTable_DOUBLECLICK_MSG);
                DeployedObjectsZTree tree = new DeployedObjectsZTree(toolkit, this.isZosWorkItemDeploy, this.fContributions);
                tree.createContents(outerComposite);
                TreeViewer treeViewer = tree.getTreeViewer();
                treeViewer.addDoubleClickListener(this.getDoubleClickListener(treeViewer));
                tree.getTree().setToolTipText(Messages.DeployedObjectsTable_DOUBLECLICK_MSG);
            }
        }
    }

    private IDoubleClickListener getDoubleClickListener(final TreeViewer treeViewer) {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = treeViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                try {
                    IAutomationObjectsNode node;
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof IAutomationObjectsNode && (node = (IAutomationObjectsNode)element).getWorkItemUUID() != null) {
                        IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)node.getWorkItemUUID()), null);
                        ArrayList<String> properties = new ArrayList<String>();
                        properties.add(IWorkItem.PROJECT_AREA_PROPERTY);
                        properties.add(IWorkItem.ID_PROPERTY);
                        IWorkItem item = (IWorkItem)DeployedObjectsPage.this.repository.itemManager().fetchPartialItem((IItemHandle)workItemHandle, 0, properties, DeployedObjectsPage.this.monitor);
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        WorkItemUI.open((IWorkbenchPage)window.getActivePage(), (Object)item);
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
            }
        };
    }

    protected Viewer getViewer() {
        return null;
    }
}

