/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.ui;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.enterprise.deployment.internal.ui.nls.Messages;
import com.ibm.team.enterprise.deployment.ui.DeployedObjectsPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.forms.editor.FormEditor;

public class DeployObjectContributionProvider
extends AbstractBuildResultContributionProvider {
    private IBuildResultContribution[] fContributions;
    private IBuildResultContribution summaryContribution;
    boolean isDeployment;
    boolean isRollback;
    boolean isLoad = false;
    private IProgressMonitor monitor;
    private boolean isZosWorkItemDeploy = false;
    private DeployedObjectsPage page;

    public DeployObjectContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fContributions = this.getBuildResultContext().getBuildResultContributions(new String[]{AutomationResultContribution.DEPLOYED_OBJECT_EXTENDED_CONTRIBUTION_ID});
        this.monitor = monitor;
        IBuildResultContribution[] workItemContributions = this.getBuildResultContext().getBuildResultContributions(new String[]{"fixedWorkItems"});
        boolean bl = this.isZosWorkItemDeploy = workItemContributions != null && workItemContributions.length > 0;
        if (this.getBuildResultContext().getBuildResultContributions(new String[]{AutomationResultContribution.DEPLOYMENT_OVERVIEW_EXTENDED_CONTRIBUTION_ID}).length > 0) {
            this.summaryContribution = this.getBuildResultContext().getBuildResultContributions(new String[]{AutomationResultContribution.DEPLOYMENT_OVERVIEW_EXTENDED_CONTRIBUTION_ID})[0];
            this.isDeployment = true;
            this.isRollback = false;
            this.isLoad = false;
        } else if (this.getBuildResultContext().getBuildResultContributions(new String[]{AutomationResultContribution.ROLLBACK_OVERVIEW_EXTENDED_CONTRIBUTION_ID}).length > 0) {
            this.summaryContribution = this.getBuildResultContext().getBuildResultContributions(new String[]{AutomationResultContribution.ROLLBACK_OVERVIEW_EXTENDED_CONTRIBUTION_ID})[0];
            this.isRollback = true;
            this.isDeployment = false;
            this.isLoad = false;
        } else if (this.getBuildResultContext().getBuildResultContributions(new String[]{AutomationResultContribution.LOAD_OVERVIEW_EXTENDED_CONTRIBUTION_ID}).length > 0) {
            this.summaryContribution = this.getBuildResultContext().getBuildResultContributions(new String[]{AutomationResultContribution.LOAD_OVERVIEW_EXTENDED_CONTRIBUTION_ID})[0];
            this.isLoad = true;
            this.isDeployment = false;
            this.isRollback = false;
        }
        if (this.page != null) {
            this.page.reset(this.getPageLabel(), this.fContributions, this.summaryContribution, this.isZosWorkItemDeploy, monitor);
        }
    }

    public String[] getExtendedContributionIds() {
        return new String[]{AutomationResultContribution.DEPLOYED_OBJECT_EXTENDED_CONTRIBUTION_ID, AutomationResultContribution.DEPLOYMENT_OVERVIEW_EXTENDED_CONTRIBUTION_ID, AutomationResultContribution.LOAD_OVERVIEW_EXTENDED_CONTRIBUTION_ID, AutomationResultContribution.ROLLBACK_OVERVIEW_EXTENDED_CONTRIBUTION_ID};
    }

    public BuildStatus getStatus() {
        return BuildStatus.OK;
    }

    public boolean isSummaryLink() {
        return this.isDeployment || this.isRollback || this.isLoad;
    }

    public void summaryLinkActivated() {
        this.getBuildResultEditor().setActivePage(this.getExtensionId());
    }

    public String getSummaryTitle() {
        if (this.isDeployment) {
            return Messages.DeployedObjects_SUMMARY_TITLE;
        }
        if (this.isRollback) {
            return Messages.RollbackObjects_SUMMARY_TITLE;
        }
        return Messages.LoadPackage_SUMMARY_TITLE;
    }

    public String getSummaryText() {
        if (this.isDeployment || this.isRollback) {
            if (this.fContributions.length > 1) {
                if (this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME) != null) {
                    return NLS.bind((String)Messages.DeployedObjectsContributionProvider_SUMMARY_TEXT_MULTIPLE_CONTRIBUTIONS, (Object[])new Object[]{this.fContributions.length, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME), this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION)});
                }
                return NLS.bind((String)Messages.DeployedObjectsContributionProvider_SUMMARY_TEXT_MULTIPLE_CONTRIBUTIONS_NO_APPNAME, (Object[])new Object[]{this.fContributions.length});
            }
            if (this.fContributions.length == 1) {
                if (this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME) != null) {
                    return NLS.bind((String)Messages.DeployedObjectsContributionProvider_SUMMARY_TEXT_ONE_CONTRIBUTION, (Object)this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME), (Object)this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION));
                }
                return Messages.DeployedObjectsContributionProvider_SUMMARY_TEXT_ONE_CONTRIBUTION_NO_APPNAME;
            }
            return Messages.DeployedObjectsContributionProvider_SUMMARY_TEXT_NO_CONTRIBUTION;
        }
        if (this.isLoad) {
            if (this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME) != null) {
                return NLS.bind((String)Messages.LoadPackage_SUMMARY_TEXT_LOADED_PACKAGE, (Object)this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME), (Object)this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION));
            }
            String timestamp = this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP);
            return timestamp;
        }
        return Messages.DeployedObjectsContributionProvider_SUMMARY_TEXT_NO_CONTRIBUTION;
    }

    private String getPageLabel() {
        if (this.isDeployment) {
            return Messages.DeployedObjectsContributionProvider_TAB_SUMMARY_TITLE;
        }
        if (this.isRollback) {
            return Messages.RollbackObjectsContributionProvider_TAB_SUMMARY_TITLE;
        }
        return Messages.LoadPackageContributionProvider_TAB_SUMMARY_TITLE;
    }

    public AbstractBuildResultPage getBuildResultPage() {
        if (this.page == null) {
            this.page = new DeployedObjectsPage(this.getBuildResultEditor(), this.getExtensionId(), this.getPageLabel(), this.getExtendedContributionIds(), this.getBuildResultContext(), this.fContributions, this.summaryContribution, this.isZosWorkItemDeploy, this.monitor);
        }
        return this.page;
    }
}

