/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.internal.ui.editors;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.common.model.query.IBaseBuildEngineQueryModel;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.automation.internal.ui.editors.AbstractAutomationConfigurationEditor;
import com.ibm.team.enterprise.automation.internal.ui.nls.Messages;
import com.ibm.team.enterprise.automation.ui.RestoreMappingComposite;
import com.ibm.team.enterprise.deployment.dialogs.DeploymentBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.deployment.internal.listeners.LoadConfigChangeListener;
import com.ibm.team.enterprise.deployment.internal.ui.editors.CopyLoadConfigComposite;
import com.ibm.team.enterprise.deployment.internal.ui.editors.FTPLoadConfigComposite;
import com.ibm.team.enterprise.deployment.ui.DeploymentUIPlugin;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.teami.filesystem.common.validators.IBMiLibraryValidator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.progress.UIJob;

public class DeploymentNonSequentialConfigurationEditor
extends AbstractAutomationConfigurationEditor
implements LoadConfigChangeListener {
    private static final String DEPLOY_DIRECTORY_VARIABLE = "$\\{team.deploy.common.deployPackage.dir}";
    private static final String DEPLOY_HFS_DIRECTORY_VARIABLE = "$\\{team.enterprise.deployment.hfs.runtimeRoot.dir}";
    private static final String SAVEROLLBACKDIR_VARIABLE = "$\\{saveRollbackDir}";
    private static final String RESTOREROLLBACKDIR_VARIABLE = "$\\{restoreRollbackDir}";
    private Text localPackageRootText;
    private Text remotePackageRootText;
    private Text zosDeployScriptText;
    private Text zosTemporaryPDSPrefixText;
    private Text deployPreCommandText;
    private Text deployPostCommandText;
    private Text rollbackPreCommandText;
    private Text rollbackPostCommandText;
    private Text hfsTargetDirText;
    private Text loadPreCommandText;
    private Text loadPostCommandtext;
    private Text ibmiSaveFileLibraryText;
    private Text luwRuntimeRootDirText;
    private Text ibmiRestorePfUsrCmdText;
    private Button multiRollbackButton;
    private Text maximumRollbackText;
    private Button ibmiRestorePfReplaceMethod;
    private Button ibmiRestorePfMigrateMethod;
    private Button ibmiRestorePfUsrCmdMethod;
    private Button ibmiSavePfForRollbackButton;
    private Button publishCumulativeDeploy;
    private Button publishDeltaDeploy;
    private Button publishRollbackManifest;
    private Composite loadMethodConfigCompositeContainer;
    private final StackLayout loadMethodConfigLayout = new StackLayout();
    private CopyLoadConfigComposite copyLoadConfigComposite;
    private FTPLoadConfigComposite ftpLoadConfigComposite;
    private RestoreMappingComposite restoreMappingComposite;
    private Combo fDeployLoadTypeCombo;
    private Composite fDeploymentLoadOptionsComposite;
    protected Text fPackageDefinitionNameText;
    protected Button fSelectPackageDefinitionButton;
    private CTabFolder tabFolder;
    private int tabFolderIndex = 0;
    private CTabItem loadTab;
    private CTabItem deployTab;
    private CTabItem publishTab;

    public DeploymentNonSequentialConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    protected void createApplicationPropertySection(Composite parent, FormToolkit toolkit) {
    }

    protected void createApplicationProperties(Composite parent, FormToolkit toolkit) {
    }

    protected void createPackageProperties(Composite parent, FormToolkit toolkit) {
    }

    protected void createRuntimeProperties(Composite parent, FormToolkit toolkit) {
        IBuildProperty property;
        if (!this.isLUWDeployDef()) {
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.restoreMappingList");
            Composite mappingParentComposite = toolkit.createComposite(parent);
            TableWrapData data = new TableWrapData(256, 256, 1, 2);
            TableWrapLayout layout = new TableWrapLayout();
            layout.numColumns = 3;
            layout.leftMargin = 0;
            layout.rightMargin = 0;
            mappingParentComposite.setLayout((Layout)layout);
            mappingParentComposite.setLayoutData((Object)data);
            TableWrapData tableWrapData = new TableWrapData(128, 32, 1, 3);
            tableWrapData.heightHint = 0;
            Label hiddenLabel = toolkit.createLabel(mappingParentComposite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_RESTORE_MAPPING_TABLE_HIDDEN_LABEL);
            hiddenLabel.setVisible(false);
            hiddenLabel.setLayoutData((Object)tableWrapData);
            this.restoreMappingComposite = new RestoreMappingComposite(mappingParentComposite, "team.deploy.common.restoreMappingList", (AbstractAutomationConfigurationEditor)this, this.fBuildDefinitionWorkingCopy);
        }
        if (this.isZosDeployDefNonSeq()) {
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.deployment.hfs.runtimeRoot.dir");
            this.hfsTargetDirText = this.createLabeledText(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_TEXT_HFSROOT_DIR, property == null ? "" : property.getValue(), com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_TEXT_HFSROOT_DIR_TOOLTIP);
            this.hfsTargetDirText.addModifyListener(this.getTextModifyListener("team.enterprise.deployment.hfs.runtimeRoot.dir", this.hfsTargetDirText, true));
        }
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.deploy.preCommand");
        String preDeployCommandTooltip = null;
        String postDeployCommandTooltip = null;
        String preRollbackCommandTooltip = null;
        String postRollbackCommandTooltip = null;
        if (this.isZosDeployDefNonSeq()) {
            preDeployCommandTooltip = NLS.bind((String)Messages.CommandPropertiesTooltip, (Object)"$\\{team.deploy.common.deployPackage.dir}<br>$\\{team.enterprise.deployment.hfs.runtimeRoot.dir}");
            postDeployCommandTooltip = NLS.bind((String)Messages.CommandPropertiesTooltip, (Object)"$\\{team.deploy.common.deployPackage.dir}<br>$\\{team.enterprise.deployment.hfs.runtimeRoot.dir}<br>$\\{saveRollbackDir}");
            preRollbackCommandTooltip = NLS.bind((String)Messages.CommandPropertiesTooltip, (Object)RESTOREROLLBACKDIR_VARIABLE);
            postRollbackCommandTooltip = NLS.bind((String)Messages.CommandPropertiesTooltip, (Object)RESTOREROLLBACKDIR_VARIABLE);
        }
        this.deployPreCommandText = this.createLabeledText(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_TEXT_DEPLOY_PRECOMMAND, property.getValue(), preDeployCommandTooltip);
        this.deployPreCommandText.addModifyListener(this.getTextModifyListener("team.deploy.common.deploy.preCommand", this.deployPreCommandText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.deploy.postCommand");
        this.deployPostCommandText = this.createLabeledText(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_TEXT_DEPLOY_POSTCOMMAND, property.getValue(), postDeployCommandTooltip);
        this.deployPostCommandText.addModifyListener(this.getTextModifyListener("team.deploy.common.deploy.postCommand", this.deployPostCommandText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.rollback.preCommand");
        this.rollbackPreCommandText = this.createLabeledText(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_TEXT_ROLLBACK_PRECOMMAND, property.getValue(), preRollbackCommandTooltip);
        this.rollbackPreCommandText.addModifyListener(this.getTextModifyListener("team.deploy.common.rollback.preCommand", this.rollbackPreCommandText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.rollback.postCommand");
        this.rollbackPostCommandText = this.createLabeledText(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_TEXT_ROLLBACK_POSTCOMMAND, property.getValue(), postRollbackCommandTooltip);
        this.rollbackPostCommandText.addModifyListener(this.getTextModifyListener("team.deploy.common.rollback.postCommand", this.rollbackPostCommandText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.rollback.multipleAllowed");
        boolean multiRollback = false;
        multiRollback = property == null || property.getValue() == null ? false : Boolean.parseBoolean(property.getValue());
        this.multiRollbackButton = toolkit.createButton(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_BUTTON_MULTI_ROLLBACK, 32);
        this.multiRollbackButton.setSelection(multiRollback);
        this.multiRollbackButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentNonSequentialConfigurationEditor.this.validate();
                boolean isSelected = DeploymentNonSequentialConfigurationEditor.this.multiRollbackButton.getSelection();
                DeploymentNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.deploy.common.rollback.multipleAllowed", Boolean.toString(isSelected));
                DeploymentNonSequentialConfigurationEditor.this.maximumRollbackText.setEnabled(isSelected);
                DeploymentNonSequentialConfigurationEditor.this.setDirty(true);
            }
        });
        TableWrapData multiRollbackData = new TableWrapData(256, 256);
        multiRollbackData.colspan = 2;
        this.multiRollbackButton.setLayoutData((Object)multiRollbackData);
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.rollback.maximumKeep");
        int rollbackMaxValue = property == null || property.getValue() == null ? 1 : Integer.parseInt(property.getValue());
        this.maximumRollbackText = this.createLabeledText(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_TEXT_ROLLBACK_MAXIMUM, String.valueOf(rollbackMaxValue));
        this.maximumRollbackText.setEnabled(multiRollback);
        this.maximumRollbackText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String textValue = DeploymentNonSequentialConfigurationEditor.this.maximumRollbackText.getText();
                if (DeploymentNonSequentialConfigurationEditor.this.isPositiveIntegerOrZero(textValue)) {
                    DeploymentNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.deploy.common.rollback.maximumKeep", textValue);
                    DeploymentNonSequentialConfigurationEditor.this.setDirty(true);
                }
                DeploymentNonSequentialConfigurationEditor.this.validate();
            }
        });
        if (this.isIBMiDeployDefNonSeq()) {
            this.createIBMiRestorePfOptionSection(parent, toolkit);
        }
        if (this.isZosDeployDefNonSeq()) {
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.deploy.tempPdsPrefix");
            String propertyValue = "";
            if (property != null && property.getValue().trim().length() != 0) {
                propertyValue = property.getValue().trim();
            }
            this.zosTemporaryPDSPrefixText = this.createLabeledText(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_TEXT_TEMPORARY_PDS_PREFIX, propertyValue, Messages.ZosTempPDSPrefixTooltip);
            this.zosTemporaryPDSPrefixText.addModifyListener(this.getTextModifyListener("team.deploy.common.deploy.tempPdsPrefix", this.zosTemporaryPDSPrefixText));
        }
    }

    protected void createIBMiRestorePfOptionSection(Composite parent, FormToolkit toolkit) {
        IBuildProperty restoreOptionProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.ibmi.pfRestoreMethod");
        boolean restoreOptionNotSet = false;
        if (restoreOptionProperty == null || restoreOptionProperty.getValue() == null) {
            restoreOptionNotSet = true;
        }
        Section section = toolkit.createSection(parent, 384);
        TableWrapData sectionData = new TableWrapData(256, 256);
        sectionData.colspan = 2;
        section.setLayoutData((Object)sectionData);
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_SECTION_DEPLOY_IBMI_PF);
        section.setDescription(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_SECTION_DEPLOY_IBMI_PF_DESCRIPTION);
        Composite composite = toolkit.createComposite((Composite)section);
        TableWrapData compositeData = new TableWrapData(256, 256);
        compositeData.colspan = 2;
        composite.setLayoutData((Object)compositeData);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.ibmiRestorePfReplaceMethod = toolkit.createButton(composite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_BUTTON_DEPLOY_IBMI_RESTORE_PF_DEFAULT, 16);
        boolean selected = restoreOptionNotSet || "REPLACE".equals(restoreOptionProperty.getValue());
        this.ibmiRestorePfReplaceMethod.setSelection(selected);
        this.ibmiRestorePfReplaceMethod.setData((Object)"REPLACE");
        this.ibmiRestorePfReplaceMethod.setEnabled(true);
        this.ibmiRestorePfReplaceMethod.addSelectionListener(this.getIbmiRstPfReplaceListener());
        this.ibmiRestorePfReplaceMethod.setLayoutData((Object)new TableWrapData());
        this.ibmiRestorePfMigrateMethod = toolkit.createButton(composite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_BUTTON_DEPLOY_IBMI_RESTORE_PF_MIGRATE, 16);
        selected = !restoreOptionNotSet && "MIGRATE".equals(restoreOptionProperty.getValue());
        this.ibmiRestorePfMigrateMethod.setSelection(selected);
        this.ibmiRestorePfMigrateMethod.setData((Object)"MIGRATE");
        this.ibmiRestorePfMigrateMethod.setEnabled(true);
        this.ibmiRestorePfMigrateMethod.addSelectionListener(this.getIbmiRstPfMigrateListener());
        this.ibmiRestorePfMigrateMethod.setLayoutData((Object)new TableWrapData());
        this.ibmiRestorePfUsrCmdMethod = toolkit.createButton(composite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_BUTTON_DEPLOY_IBMI_RESTORE_PF_USRCMD, 16);
        selected = !restoreOptionNotSet && "USRCMD".equals(restoreOptionProperty.getValue());
        this.ibmiRestorePfUsrCmdMethod.setSelection(selected);
        this.ibmiRestorePfUsrCmdMethod.setData((Object)"USRCMD");
        this.ibmiRestorePfUsrCmdMethod.setEnabled(true);
        this.ibmiRestorePfUsrCmdMethod.addSelectionListener(this.getIbmiRstPfUsrCmdListener());
        this.ibmiRestorePfUsrCmdMethod.setLayoutData((Object)new TableWrapData());
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.ibmi.pfRestoreUsrCmd");
        String propertyValue = "";
        if (property != null) {
            propertyValue = property.getValue();
        }
        this.ibmiRestorePfUsrCmdText = toolkit.createText(composite, propertyValue, 0);
        selected = !restoreOptionNotSet && "USRCMD".equals(restoreOptionProperty.getValue());
        this.ibmiRestorePfUsrCmdText.setEnabled(selected);
        this.ibmiRestorePfUsrCmdText.addModifyListener(this.getTextModifyListener("team.deploy.ibmi.pfRestoreUsrCmd", this.ibmiRestorePfUsrCmdText));
        TableWrapData textEntryData = new TableWrapData(256, 256);
        textEntryData.indent = 15;
        this.ibmiRestorePfUsrCmdText.setLayoutData((Object)textEntryData);
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.ibmi.savePfForRollback");
        this.ibmiSavePfForRollbackButton = toolkit.createButton(composite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_BUTTON_SAVE_PF_FOR_ROLLBACK, 32);
        if (property != null) {
            boolean boolPropertyValue = Boolean.parseBoolean(property.getValue());
            this.ibmiSavePfForRollbackButton.setSelection(boolPropertyValue);
        } else {
            this.ibmiSavePfForRollbackButton.setSelection(true);
        }
        this.ibmiSavePfForRollbackButton.addSelectionListener(this.getButtonSelectionListener("team.deploy.ibmi.savePfForRollback", this.ibmiSavePfForRollbackButton));
    }

    protected SelectionListener getIbmiRstPfReplaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeploymentNonSequentialConfigurationEditor.this.ibmiRestorePfReplaceMethod.getSelection()) {
                    DeploymentNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.deploy.ibmi.pfRestoreMethod", "REPLACE");
                    DeploymentNonSequentialConfigurationEditor.this.ibmiRestorePfUsrCmdText.setEnabled(false);
                    DeploymentNonSequentialConfigurationEditor.this.validate();
                    DeploymentNonSequentialConfigurationEditor.this.setDirty(true);
                }
            }
        };
    }

    protected SelectionListener getIbmiRstPfMigrateListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeploymentNonSequentialConfigurationEditor.this.ibmiRestorePfMigrateMethod.getSelection()) {
                    DeploymentNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.deploy.ibmi.pfRestoreMethod", "MIGRATE");
                    DeploymentNonSequentialConfigurationEditor.this.ibmiRestorePfUsrCmdText.setEnabled(false);
                    DeploymentNonSequentialConfigurationEditor.this.validate();
                    DeploymentNonSequentialConfigurationEditor.this.setDirty(true);
                }
            }
        };
    }

    protected SelectionListener getIbmiRstPfUsrCmdListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeploymentNonSequentialConfigurationEditor.this.ibmiRestorePfUsrCmdMethod.getSelection()) {
                    DeploymentNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.deploy.ibmi.pfRestoreMethod", "USRCMD");
                    DeploymentNonSequentialConfigurationEditor.this.ibmiRestorePfUsrCmdText.setEnabled(true);
                    DeploymentNonSequentialConfigurationEditor.this.validate();
                    DeploymentNonSequentialConfigurationEditor.this.setDirty(true);
                }
            }
        };
    }

    protected void createPublishProperties(Composite parent, FormToolkit toolkit) {
        boolean propertyValue;
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.publishDeltaDeploy");
        this.publishDeltaDeploy = toolkit.createButton(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.PUBLISH_DELTA_DEPLOY, 32);
        if (property != null) {
            boolean propertyValue2 = Boolean.parseBoolean(property.getValue());
            this.publishDeltaDeploy.setSelection(propertyValue2);
        } else {
            this.publishDeltaDeploy.setSelection(false);
        }
        TableWrapData buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.publishDeltaDeploy.setLayoutData((Object)buttonData);
        this.publishDeltaDeploy.addSelectionListener(this.getButtonSelectionListener("team.deploy.common.publishDeltaDeploy", this.publishDeltaDeploy));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.publishCumulativeDeploy");
        this.publishCumulativeDeploy = toolkit.createButton(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.PUBLISH_CUMULATIVE_DEPLOY, 32);
        if (property != null) {
            propertyValue = Boolean.parseBoolean(property.getValue());
            this.publishCumulativeDeploy.setSelection(propertyValue);
        } else {
            this.publishCumulativeDeploy.setSelection(false);
        }
        buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.publishCumulativeDeploy.setLayoutData((Object)buttonData);
        this.publishCumulativeDeploy.addSelectionListener(this.getButtonSelectionListener("team.deploy.common.publishCumulativeDeploy", this.publishCumulativeDeploy));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.publishRollbackManifest");
        this.publishRollbackManifest = toolkit.createButton(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.PUBLISH_ROLLBACK_MANIFEST, 32);
        if (property != null) {
            propertyValue = Boolean.parseBoolean(property.getValue());
            this.publishRollbackManifest.setSelection(propertyValue);
        } else {
            this.publishRollbackManifest.setSelection(false);
        }
        buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.publishRollbackManifest.setLayoutData((Object)buttonData);
        this.publishRollbackManifest.addSelectionListener(this.getButtonSelectionListener("team.deploy.common.publishRollbackManifest", this.publishRollbackManifest));
    }

    protected void createPlatformProperties(Composite parent, FormToolkit toolkit) {
        if (this.isIBMiDeployDef()) {
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.ibmi.intermediateSaveFileLibrary");
            this.ibmiSaveFileLibraryText = this.createLabeledText(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.IBMI_PACKAGING_SAVEFILE_LIBRARY, property.getValue());
            this.ibmiSaveFileLibraryText.addModifyListener(this.getTextModifyListener("team.deploy.ibmi.intermediateSaveFileLibrary", this.ibmiSaveFileLibraryText));
        } else if (this.isLUWDeployDef()) {
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.luw.runtimeRoot.dir");
            this.luwRuntimeRootDirText = this.createLabeledText(parent, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.LUW_PACKAGING_RUNTIME_ROOT_DIR, property.getValue());
            this.luwRuntimeRootDirText.addModifyListener(this.getTextModifyListener("team.deploy.luw.runtimeRoot.dir", this.luwRuntimeRootDirText));
        } else {
            Composite grandParent = parent.getParent();
            if (grandParent instanceof Section) {
                grandParent.setVisible(false);
            }
            parent.setVisible(false);
        }
    }

    protected void createExtensibleContributionSection(Composite parent, FormToolkit toolkit) {
        Section fdeploymentSection = toolkit.createSection(parent, 450);
        fdeploymentSection.setLayoutData((Object)new TableWrapData(256, 256));
        fdeploymentSection.setLayout((Layout)new TableWrapLayout());
        fdeploymentSection.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_SECTION_DEPLOYMENT);
        Composite fDeploymentPropertyComposite = toolkit.createComposite((Composite)fdeploymentSection);
        fDeploymentPropertyComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 14;
        fDeploymentPropertyComposite.setLayout((Layout)layout);
        this.createLoadPropertySection(fDeploymentPropertyComposite, toolkit);
        this.createDeploymentPropertiesSection(parent, toolkit);
    }

    public Control getFocusControl() {
        return this.fSelectPackageDefinitionButton;
    }

    private void createDeploymentPropertiesSection(Composite parent, FormToolkit toolkit) {
        Section fdeploymentSection = toolkit.createSection(parent, 4480);
        fdeploymentSection.setTitleBarBorderColor(Display.getCurrent().getSystemColor(1));
        fdeploymentSection.setTitleBarBackground(Display.getCurrent().getSystemColor(1));
        fdeploymentSection.setLayoutData((Object)new TableWrapData(256, 256));
        fdeploymentSection.setLayout((Layout)new TableWrapLayout());
        if (this.isIBMiDeployDef()) {
            fdeploymentSection.setDescription(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_SECTION_DEPLOY_DESCRIPTION_IBMi);
        } else {
            fdeploymentSection.setDescription(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_SECTION_DEPLOY_DESCRIPTION_zOS);
        }
        Composite fDeploymentPropertyComposite = toolkit.createComposite((Composite)fdeploymentSection);
        fDeploymentPropertyComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        fDeploymentPropertyComposite.setLayout((Layout)layout);
        TableWrapData layoutData = new TableWrapData(256, 256);
        fDeploymentPropertyComposite.setLayoutData((Object)layoutData);
        this.createRuntimeProperties(fDeploymentPropertyComposite, toolkit);
        fdeploymentSection.setClient((Control)fDeploymentPropertyComposite);
    }

    private void createLoadPropertySection(Composite parent, FormToolkit toolkit) {
        Section loadOptionsSection = toolkit.createSection(parent, 4352);
        loadOptionsSection.setTitleBarBorderColor(Display.getCurrent().getSystemColor(1));
        loadOptionsSection.setTitleBarBackground(Display.getCurrent().getSystemColor(1));
        TableWrapLayout loadOptionsSectionLayout = new TableWrapLayout();
        loadOptionsSectionLayout.numColumns = 14;
        loadOptionsSectionLayout.topMargin = 0;
        loadOptionsSectionLayout.leftMargin = 0;
        loadOptionsSectionLayout.rightMargin = 0;
        loadOptionsSection.setLayout((Layout)new TableWrapLayout());
        loadOptionsSection.setLayoutData((Object)new TableWrapData(256, 256));
        loadOptionsSection.setDescription(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_SECTION_LOAD_DESCRIPTION);
        Composite fLoadOptionsComposite = toolkit.createComposite((Composite)loadOptionsSection);
        TableWrapLayout fLoadOptionsLayout = new TableWrapLayout();
        fLoadOptionsLayout.numColumns = 2;
        fLoadOptionsLayout.topMargin = 0;
        fLoadOptionsLayout.leftMargin = 0;
        fLoadOptionsLayout.rightMargin = 0;
        fLoadOptionsComposite.setLayout((Layout)fLoadOptionsLayout);
        fLoadOptionsComposite.setLayoutData((Object)new TableWrapData(256, 256));
        Composite loadMethodsComposite = toolkit.createComposite(fLoadOptionsComposite, 0);
        TableWrapData layoutData = new TableWrapData(256, 256);
        TableWrapLayout loadMethodsLayout = new TableWrapLayout();
        loadMethodsLayout.numColumns = 4;
        loadMethodsLayout.leftMargin = 0;
        loadMethodsLayout.rightMargin = 0;
        loadMethodsLayout.topMargin = 0;
        loadMethodsComposite.setLayout((Layout)loadMethodsLayout);
        TableWrapData loadlayoutData = new TableWrapData(256, 256);
        loadlayoutData.colspan = 2;
        loadlayoutData.grabHorizontal = true;
        loadMethodsComposite.setLayoutData((Object)loadlayoutData);
        IBuildProperty loadProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.loadMethod");
        String loadMethod = loadProperty.getValue();
        Section fSection = new Section(loadMethodsComposite, 4160);
        TableWrapLayout sectionLayout = new TableWrapLayout();
        sectionLayout.leftMargin = 0;
        sectionLayout.rightMargin = 0;
        sectionLayout.topMargin = 0;
        fSection.setLayout((Layout)sectionLayout);
        TableWrapData sectionData = new TableWrapData(256, 256);
        sectionData.colspan = 4;
        fSection.setLayoutData((Object)sectionData);
        this.fDeploymentLoadOptionsComposite = toolkit.createComposite((Composite)fSection, 0);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 4;
        layout.topMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.verticalSpacing = 0;
        this.fDeploymentLoadOptionsComposite.setLayout((Layout)layout);
        TableWrapData deploymentLoadOptionsLayoutData = new TableWrapData(256, 256);
        deploymentLoadOptionsLayoutData.grabHorizontal = true;
        this.fDeploymentLoadOptionsComposite.setLayoutData((Object)deploymentLoadOptionsLayoutData);
        Label comboLabel = new Label(this.fDeploymentLoadOptionsComposite, 0);
        comboLabel.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentLoadOptionSection_LOADTYPE_LABEL);
        this.fDeployLoadTypeCombo = new Combo(this.fDeploymentLoadOptionsComposite, 12);
        TableWrapData comboData = new TableWrapData(256, 256);
        comboData.colspan = 3;
        this.fDeployLoadTypeCombo.setLayoutData((Object)comboData);
        this.fDeployLoadTypeCombo.add(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentLoadOptionSection_COPY_OPTION);
        this.fDeployLoadTypeCombo.add(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentLoadOptionSection_FTP_OPTION);
        this.fDeployLoadTypeCombo.select(1);
        fSection.setClient((Control)this.fDeploymentLoadOptionsComposite);
        final Group aComposite = new Group(loadMethodsComposite, 0);
        TableWrapLayout aCompositeLayout = new TableWrapLayout();
        aCompositeLayout.topMargin = 0;
        aCompositeLayout.verticalSpacing = 0;
        aComposite.setLayout((Layout)aCompositeLayout);
        layoutData = new TableWrapData(256, 256);
        layoutData.colspan = 4;
        layoutData.grabHorizontal = true;
        aComposite.setLayoutData((Object)layoutData);
        TableWrapLayout loadMethodsLayout1 = new TableWrapLayout();
        loadMethodsLayout1 = new TableWrapLayout();
        loadMethodsLayout1.numColumns = 4;
        aComposite.setLayout((Layout)loadMethodsLayout1);
        this.fDeployLoadTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String comboText = DeploymentNonSequentialConfigurationEditor.this.fDeployLoadTypeCombo.getText();
                aComposite.setText(comboText);
                DeploymentNonSequentialConfigurationEditor.this.validate();
                if (comboText.equals(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_COPY_LOAD_METHOD_LABEL)) {
                    ((DeploymentNonSequentialConfigurationEditor)DeploymentNonSequentialConfigurationEditor.this).loadMethodConfigLayout.topControl = DeploymentNonSequentialConfigurationEditor.this.copyLoadConfigComposite;
                } else if (comboText.equals(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_FTP_LOAD_METHOD_LABEL)) {
                    ((DeploymentNonSequentialConfigurationEditor)DeploymentNonSequentialConfigurationEditor.this).loadMethodConfigLayout.topControl = DeploymentNonSequentialConfigurationEditor.this.ftpLoadConfigComposite;
                }
                DeploymentNonSequentialConfigurationEditor.this.loadMethodConfigCompositeContainer.layout();
            }
        });
        this.loadMethodConfigCompositeContainer = new Composite((Composite)aComposite, 0);
        this.loadMethodConfigCompositeContainer.setLayoutData((Object)new TableWrapData(256, 256));
        this.loadMethodConfigCompositeContainer.setLayout((Layout)this.loadMethodConfigLayout);
        this.loadMethodConfigLayout.topControl = this.fDeploymentLoadOptionsComposite;
        this.copyLoadConfigComposite = new CopyLoadConfigComposite(this.loadMethodConfigCompositeContainer, (AbstractConfigurationElementEditor)this, toolkit);
        this.copyLoadConfigComposite.setLayoutData(new TableWrapData(256, 256));
        this.copyLoadConfigComposite.addLoadConfigChangeListener(this);
        this.ftpLoadConfigComposite = new FTPLoadConfigComposite(this.loadMethodConfigCompositeContainer, (AbstractConfigurationElementEditor)this, toolkit);
        this.ftpLoadConfigComposite.setLayoutData(new TableWrapData(256, 256));
        this.ftpLoadConfigComposite.setProperties(this.getLoadFTPProperties());
        this.ftpLoadConfigComposite.addLoadConfigChangeListener(this);
        if ("Copy".equals(loadMethod)) {
            this.loadMethodConfigLayout.topControl = this.copyLoadConfigComposite;
            this.fDeployLoadTypeCombo.select(0);
            aComposite.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_COPY_LOAD_METHOD_LABEL);
        } else {
            this.loadMethodConfigLayout.topControl = this.ftpLoadConfigComposite;
            this.fDeployLoadTypeCombo.select(1);
            aComposite.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_FTP_LOAD_METHOD_LABEL);
        }
        this.fDeployLoadTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selection = DeploymentNonSequentialConfigurationEditor.this.fDeployLoadTypeCombo.getText();
                String method = "ftp";
                if (selection.equals(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_FTP_LOAD_METHOD_LABEL)) {
                    method = "ftp";
                } else if (selection.equals(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_COPY_LOAD_METHOD_LABEL)) {
                    method = "Copy";
                }
                DeploymentNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.deploy.common.loadMethod", method);
                DeploymentNonSequentialConfigurationEditor.this.validate();
                DeploymentNonSequentialConfigurationEditor.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.localPackageRoot.dir");
        this.localPackageRootText = this.createLabeledText(fLoadOptionsComposite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_TEXT_DEPLOYEDPACKAGE_ROOTDIR, property.getValue());
        this.localPackageRootText.addModifyListener(this.getTextModifyListener("team.deploy.common.localPackageRoot.dir", this.localPackageRootText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.remotePackageRoot.dir");
        this.remotePackageRootText = this.createLabeledText(fLoadOptionsComposite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ORIGINAL_PACKAGE_ROOT_DIR, property.getValue());
        this.remotePackageRootText.addModifyListener(this.getTextModifyListener("team.deploy.common.remotePackageRoot.dir", this.remotePackageRootText));
        if (this.isZosDeployDefNonSeq()) {
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.zos.script");
            String zosScriptProperty = "";
            if (property != null) {
                zosScriptProperty = property.getValue();
            }
            this.zosDeployScriptText = this.createLabeledText(fLoadOptionsComposite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ZOS_DEPLOY_SCRIPT_NONMANDATORY, zosScriptProperty);
            this.zosDeployScriptText.addModifyListener(this.getTextModifyListener("team.deploy.zos.script", this.zosDeployScriptText));
        }
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.load.preCommand");
        this.loadPreCommandText = this.createLabeledText(fLoadOptionsComposite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_TEXT_LOAD_PRECOMMAND, property.getValue());
        this.loadPreCommandText.addModifyListener(this.getTextModifyListener("team.deploy.common.load.preCommand", this.loadPreCommandText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.load.postCommand");
        this.loadPostCommandtext = this.createLabeledText(fLoadOptionsComposite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_TEXT_LOAD_POSTCOMMAND, property.getValue());
        this.loadPostCommandtext.addModifyListener(this.getTextModifyListener("team.deploy.common.load.postCommand", this.loadPostCommandtext));
        loadOptionsSection.setClient((Control)fLoadOptionsComposite);
        if (this.isZosDeployDefNonSeq()) {
            new TooltipSupport((Control)this.loadPostCommandtext, true, false){

                protected String getMarkup(Object element, boolean isFocus) {
                    return NLS.bind((String)Messages.CommandPropertiesTooltip, (Object)DeploymentNonSequentialConfigurationEditor.DEPLOY_DIRECTORY_VARIABLE);
                }

                public Object getElement(Control control, int x, int y) {
                    return DeploymentNonSequentialConfigurationEditor.this.loadPostCommandtext;
                }
            };
            new TooltipSupport((Control)this.zosDeployScriptText, true, false){

                protected String getMarkup(Object element, boolean isFocus) {
                    return Messages.ZosDeployScriptTooltip;
                }

                public Object getElement(Control control, int x, int y) {
                    return DeploymentNonSequentialConfigurationEditor.this.zosDeployScriptText;
                }
            };
        }
    }

    protected void createBuildDefinitionSelectionSection(Composite parent, FormToolkit toolkit) {
        Section fPackageDefinitionSection = toolkit.createSection(parent, 0);
        fPackageDefinitionSection.setTitleBarBorderColor(Display.getCurrent().getSystemColor(1));
        fPackageDefinitionSection.setTitleBarBackground(Display.getCurrent().getSystemColor(1));
        TableWrapLayout pDefSeclayout = new TableWrapLayout();
        pDefSeclayout.numColumns = 4;
        pDefSeclayout.topMargin = 0;
        pDefSeclayout.leftMargin = 0;
        pDefSeclayout.rightMargin = 0;
        TableWrapData pDefSeclayoutData = new TableWrapData(256, 256);
        fPackageDefinitionSection.setLayoutData((Object)pDefSeclayoutData);
        fPackageDefinitionSection.setLayout((Layout)pDefSeclayout);
        Composite fPackageDefinitionComposite = toolkit.createComposite((Composite)fPackageDefinitionSection, 0);
        fPackageDefinitionComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 4;
        layout.topMargin = 0;
        layout.rightMargin = 0;
        fPackageDefinitionComposite.setLayout((Layout)layout);
        fPackageDefinitionComposite.setLayoutData((Object)new TableWrapData(256, 256));
        this.fBuildDefinitionTitleHyperlink = toolkit.createHyperlink(fPackageDefinitionComposite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.PACKAGE_DEFINITION_LABEL, 0);
        this.fBuildDefinitionTitleHyperlink.addHyperlinkListener(this.getBuildDefinitionHyperlinkListener());
        this.fEnabledHyperlinkForegroundColor = this.fBuildDefinitionTitleHyperlink.getForeground();
        this.fBuildDefinitionTitleHyperlink.setLayoutData((Object)new TableWrapData(2, 32));
        this.fPackageDefinitionNameText = toolkit.createText(fPackageDefinitionComposite, "", 0);
        this.fDisabledHyperlinkForegroundColor = this.fPackageDefinitionNameText.getForeground();
        this.fPackageDefinitionNameText.setEnabled(false);
        this.fPackageDefinitionNameText.setEditable(false);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.fPackageDefinitionNameText.setLayoutData((Object)layoutData);
        this.fSelectPackageDefinitionButton = toolkit.createButton(fPackageDefinitionComposite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.PACKAGE_DEFINITION_SELECT_BUTTON, 0);
        this.fSelectPackageDefinitionButton.addSelectionListener(this.getSelectPackageDefinitionListener());
        this.fSelectPackageDefinitionButton.setLayoutData((Object)new TableWrapData(8, 32));
        String packageDefUUID = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.deploy.common.packagedefinitionUUID", "");
        if (packageDefUUID.length() == 0) {
            this.setPackageDefinitionNameText("", false);
        } else {
            this.setPackageDefinitionNameText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.PACKAGE_DEFINITION_PENDING_MESSAGE, false);
            final IBuildDefinitionHandle buildHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)packageDefUUID), null);
            String jobName = com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.PACKAGE_DEFINITION_FETCHING_PACKAGES_JOB_NAME;
            Job job = new Job(jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        DeploymentNonSequentialConfigurationEditor.this.fBuildDefinition = DeploymentNonSequentialConfigurationEditor.this.fetchBuildDefinition(buildHandle, monitor);
                        DeploymentNonSequentialConfigurationEditor.this.handleUpdatePackageDefinitionText(DeploymentNonSequentialConfigurationEditor.this.fBuildDefinition.getId(), true);
                    }
                    catch (Exception e) {
                        DeploymentNonSequentialConfigurationEditor.this.handleUpdatePackageDefinitionText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_PACKAGE_DEFINITION_DELETED_ERROR, false);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        fPackageDefinitionSection.setClient((Control)fPackageDefinitionComposite);
    }

    protected boolean validateProperties() {
        boolean isValid = true;
        if (this.fPackageDefinitionNameText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fPackageDefinitionNameText, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.PACKAGE_DEFINITION_ERROR_MESSAGE, (Control)this.fPackageDefinitionNameText);
            isValid = false;
        } else {
            this.removeMessage(this.fPackageDefinitionNameText, (Control)this.fPackageDefinitionNameText);
        }
        String loadMethod = this.fDeployLoadTypeCombo.getText();
        if (this.isIBMiDeployDef()) {
            this.removeMessage(this.ibmiSaveFileLibraryText, (Control)this.ibmiSaveFileLibraryText);
            if (this.ibmiSaveFileLibraryText.getText().trim().length() == 0) {
                this.addErrorMessageForRequiredField(this.ibmiSaveFileLibraryText, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.IBMI_SAVEFILE_ERROR_MESSAGE, (Control)this.ibmiSaveFileLibraryText);
                isValid = false;
            } else if (!this.ibmiSaveFileLibraryText.getText().trim().startsWith("${") && !IBMiLibraryValidator.isValidLibraryName((String)this.ibmiSaveFileLibraryText.getText().trim())) {
                this.addErrorMessageForRequiredField(this.ibmiSaveFileLibraryText, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_SAVE_FILE_LIBRARY_NAME_NOT_VALID, (Control)this.ibmiSaveFileLibraryText);
                isValid = false;
            }
            boolean isUsrCmdSelected = false;
            IBuildProperty pfDeploySetting = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.ibmi.pfRestoreMethod");
            if (pfDeploySetting != null && pfDeploySetting.getValue().equals("USRCMD")) {
                isUsrCmdSelected = true;
            }
            if (isUsrCmdSelected && this.ibmiRestorePfUsrCmdText.getText().trim().length() == 0) {
                this.addErrorMessageForRequiredField(this.ibmiRestorePfUsrCmdText, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_DEPLOY_PF_USRCMD_NOT_VALID, (Control)this.ibmiRestorePfUsrCmdText);
                isValid = false;
            } else {
                this.removeMessage(this.ibmiRestorePfUsrCmdText, (Control)this.ibmiRestorePfUsrCmdText);
            }
        } else if (this.isLUWDeployDef()) {
            if (this.luwRuntimeRootDirText.getText().trim().length() == 0) {
                this.addErrorMessageForRequiredField(this.luwRuntimeRootDirText, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.LUW_RUNTIME_ROOT_ERROR_MESSAGE, (Control)this.luwRuntimeRootDirText);
                isValid = false;
            } else {
                this.removeMessage(this.luwRuntimeRootDirText, (Control)this.luwRuntimeRootDirText);
            }
        } else if (this.isZosDeployDef()) {
            if (loadMethod.equals(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_FTP_LOAD_METHOD_LABEL) && this.zosDeployScriptText.getText().trim().length() == 0) {
                this.addWarningMessage(this.zosDeployScriptText, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ZosDeployScriptMissing_WARNING_MESSAGE, (Control)this.zosDeployScriptText);
            } else {
                this.removeMessage(this.zosDeployScriptText, (Control)this.zosDeployScriptText);
            }
            String tempPDSPrefix = this.zosTemporaryPDSPrefixText.getText().trim();
            if (tempPDSPrefix.length() != 0) {
                MappingValidation validator = new MappingValidation();
                if (validator.isValidDSName(tempPDSPrefix) != 0) {
                    this.addErrorMessageForRequiredField(this.zosTemporaryPDSPrefixText, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.InvalidDatasetFormat_ERROR, (Control)this.zosTemporaryPDSPrefixText);
                    isValid = false;
                } else {
                    this.removeMessage(this.zosTemporaryPDSPrefixText, (Control)this.zosTemporaryPDSPrefixText);
                }
            } else {
                this.removeMessage(this.zosTemporaryPDSPrefixText, (Control)this.zosTemporaryPDSPrefixText);
            }
        }
        if (this.localPackageRootText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.localPackageRootText, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_ERROR_NOPACKAGEROOT, (Control)this.localPackageRootText);
            isValid = false;
        } else {
            this.removeMessage(this.localPackageRootText, (Control)this.localPackageRootText);
        }
        if (this.remotePackageRootText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.remotePackageRootText, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.REMOTE_PACKAGE_ROOT_ERROR_MESSAGE, (Control)this.remotePackageRootText);
            isValid = false;
        } else {
            this.removeMessage(this.remotePackageRootText, (Control)this.remotePackageRootText);
        }
        IBuildProperty CopyLoadMapping = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.restoreMappingList");
        if (this.fDeployLoadTypeCombo.getText().equals(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentLoadOptionSection_COPY_OPTION) && CopyLoadMapping.getValue().equals("")) {
            this.addWarningMessage(this.restoreMappingComposite, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.CopyLoadConfigComposite_WARNING_MESSAGE, (Control)this.restoreMappingComposite);
        } else {
            this.removeMessage(this.restoreMappingComposite, (Control)this.restoreMappingComposite);
        }
        if (loadMethod.equals(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_COPY_LOAD_METHOD_LABEL)) {
            this.ftpLoadConfigComposite.clearErrorMessages();
        } else if (loadMethod.equals(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_FTP_LOAD_METHOD_LABEL)) {
            this.copyLoadConfigComposite.clearErrorMessages();
            if (!this.ftpLoadConfigComposite.validate()) {
                isValid = false;
            }
        }
        if (this.isPositiveIntegerOrZero(this.maximumRollbackText.getText())) {
            this.removeMessage(this.maximumRollbackText, (Control)this.maximumRollbackText);
        } else {
            this.addErrorMessageForRequiredField(this.maximumRollbackText, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ROLLBACK_MAXIMUM_INVALID, (Control)this.maximumRollbackText);
            isValid = false;
        }
        return isValid;
    }

    protected String getConfigurationId() {
        return "com.ibm.team.enterprise.deployment.nonseq";
    }

    protected String getApplicationDescriptionPropertyName() {
        return "team.deploy.common.applicationDescription";
    }

    protected String getApplicationNamePropertyName() {
        return "team.deploy.common.applicationName";
    }

    protected String getApplicationVersionPropertyName() {
        return "team.deploy.common.version";
    }

    protected String getIsCompletePackagePropertyName() {
        return "team.deploy.common.isCompletePackage";
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    private void setPackageDefinitionNameText(String text, boolean workspaceSet) {
        this.fPackageDefinitionNameText.setText(text);
        this.fPackageDefinitionNameText.setEnabled(workspaceSet);
        this.setBuildDefinitionTitleHyperlinkEnablement(workspaceSet);
    }

    protected SelectionListener getSelectPackageDefinitionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentBuildDefinitionSelectionDialog dialog = new DeploymentBuildDefinitionSelectionDialog(DeploymentNonSequentialConfigurationEditor.this.fBuildDefinitionTitleHyperlink.getShell(), true, DeploymentNonSequentialConfigurationEditor.this.isZosDeployDef(), DeploymentNonSequentialConfigurationEditor.this.isIBMiDeployDef(), DeploymentNonSequentialConfigurationEditor.this.isLUWDeployDef(), DeploymentNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy != null ? DeploymentNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProcessArea() : null);
                if (dialog.open() == 0) {
                    final IBuildDefinition selectedBuildDef = dialog.getFirstSelectedBuildDefinition();
                    DeploymentNonSequentialConfigurationEditor.this.setBuildDefinition(selectedBuildDef);
                    DeploymentNonSequentialConfigurationEditor.this.setRemotePackageRootDir(DeploymentNonSequentialConfigurationEditor.this.fBuildDefinition.getProperty("team.package.common.packageRoot.dir").getValue());
                    new Job(""){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                List<IBuildEngine> engines = DeploymentNonSequentialConfigurationEditor.this.getBuildEngines((IProgressMonitor)new NullProgressMonitor());
                                boolean foundEngine = false;
                                for (IBuildEngine engine : engines) {
                                    for (Object object : engine.getSupportedBuildDefinitions()) {
                                        IBuildDefinitionHandle definition = (IBuildDefinitionHandle)object;
                                        if (!definition.getItemId().equals((Object)selectedBuildDef.getItemId())) continue;
                                        IBuildConfigurationElement element = engine.getConfigurationElement("com.ibm.rational.buildforge.buildagent");
                                        if (element == null) break;
                                        final IConfigurationProperty hostNameProperty = element.getConfigurationProperty("com.ibm.rational.buildforge.buildagent.hostname");
                                        new UIJob(""){

                                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                                DeploymentNonSequentialConfigurationEditor.this.ftpLoadConfigComposite.setHostName(hostNameProperty.getValue());
                                                return Status.OK_STATUS;
                                            }
                                        }.schedule();
                                        foundEngine = true;
                                        break;
                                    }
                                    if (!foundEngine) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (TeamRepositoryException teamRepositoryException) {
                                // empty catch block
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        };
    }

    protected List<IBuildEngine> getBuildEngines(IProgressMonitor monitor) throws TeamRepositoryException {
        IItemManager itemManager = this.getTeamRepository().itemManager();
        IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)IBaseBuildEngineQueryModel.IBuildEngineQueryModel.ROOT);
        ItemQueryIterator iter = new ItemQueryIterator(this.getBuildClient(), itemQuery, IQueryService.EMPTY_PARAMETERS);
        LinkedList<IBuildEngine> buildEngines = new LinkedList<IBuildEngine>();
        while (iter.hasNext(monitor)) {
            List engineHandles = iter.next(512, monitor);
            buildEngines.addAll(itemManager.fetchCompleteItems(engineHandles, 1, monitor));
        }
        Iterator enginesIter = buildEngines.iterator();
        while (enginesIter.hasNext()) {
            Object next = enginesIter.next();
            if (next != null) continue;
            enginesIter.remove();
        }
        return buildEngines;
    }

    private ITeamBuildClient getBuildClient() {
        return ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository());
    }

    protected void handleUpdatePackageDefinitionText(final String packageDefName, final boolean valid) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!DeploymentNonSequentialConfigurationEditor.this.fPackageDefinitionNameText.isDisposed()) {
                    DeploymentNonSequentialConfigurationEditor.this.setPackageDefinitionNameText(packageDefName, valid);
                }
            }
        });
    }

    protected void setRemotePackageRootDir(String remoteDir) {
        this.remotePackageRootText.setText(remoteDir);
    }

    protected void setBuildDefinition(IBuildDefinition buildDefinition) {
        this.fBuildDefinition = buildDefinition;
        this.fBuildDefinitionWorkingCopy.setProperty("team.deploy.common.packagedefinitionUUID", this.fBuildDefinition.getItemId().getUuidValue());
        this.setDirty(true);
        this.setPackageDefinitionNameText(this.fBuildDefinition.getId(), true);
        this.validate();
    }

    protected String[][] getLoadFTPProperties() {
        return new String[][]{this.getPropertyValue("team.deploy.common.load.ftp.hostname"), this.getPropertyValue("team.deploy.common.load.ftp.userid"), this.getPropertyValue("team.deploy.common.load.ftp.passwordFile")};
    }

    private String[] getPropertyValue(String id) {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty(id);
        String value = "";
        if (property != null) {
            value = property.getValue();
        }
        return new String[]{id, value};
    }

    @Override
    public void configChange(String propertyId, String propertyOldValue, String propertyNewValue) {
        this.validate();
        this.fBuildDefinitionWorkingCopy.setProperty(propertyId, propertyNewValue);
        this.setDirty(true);
    }

    public void createContent(Composite parent, FormToolkit kit) {
        this.toolkit = kit;
        parent.setLayout((Layout)new TableWrapLayout());
        TableWrapData data = new TableWrapData(256, 256);
        parent.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
        if (this.isZosDeployDef() || this.isIBMiDeployDef()) {
            this.tabFolder = new CTabFolder(parent, 0x800080);
            this.toolkit.adapt((Control)this.tabFolder, true, true);
            this.tabFolder.setLayout((Layout)new TableWrapLayout());
            this.tabFolder.setLayoutData((Object)data);
            this.toolkit.paintBordersFor((Composite)this.tabFolder);
            this.toolkit.getColors().initializeSectionToolBarColors();
            Color selectedColor = this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
            this.tabFolder.setSelectionBackground(new Color[]{selectedColor, this.toolkit.getColors().getBackground()}, new int[]{100}, true);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeploymentNonSequentialConfigurationEditor.this.tabFolderIndex = DeploymentNonSequentialConfigurationEditor.this.tabFolder.getSelectionIndex();
                }
            });
            this.createTabs(this.toolkit);
            this.tabFolder.setSelection(this.tabFolderIndex);
            this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(22));
            this.loadTab.setControl((Control)this.createLoadTab((Composite)this.tabFolder, this.toolkit));
            this.deployTab.setControl((Control)this.createDeployTab((Composite)this.tabFolder, this.toolkit));
            this.publishTab.setControl((Control)this.createPublishTab((Composite)this.tabFolder, this.toolkit));
        }
        this.validate();
    }

    private void createTabs(FormToolkit toolkit) {
        this.loadTab = this.createTab(toolkit, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.EnterpriseConfigurationEditorDependency_TAB_LOAD);
        this.loadTab.setImage(DeploymentUIPlugin.getImage("icons/obj16/load.gif"));
        this.deployTab = this.createTab(toolkit, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.EnterpriseConfigurationEditorDependency_TAB_DEPLOY);
        this.deployTab.setImage(DeploymentUIPlugin.getImage("icons/obj16/deploy_tab.gif"));
        this.publishTab = this.createTab(toolkit, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.EnterpriseConfigurationEditorDependency_TAB_PUBLISH);
        this.publishTab.setImage(DeploymentUIPlugin.getImage("icons/obj16/publish.gif"));
    }

    private CTabItem createTab(FormToolkit toolkit, String title) {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(title);
        return item;
    }

    private Composite createLoadTab(Composite folderParent, FormToolkit toolkit) {
        Composite parent = new Composite(folderParent, 0);
        parent.setLayout((Layout)new TableWrapLayout());
        TableWrapData data = new TableWrapData();
        data.grabHorizontal = true;
        parent.setLayoutData((Object)data);
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.createBuildDefinitionSelectionSection(parent, toolkit);
        this.createLoadPropertySection(parent, toolkit);
        this.createCommonPlatformPropertySection(parent, toolkit);
        return parent;
    }

    private Composite createDeployTab(Composite folderParent, FormToolkit toolkit) {
        Composite parent = new Composite(folderParent, 0);
        parent.setLayout((Layout)new TableWrapLayout());
        TableWrapData data = new TableWrapData();
        data.grabHorizontal = true;
        parent.setLayoutData((Object)data);
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.createDeploymentPropertiesSection(parent, toolkit);
        return parent;
    }

    private Composite createPublishTab(Composite folderParent, FormToolkit toolkit) {
        Composite parent = new Composite(folderParent, 0);
        parent.setLayout((Layout)new TableWrapLayout());
        TableWrapData data = new TableWrapData();
        data.grabHorizontal = true;
        parent.setLayoutData((Object)data);
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.createCommonPublishPropertySection(parent, toolkit);
        return parent;
    }

    protected void createCommonPublishPropertySection(Composite parent, FormToolkit toolkit) {
        Section fPublishSection = toolkit.createSection(parent, 128);
        fPublishSection.setDescription(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentConfigurationEditor_SECTION_PUBLISH_DESCRIPTION);
        fPublishSection.setTitleBarBorderColor(Display.getCurrent().getSystemColor(1));
        fPublishSection.setTitleBarBackground(Display.getCurrent().getSystemColor(1));
        fPublishSection.setLayoutData((Object)new TableWrapData(256, 256));
        fPublishSection.setLayout((Layout)new TableWrapLayout());
        Composite fPublishPropertyComposite = toolkit.createComposite((Composite)fPublishSection);
        fPublishPropertyComposite.setLayoutData((Object)new TableWrapData(256, 256));
        fPublishPropertyComposite.setLayout((Layout)this.getTableWrapLayoutWithoutIndent());
        this.createPublishProperties(fPublishPropertyComposite, toolkit);
        fPublishSection.setClient((Control)fPublishPropertyComposite);
    }

    protected void createCommonPlatformPropertySection(Composite parent, FormToolkit toolkit) {
        Section fPlatformSection = toolkit.createSection(parent, 0);
        fPlatformSection.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.topMargin = 0;
        fPlatformSection.setLayout((Layout)layout);
        Composite fPlatformPropertyComposite = toolkit.createComposite((Composite)fPlatformSection);
        TableWrapData layoutData = new TableWrapData(256, 256);
        layoutData.colspan = 2;
        layoutData.grabHorizontal = true;
        fPlatformPropertyComposite.setLayoutData((Object)layoutData);
        fPlatformPropertyComposite.setLayout((Layout)layout);
        this.createPlatformProperties(fPlatformPropertyComposite, toolkit);
        fPlatformSection.setClient((Control)fPlatformPropertyComposite);
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        super.setWorkingCopy(definition);
        if (this.restoreMappingComposite != null) {
            this.restoreMappingComposite.setBuildDefinitionWorkingCopy(definition);
        }
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public CTabItem getOptionsTab() {
        return this.deployTab;
    }

    private boolean isIntStringAndHigherThan(String number, int lowLimit) {
        try {
            int i = Integer.parseInt(number);
            return i > lowLimit;
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }

    private boolean isPositiveIntegerOrZero(String number) {
        return this.isIntStringAndHigherThan(number, -1);
    }

    public static enum DeployLoadType {
        COPY,
        FTP,
        CONNECTDIRECT;

    }
}

