/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.internal.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.automation.internal.ui.editors.AbstractAutomationConfigurationEditor;
import com.ibm.team.enterprise.deployment.dialogs.DeploymentBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.deployment.internal.ui.nls.Messages;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DeploymentConfigurationEditor
extends AbstractAutomationConfigurationEditor
implements SelectionListener {
    private Text restoreMappingPathText;
    private Text localPackageRootText;
    private Text remotePackageRootText;
    private Text deployPreCommandText;
    private Text deployPostCommandText;
    private Text rollbackPreCommandText;
    private Text rollbackPostCommandText;
    private Text loadPreCommandText;
    private Text loadPostCommandtext;
    private Text ibmiSaveFileLibraryText;
    private Text luwRuntimeRootDirText;
    private Button loadCopyButton;
    private Button loadFTPButton;
    private Button publishCumulativeDeploy;
    private Button publishDeltaDeploy;
    private Button publishRollbackManifest;
    private Label ftpHostNameLabel;
    private Label ftpUserIDLabel;
    private Label ftpPasswordLabel;
    private Text ftpHostNameText;
    private Text ftpUserIDText;
    private Text ftpPasswordText;
    protected Text fPackageDefinitionNameText;
    protected Button fSelectPackageDefinitionButton;

    public DeploymentConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    protected void createApplicationPropertySection(Composite parent, FormToolkit toolkit) {
    }

    protected void createApplicationProperties(Composite parent, FormToolkit toolkit) {
    }

    protected void createPackageProperties(Composite parent, FormToolkit toolkit) {
    }

    protected void createRuntimeProperties(Composite parent, FormToolkit toolkit) {
        IBuildProperty property;
        if (!this.isLUWDeployDef()) {
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.restoreMappingPath");
            this.restoreMappingPathText = this.createLabeledText(parent, Messages.DeploymentConfigurationEditor_TEXT_OVERRIDEMAPPINGPATH, property.getValue());
            this.restoreMappingPathText.addModifyListener(this.getTextModifyListener("team.deploy.common.restoreMappingPath", this.restoreMappingPathText));
        }
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.deploy.preCommand");
        this.deployPreCommandText = this.createLabeledText(parent, Messages.DeploymentConfigurationEditor_TEXT_DEPLOY_PRECOMMAND, property.getValue());
        this.deployPreCommandText.addModifyListener(this.getTextModifyListener("team.deploy.common.deploy.preCommand", this.deployPreCommandText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.deploy.postCommand");
        this.deployPostCommandText = this.createLabeledText(parent, Messages.DeploymentConfigurationEditor_TEXT_DEPLOY_POSTCOMMAND, property.getValue());
        this.deployPostCommandText.addModifyListener(this.getTextModifyListener("team.deploy.common.deploy.postCommand", this.deployPostCommandText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.rollback.preCommand");
        this.rollbackPreCommandText = this.createLabeledText(parent, Messages.DeploymentConfigurationEditor_TEXT_ROLLBACK_PRECOMMAND, property.getValue());
        this.rollbackPreCommandText.addModifyListener(this.getTextModifyListener("team.deploy.common.rollback.preCommand", this.rollbackPreCommandText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.rollback.postCommand");
        this.rollbackPostCommandText = this.createLabeledText(parent, Messages.DeploymentConfigurationEditor_TEXT_ROLLBACK_POSTCOMMAND, property.getValue());
        this.rollbackPostCommandText.addModifyListener(this.getTextModifyListener("team.deploy.common.rollback.postCommand", this.rollbackPostCommandText));
    }

    protected void createPublishProperties(Composite parent, FormToolkit toolkit) {
        boolean propertyValue;
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.publishDeltaDeploy");
        this.publishDeltaDeploy = toolkit.createButton(parent, Messages.PUBLISH_DELTA_DEPLOY, 32);
        if (property != null) {
            boolean propertyValue2 = Boolean.parseBoolean(property.getValue());
            this.publishDeltaDeploy.setSelection(propertyValue2);
        } else {
            this.publishDeltaDeploy.setSelection(false);
        }
        TableWrapData buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.publishDeltaDeploy.setLayoutData((Object)buttonData);
        this.publishDeltaDeploy.addSelectionListener(this.getButtonSelectionListener("team.deploy.common.publishDeltaDeploy", this.publishDeltaDeploy));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.publishCumulativeDeploy");
        this.publishCumulativeDeploy = toolkit.createButton(parent, Messages.PUBLISH_CUMULATIVE_DEPLOY, 32);
        if (property != null) {
            propertyValue = Boolean.parseBoolean(property.getValue());
            this.publishCumulativeDeploy.setSelection(propertyValue);
        } else {
            this.publishCumulativeDeploy.setSelection(false);
        }
        buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.publishCumulativeDeploy.setLayoutData((Object)buttonData);
        this.publishCumulativeDeploy.addSelectionListener(this.getButtonSelectionListener("team.deploy.common.publishCumulativeDeploy", this.publishCumulativeDeploy));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.publishRollbackManifest");
        this.publishRollbackManifest = toolkit.createButton(parent, Messages.PUBLISH_ROLLBACK_MANIFEST, 32);
        if (property != null) {
            propertyValue = Boolean.parseBoolean(property.getValue());
            this.publishRollbackManifest.setSelection(propertyValue);
        } else {
            this.publishRollbackManifest.setSelection(false);
        }
        buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.publishRollbackManifest.setLayoutData((Object)buttonData);
        this.publishRollbackManifest.addSelectionListener(this.getButtonSelectionListener("team.deploy.common.publishRollbackManifest", this.publishRollbackManifest));
    }

    protected void createPlatformProperties(Composite parent, FormToolkit toolkit) {
        if (this.isIBMiDeployDef()) {
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.ibmi.intermediateSaveFileLibrary");
            this.ibmiSaveFileLibraryText = this.createLabeledText(parent, Messages.IBMI_PACKAGING_SAVEFILE_LIBRARY, property.getValue());
            this.ibmiSaveFileLibraryText.addModifyListener(this.getTextModifyListener("team.deploy.ibmi.intermediateSaveFileLibrary", this.ibmiSaveFileLibraryText));
        } else if (this.isLUWDeployDef()) {
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.luw.runtimeRoot.dir");
            this.luwRuntimeRootDirText = this.createLabeledText(parent, Messages.LUW_PACKAGING_RUNTIME_ROOT_DIR, property.getValue());
            this.luwRuntimeRootDirText.addModifyListener(this.getTextModifyListener("team.deploy.luw.runtimeRoot.dir", this.luwRuntimeRootDirText));
        } else {
            Composite grandParent = parent.getParent();
            if (grandParent instanceof Section) {
                grandParent.setVisible(false);
            }
            parent.setVisible(false);
        }
    }

    protected void createExtensibleContributionSection(Composite parent, FormToolkit toolkit) {
        this.createDeploymentPropertiesSection(parent, toolkit);
        this.createLoadPropertySection(parent, toolkit);
    }

    public Control getFocusControl() {
        return this.fSelectPackageDefinitionButton;
    }

    private void createDeploymentPropertiesSection(Composite parent, FormToolkit toolkit) {
        Section fdeploymentSection = toolkit.createSection(parent, 322);
        fdeploymentSection.setLayoutData((Object)new TableWrapData(256, 256));
        fdeploymentSection.setLayout((Layout)new TableWrapLayout());
        fdeploymentSection.setText(Messages.DeploymentConfigurationEditor_SECTION_DEPLOYMENT);
        Composite fDeploymentPropertyComposite = toolkit.createComposite((Composite)fdeploymentSection);
        fDeploymentPropertyComposite.setLayoutData((Object)new TableWrapData(256, 256));
        fDeploymentPropertyComposite.setLayout((Layout)this.getTableWrapLayout());
        this.createCompletePackageButton(fDeploymentPropertyComposite, toolkit, Messages.DeploymentConfigurationEditor_BUTTON_DEPLOYPACKAGE);
        this.createSpacer(fDeploymentPropertyComposite, 5, 2, toolkit);
        this.createRuntimeProperties(fDeploymentPropertyComposite, toolkit);
        fdeploymentSection.setClient((Control)fDeploymentPropertyComposite);
    }

    private void createLoadPropertySection(Composite parent, FormToolkit toolkit) {
        Section loadOptionsSection = toolkit.createSection(parent, 450);
        loadOptionsSection.setLayoutData((Object)new TableWrapData(256, 256));
        loadOptionsSection.setLayout((Layout)new TableWrapLayout());
        loadOptionsSection.setText(Messages.DeploymentConfigurationEditor_SECTION_LOAD);
        loadOptionsSection.setDescription(Messages.DeploymentConfigurationEditor_SECTION_LOAD_DESCRIPTION);
        Composite fLoadOptionsComposite = toolkit.createComposite((Composite)loadOptionsSection);
        fLoadOptionsComposite.setLayoutData((Object)new TableWrapData(256, 256));
        fLoadOptionsComposite.setLayout((Layout)this.getTableWrapLayout());
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.loadMethod");
        this.loadCopyButton = toolkit.createButton(fLoadOptionsComposite, Messages.DeploymentConfigurationEditor_BUTTON_COPY, 16);
        TableWrapData buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.loadCopyButton.setLayoutData((Object)buttonData);
        this.loadFTPButton = toolkit.createButton(fLoadOptionsComposite, Messages.DeploymentConfigurationEditor_BUTTON_FTP, 16);
        buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.loadFTPButton.setLayoutData((Object)buttonData);
        boolean copyButtonSelected = property == null || property.getValue().equalsIgnoreCase("") || property.getValue().equalsIgnoreCase("copy") || property.getValue().equalsIgnoreCase("${team.deploy.default.common.loadMethod}");
        this.loadCopyButton.setSelection(copyButtonSelected);
        this.loadFTPButton.setSelection(!copyButtonSelected);
        this.loadCopyButton.addSelectionListener((SelectionListener)this);
        this.loadFTPButton.addSelectionListener((SelectionListener)this);
        this.createFTPGroup(fLoadOptionsComposite, toolkit);
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.localPackageRoot.dir");
        this.localPackageRootText = this.createLabeledText(fLoadOptionsComposite, Messages.DeploymentConfigurationEditor_TEXT_LOCALPACKAGE_ROOTDIR, property.getValue());
        this.localPackageRootText.addModifyListener(this.getTextModifyListener("team.deploy.common.localPackageRoot.dir", this.localPackageRootText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.remotePackageRoot.dir");
        this.remotePackageRootText = this.createLabeledText(fLoadOptionsComposite, Messages.REMOTE_PACKAGE_ROOT_DIR, property.getValue());
        this.remotePackageRootText.addModifyListener(this.getTextModifyListener("team.deploy.common.remotePackageRoot.dir", this.remotePackageRootText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.load.preCommand");
        this.loadPreCommandText = this.createLabeledText(fLoadOptionsComposite, Messages.DeploymentConfigurationEditor_TEXT_LOAD_PRECOMMAND, property.getValue());
        this.loadPreCommandText.addModifyListener(this.getTextModifyListener("team.deploy.common.load.preCommand", this.loadPreCommandText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.load.postCommand");
        this.loadPostCommandtext = this.createLabeledText(fLoadOptionsComposite, Messages.DeploymentConfigurationEditor_TEXT_LOAD_POSTCOMMAND, property.getValue());
        this.loadPostCommandtext.addModifyListener(this.getTextModifyListener("team.deploy.common.load.postCommand", this.loadPostCommandtext));
        loadOptionsSection.setClient((Control)fLoadOptionsComposite);
    }

    protected void createBuildDefinitionSelectionSection(Composite parent, FormToolkit toolkit) {
        Section fPackageDefinitionSection = toolkit.createSection(parent, 256);
        fPackageDefinitionSection.setLayoutData((Object)new TableWrapData(256, 256));
        fPackageDefinitionSection.setLayout((Layout)new TableWrapLayout());
        fPackageDefinitionSection.setText(Messages.PACKAGE_DEFINITION_SECTION_TEXT);
        Composite fPackageDefinitionComposite = toolkit.createComposite((Composite)fPackageDefinitionSection);
        fPackageDefinitionComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        layout.leftMargin = 20;
        fPackageDefinitionComposite.setLayout((Layout)layout);
        this.fBuildDefinitionTitleHyperlink = toolkit.createHyperlink(fPackageDefinitionComposite, Messages.PACKAGE_DEFINITION_LABEL, 0);
        this.fBuildDefinitionTitleHyperlink.addHyperlinkListener(this.getBuildDefinitionHyperlinkListener());
        this.fEnabledHyperlinkForegroundColor = this.fBuildDefinitionTitleHyperlink.getForeground();
        this.fBuildDefinitionTitleHyperlink.setLayoutData((Object)new TableWrapData(2, 32));
        this.fPackageDefinitionNameText = toolkit.createText(fPackageDefinitionComposite, "", 0);
        this.fDisabledHyperlinkForegroundColor = this.fPackageDefinitionNameText.getForeground();
        this.fPackageDefinitionNameText.setEnabled(false);
        this.fPackageDefinitionNameText.setEditable(false);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.fPackageDefinitionNameText.setLayoutData((Object)layoutData);
        this.fSelectPackageDefinitionButton = toolkit.createButton(fPackageDefinitionComposite, Messages.PACKAGE_DEFINITION_SELECT_BUTTON, 0);
        this.fSelectPackageDefinitionButton.addSelectionListener(this.getSelectPackageDefinitionListener());
        this.fSelectPackageDefinitionButton.setLayoutData((Object)new TableWrapData(8, 32));
        String packageDefUUID = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.deploy.common.packagedefinitionUUID", "");
        if (packageDefUUID.length() == 0) {
            this.setPackageDefinitionNameText("", false);
        } else {
            this.setPackageDefinitionNameText(Messages.PACKAGE_DEFINITION_PENDING_MESSAGE, false);
            final IBuildDefinitionHandle buildHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)packageDefUUID), null);
            String jobName = Messages.PACKAGE_DEFINITION_FETCHING_PACKAGES_JOB_NAME;
            Job job = new Job(jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        DeploymentConfigurationEditor.this.fBuildDefinition = DeploymentConfigurationEditor.this.fetchBuildDefinition(buildHandle, monitor);
                        DeploymentConfigurationEditor.this.handleUpdatePackageDefinitionText(DeploymentConfigurationEditor.this.fBuildDefinition.getId());
                    }
                    catch (Exception e) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        fPackageDefinitionSection.setClient((Control)fPackageDefinitionComposite);
    }

    private void createFTPGroup(Composite parent, FormToolkit toolkit) {
        Composite ftpComposite = toolkit.createComposite(parent);
        TableWrapData compositeData = new TableWrapData(256, 256);
        compositeData.colspan = 2;
        ftpComposite.setLayoutData((Object)compositeData);
        ftpComposite.setLayout((Layout)this.getTableWrapLayout());
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.load.ftp.hostname");
        this.ftpHostNameLabel = toolkit.createLabel(ftpComposite, Messages.DeploymentConfigurationEditor_TEXT_HOSTNAME);
        this.ftpHostNameText = toolkit.createText(ftpComposite, property.getValue());
        this.ftpHostNameText.setLayoutData((Object)new TableWrapData(256));
        this.ftpHostNameText.addModifyListener(this.getTextModifyListener("team.deploy.common.load.ftp.hostname", this.ftpHostNameText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.load.ftp.userid");
        this.ftpUserIDLabel = toolkit.createLabel(ftpComposite, Messages.DeploymentConfigurationEditor_TEXT_USERID);
        this.ftpUserIDText = toolkit.createText(ftpComposite, property.getValue());
        this.ftpUserIDText.setLayoutData((Object)new TableWrapData(256));
        this.ftpUserIDText.addModifyListener(this.getTextModifyListener("team.deploy.common.load.ftp.userid", this.ftpUserIDText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.deploy.common.load.ftp.passwordFile");
        this.ftpPasswordLabel = toolkit.createLabel(ftpComposite, Messages.DeploymentConfigurationEditor_TEXT_PASSWORDFILE);
        this.ftpPasswordText = toolkit.createText(ftpComposite, property.getValue());
        this.ftpPasswordText.setLayoutData((Object)new TableWrapData(256));
        this.ftpPasswordText.addModifyListener(this.getTextModifyListener("team.deploy.common.load.ftp.passwordFile", this.ftpPasswordText));
        this.updateFTPEnableStates();
    }

    private void updateFTPEnableStates() {
        boolean isLoadFTP = this.loadFTPButton != null && !this.loadFTPButton.isDisposed() ? this.loadFTPButton.getSelection() : false;
        this.ftpHostNameText.setEnabled(isLoadFTP);
        this.ftpHostNameLabel.setEnabled(isLoadFTP);
        this.ftpUserIDText.setEnabled(isLoadFTP);
        this.ftpUserIDLabel.setEnabled(isLoadFTP);
        this.ftpPasswordText.setEnabled(isLoadFTP);
        this.ftpPasswordLabel.setEnabled(isLoadFTP);
    }

    protected boolean validateProperties() {
        boolean isValid = true;
        if (this.fPackageDefinitionNameText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fPackageDefinitionNameText, Messages.PACKAGE_DEFINITION_ERROR_MESSAGE, (Control)this.fPackageDefinitionNameText);
            isValid = false;
        } else {
            this.removeMessage(this.fPackageDefinitionNameText, (Control)this.fPackageDefinitionNameText);
        }
        if (this.isIBMiDeployDef()) {
            if (this.ibmiSaveFileLibraryText.getText().trim().length() == 0) {
                this.addErrorMessageForRequiredField(this.ibmiSaveFileLibraryText, Messages.IBMI_SAVEFILE_ERROR_MESSAGE, (Control)this.ibmiSaveFileLibraryText);
                isValid = false;
            } else {
                this.removeMessage(this.ibmiSaveFileLibraryText, (Control)this.ibmiSaveFileLibraryText);
            }
        } else if (this.isLUWDeployDef()) {
            if (this.luwRuntimeRootDirText.getText().trim().length() == 0) {
                this.addErrorMessageForRequiredField(this.luwRuntimeRootDirText, Messages.LUW_RUNTIME_ROOT_ERROR_MESSAGE, (Control)this.luwRuntimeRootDirText);
                isValid = false;
            } else {
                this.removeMessage(this.luwRuntimeRootDirText, (Control)this.luwRuntimeRootDirText);
            }
        } else if (this.fBuildDefinitionWorkingCopy.getBuildSchedule().isScheduleEnabled() && Boolean.parseBoolean(this.fBuildDefinition.getProperty("team.package.common.workitem.option").getValue())) {
            this.addErrorMessage(this.fBuildDefinitionTitleHyperlink, Messages.SCHEDULING_AND_WORKITEM_WARNING, (IStatus)new Status(2, "com.ibm.team.enterprise.deployment.ui", Messages.SCHEDULING_AND_WORKITEM_DIALOG_WARNING));
        } else {
            this.removeMessage(this.fBuildDefinitionTitleHyperlink);
        }
        if (this.localPackageRootText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.localPackageRootText, Messages.DeploymentConfigurationEditor_ERROR_NOPACKAGEROOT, (Control)this.localPackageRootText);
            isValid = false;
        } else {
            this.removeMessage(this.localPackageRootText, (Control)this.localPackageRootText);
        }
        if (this.remotePackageRootText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.remotePackageRootText, Messages.REMOTE_PACKAGE_ROOT_ERROR_MESSAGE, (Control)this.remotePackageRootText);
            isValid = false;
        } else {
            this.removeMessage(this.remotePackageRootText, (Control)this.remotePackageRootText);
        }
        if (this.loadFTPButton.getSelection()) {
            if (this.ftpHostNameText.getText().trim().length() == 0) {
                this.addErrorMessageForRequiredField(this.ftpHostNameText, Messages.FTP_HOSTNAME_MISSING_ERROR_MESSAGE, (Control)this.ftpHostNameText);
                isValid = false;
            } else {
                this.removeMessage(this.ftpHostNameText, (Control)this.ftpHostNameText);
            }
            if (this.ftpPasswordText.getText().trim().length() == 0) {
                this.addErrorMessageForRequiredField(this.ftpPasswordText, Messages.FTP_PASSWORD_MISSING_ERROR_MESSAGE, (Control)this.ftpPasswordText);
                isValid = false;
            } else {
                this.removeMessage(this.ftpPasswordText, (Control)this.ftpPasswordText);
            }
            if (this.ftpUserIDText.getText().trim().length() == 0) {
                this.addErrorMessageForRequiredField(this.ftpUserIDText, Messages.FTP_USERID_MISSING_ERROR_MESSAGE, (Control)this.ftpUserIDText);
                isValid = false;
            } else {
                this.removeMessage(this.ftpUserIDText, (Control)this.ftpUserIDText);
            }
        }
        if (this.loadCopyButton.getSelection()) {
            this.removeMessage(this.ftpHostNameText, (Control)this.ftpHostNameText);
            this.removeMessage(this.ftpPasswordText, (Control)this.ftpPasswordText);
            this.removeMessage(this.ftpUserIDText, (Control)this.ftpUserIDText);
        }
        return isValid;
    }

    protected String getConfigurationId() {
        return "com.ibm.team.enterprise.deployment";
    }

    protected String getApplicationDescriptionPropertyName() {
        return "team.deploy.common.applicationDescription";
    }

    protected String getApplicationNamePropertyName() {
        return "team.deploy.common.applicationName";
    }

    protected String getApplicationVersionPropertyName() {
        return "team.deploy.common.version";
    }

    protected String getIsCompletePackagePropertyName() {
        return "team.deploy.common.isCompletePackage";
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        Object eventSource = event.getSource();
        this.validate();
        if (eventSource == this.loadCopyButton || eventSource == this.loadFTPButton) {
            this.fBuildDefinitionWorkingCopy.setProperty("team.deploy.common.loadMethod", this.loadCopyButton.getSelection() ? "copy" : "ftp");
            this.setDirty(true);
            this.updateFTPEnableStates();
        }
    }

    private void setPackageDefinitionNameText(String text, boolean workspaceSet) {
        this.fPackageDefinitionNameText.setText(text);
        this.fPackageDefinitionNameText.setEnabled(workspaceSet);
        this.setBuildDefinitionTitleHyperlinkEnablement(workspaceSet);
    }

    protected SelectionListener getSelectPackageDefinitionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentBuildDefinitionSelectionDialog dialog = new DeploymentBuildDefinitionSelectionDialog(DeploymentConfigurationEditor.this.fBuildDefinitionTitleHyperlink.getShell(), false, DeploymentConfigurationEditor.this.isZosDeployDef(), DeploymentConfigurationEditor.this.isIBMiDeployDef(), DeploymentConfigurationEditor.this.isLUWDeployDef(), DeploymentConfigurationEditor.this.fBuildDefinitionWorkingCopy != null ? DeploymentConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProcessArea() : null);
                if (dialog.open() == 0) {
                    IBuildDefinition selectedBuildDef = dialog.getFirstSelectedBuildDefinition();
                    DeploymentConfigurationEditor.this.setBuildDefinition(selectedBuildDef);
                    DeploymentConfigurationEditor.this.setRemotePackageRootDir(DeploymentConfigurationEditor.this.fBuildDefinition.getProperty("team.package.common.packageRoot.dir").getValue());
                }
            }
        };
    }

    protected void handleUpdatePackageDefinitionText(final String packageDefName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!DeploymentConfigurationEditor.this.fPackageDefinitionNameText.isDisposed()) {
                    DeploymentConfigurationEditor.this.setPackageDefinitionNameText(packageDefName, true);
                }
            }
        });
    }

    protected void setRemotePackageRootDir(String remoteDir) {
        this.remotePackageRootText.setText(remoteDir);
    }

    protected void setBuildDefinition(IBuildDefinition buildDefinition) {
        this.fBuildDefinition = buildDefinition;
        this.fBuildDefinitionWorkingCopy.setProperty("team.deploy.common.packagedefinitionUUID", this.fBuildDefinition.getItemId().getUuidValue());
        this.setDirty(true);
        this.setPackageDefinitionNameText(this.fBuildDefinition.getId(), true);
        this.validate();
    }
}

