/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.internal.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.ui.properties.AbstractBuildPropertyEditor;
import com.ibm.team.build.ui.properties.IBuildPropertyEditorContext;
import com.ibm.team.build.ui.properties.ISchedulePropertyEditor;
import com.ibm.team.enterprise.build.client.packaging.IPackageJFSClient;
import com.ibm.team.enterprise.deployment.internal.ui.dialogs.SelectPackageMember;
import com.ibm.team.enterprise.deployment.internal.ui.dialogs.ViewPackageDialog;
import com.ibm.team.enterprise.deployment.internal.ui.nls.Messages;
import com.ibm.team.enterprise.packaging.common.jfs.IPackageHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DeployPackageSchedulePropertyEditor
extends AbstractBuildPropertyEditor
implements ISchedulePropertyEditor {
    private Job findPackagesJob = null;
    private List<IPackageHandle> packageHandles;
    private final ArrayList<SelectPackageMember> PackageMembers = new ArrayList();
    private IBuildDefinition fWorkingCopy = null;
    private UUID element;
    private UUID packageId;
    private String template;
    private ViewPackageDialog dialog = null;

    public boolean editProperty(final IBuildPropertyEditorContext context) {
        this.element = this.fWorkingCopy != null ? this.fWorkingCopy.getItemId() : null;
        this.packageId = this.fWorkingCopy != null ? this.getPackageDefinitionUUID() : null;
        String string = this.template = this.fWorkingCopy != null ? this.fWorkingCopy.getProperty("com.ibm.team.build.internal.template.id").getValue() : null;
        if (this.packageId == null) {
            MessageDialog.openError((Shell)context.getShell(), (String)Messages.DeployPackageSchedulePropertyEditor_NO_PACKAGE_DEFINITION_SPECIFIED_ERROR_TITLE, (String)Messages.DeployPackageSchedulePropertyEditor_NO_PACKAGE_DEFINITION_SPECIFIED_ERROR_MSG);
            return false;
        }
        this.findPackagesJob = new Job(Messages.DeploymentRequestBuildSection_GETTING_PACKAGE_INFORMATION_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                IPackageJFSClient clientLibrary = (IPackageJFSClient)context.getTeamRepository().getClientLibrary(IPackageJFSClient.class);
                UUID packageDefinitionUUID = DeployPackageSchedulePropertyEditor.this.getPackageDefinitionUUID();
                try {
                    DeployPackageSchedulePropertyEditor.this.packageHandles = clientLibrary.getAllPackageHandles(packageDefinitionUUID);
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                for (IPackageHandle packageHandle : DeployPackageSchedulePropertyEditor.this.packageHandles) {
                    String packages = packageHandle.getLabel();
                    SelectPackageMember mapping = new SelectPackageMember(packages, "", "", packageHandle);
                    DeployPackageSchedulePropertyEditor.this.PackageMembers.add(mapping);
                }
                return Status.OK_STATUS;
            }
        };
        this.findPackagesJob.schedule();
        String propertyValue = this.openViewPackageDialog(context.getShell(), context.getTeamRepository(), context.getProperty().getValue());
        if (propertyValue != null) {
            context.getProperty().setValue(propertyValue);
            return true;
        }
        return false;
    }

    private String openViewPackageDialog(Shell shell, ITeamRepository repo, String initialValue) {
        if (this.element != null && this.packageId != null && this.template != null && this.findPackagesJob != null) {
            try {
                Object[] results;
                this.findPackagesJob.join();
                this.dialog = new ViewPackageDialog(shell, repo, this.packageHandles, this.element, this.packageId, this.template, false);
                if (this.dialog != null && this.dialog.open() == 0 && (results = this.dialog.getResult()).length > 0 && results[0] != null) {
                    SelectPackageMember result = (SelectPackageMember)results[0];
                    return result.getPackageHandle().getLabel();
                }
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return null;
    }

    private UUID getPackageDefinitionUUID() {
        List properties = this.fWorkingCopy.getProperties();
        for (IBuildProperty property : properties) {
            if (!property.getName().equals("team.deploy.common.packagedefinitionUUID") || property.getValue().equalsIgnoreCase("")) continue;
            return UUID.valueOf((String)property.getValue());
        }
        return null;
    }

    public void setWorkingCopy(IBuildDefinition workingCopy) {
        this.fWorkingCopy = workingCopy;
    }
}

