/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.internal.ui.editors;

import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.deployment.internal.listeners.LoadConfigChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class AbstractLoadConfigComposite
extends Composite {
    private List<LoadConfigChangeListener> listeners;
    protected FormToolkit toolkit;
    protected AbstractConfigurationElementEditor editor;

    public AbstractLoadConfigComposite(Composite parent, AbstractConfigurationElementEditor editor, FormToolkit toolkit) {
        super(parent, 0);
        this.editor = editor;
        this.toolkit = toolkit;
    }

    public void setProperties(String[][] properties) {
        if (properties != null) {
            int i = 0;
            while (i < properties.length) {
                if (properties[i].length == 2) {
                    String id = properties[i][0];
                    String value = properties[i][1];
                    Control control = this.getBoundControl(id);
                    if (control != null) {
                        this.setValue(control, value);
                    }
                }
                ++i;
            }
        }
    }

    protected Control getBoundControl(String id) {
        Control controlFound = null;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (id.equals(control.getData("id"))) {
                return control;
            }
            if (control instanceof Composite) {
                controlFound = this.getBoundControl(id, (Composite)control);
            }
            if (controlFound != null) {
                return controlFound;
            }
            ++n2;
        }
        return null;
    }

    protected Control getBoundControl(String id, Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (id.equals(control.getData("id"))) {
                return control;
            }
            ++n2;
        }
        return null;
    }

    protected void bind(Control control, String propertyId) {
        control.setData("id", (Object)propertyId);
        if (control instanceof Text) {
            final Text textfield = (Text)control;
            textfield.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    AbstractLoadConfigComposite.this.fireLoadConfigChangeListener((Control)textfield, textfield.getText());
                }
            });
        } else if (control instanceof Button) {
            final Button button = (Button)control;
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if ((button.getStyle() & 0x30) != 0) {
                        AbstractLoadConfigComposite.this.fireLoadConfigChangeListener((Control)button, String.valueOf(button.getSelection()));
                    }
                }
            });
        }
    }

    protected void setValue(Control control, String value) {
        if (control instanceof Text) {
            ((Text)control).setText(value);
        } else if (control instanceof Button) {
            ((Button)control).setSelection(Boolean.valueOf(value).booleanValue());
        }
    }

    public void addLoadConfigChangeListener(LoadConfigChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<LoadConfigChangeListener>();
        }
        this.listeners.add(listener);
    }

    public void removeLoadConfigChangeListener(LoadConfigChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireLoadConfigChangeListener(Control control, String newValue) {
        if (this.listeners == null) {
            return;
        }
        String propertyId = (String)control.getData("id");
        if (propertyId != null) {
            for (LoadConfigChangeListener listener : this.listeners) {
                listener.configChange(propertyId, "", newValue);
            }
        }
    }

    protected TableWrapLayout getTableWrapLayout(int numColumns) {
        TableWrapLayout newLayout = new TableWrapLayout();
        newLayout.numColumns = numColumns;
        newLayout.horizontalSpacing = 10;
        newLayout.leftMargin = 15;
        newLayout.rightMargin = 0;
        return newLayout;
    }

    public boolean validate() {
        return true;
    }

    public abstract void clearErrorMessages();
}

