/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.internal.ui.dialogs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.query.IBaseBuildEngineQueryModel;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.enterprise.automation.internal.ui.nls.Messages;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.automation.ui.table.AutomationCategoryNode;
import com.ibm.team.enterprise.automation.ui.table.AutomationViewerComparator;
import com.ibm.team.enterprise.build.client.deployment.IDeploymentJFSClient;
import com.ibm.team.enterprise.build.client.packaging.IPackageJFSClient;
import com.ibm.team.enterprise.deployment.common.jfs.IDeployInfo;
import com.ibm.team.enterprise.deployment.common.jfs.IDeployment;
import com.ibm.team.enterprise.deployment.common.jfs.ILoadInfo;
import com.ibm.team.enterprise.deployment.internal.ui.dialogs.PackageDetailsMember;
import com.ibm.team.enterprise.deployment.internal.ui.dialogs.PackageDetailsTableLabelProvider;
import com.ibm.team.enterprise.deployment.internal.ui.dialogs.PackageDetailsTreeContentsProvider;
import com.ibm.team.enterprise.deployment.internal.ui.dialogs.SelectPackageMember;
import com.ibm.team.enterprise.deployment.internal.ui.dialogs.SelectPackageTableContentProvider;
import com.ibm.team.enterprise.deployment.internal.ui.dialogs.SelectPackageTableLabelProvider;
import com.ibm.team.enterprise.packaging.common.jfs.IPackage;
import com.ibm.team.enterprise.packaging.common.jfs.IPackageHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.UIJob;

public class ViewPackageDialog
extends SelectionStatusDialog {
    private final ITeamRepository repo;
    private final UUID deploymentDefinitionUUID;
    private final UUID packageDefinitionUUID;
    private final String template;
    private final ArrayList<SelectPackageMember> querying = new ArrayList();
    private AutomationViewerComparator comparatorPackage;
    private AutomationViewerComparator comparatorPackageDetails;
    private IPackageHandle packageHandle;
    private IPackageJFSClient client;
    private Iterator<Resource> resource;
    private Composite detailsComposite;
    private IPackage pkg;
    private Label packageDef;
    private Label locationLabel;
    private Label timestampLabel;
    private Table selectPackageTable;
    private TableViewer selectPackageTableViewer;
    private Tree packageDetailsTree;
    private TreeViewer packageDetailsTreeViewer;
    private String packageL = "";
    private String locationL = "";
    private String timestampL = "";
    private boolean isSelectingForRollback = false;
    private List<Container> packageContainer;
    private List<IDeployInfo> deployInfo;
    private List<ILoadInfo> loadInfo;
    private List<IPackageHandle> packageHandles;

    public ViewPackageDialog(Shell parent, ITeamRepository repo, List<IPackageHandle> packageHandles, UUID element, UUID packageDefinitionUUID, String template, boolean isSelectingForRollback) {
        super(parent);
        this.setHelpAvailable(false);
        this.repo = repo;
        this.deploymentDefinitionUUID = element;
        this.packageDefinitionUUID = packageDefinitionUUID;
        this.template = template;
        this.isSelectingForRollback = isSelectingForRollback;
        if (packageHandles != null) {
            this.packageHandles = packageHandles;
            this.setTitle(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_TITLE);
        } else {
            this.packageHandles = Collections.emptyList();
            this.setTitle(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_TITLE_UNAVAILABLE);
        }
        if (this.packageHandles.size() > 0) {
            this.packageHandle = packageHandles.get(0);
        }
    }

    protected void computeResult() {
    }

    protected void okPressed() {
        ArrayList<SelectPackageMember> resultList = new ArrayList<SelectPackageMember>();
        resultList.add((SelectPackageMember)((IStructuredSelection)this.selectPackageTableViewer.getSelection()).getFirstElement());
        this.setResult(resultList);
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setMinimumSize(550, 330);
        Display display = Display.getCurrent();
        Monitor primary = display.getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
    }

    private ITeamBuildClient getBuildClient() throws IOException, TeamRepositoryException {
        return ClientFactory.getTeamBuildClient((ITeamRepository)this.repo);
    }

    protected SelectionListener getPackageColumnSelectionListener(final Table table, final TableColumn column, final int columnNum) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewPackageDialog.this.comparatorPackage.setColumn(columnNum);
                if (table.getSortColumn() == column) {
                    if (table.getSortDirection() == 1024) {
                        table.setSortDirection(128);
                    } else {
                        table.setSortDirection(1024);
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                ViewPackageDialog.this.selectPackageTableViewer.refresh();
            }
        };
    }

    protected SelectionListener getDetailsColumnSelectionListener(final Tree tree, final TreeColumn column, final int columnNum) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewPackageDialog.this.comparatorPackageDetails.setColumn(columnNum);
                if (tree.getSortColumn() == column) {
                    if (tree.getSortDirection() == 1024) {
                        tree.setSortDirection(128);
                    } else {
                        tree.setSortDirection(1024);
                    }
                } else {
                    tree.setSortColumn(column);
                    tree.setSortDirection(128);
                }
                ViewPackageDialog.this.packageDetailsTreeViewer.refresh();
            }
        };
    }

    protected List<IBuildEngine> getBuildEngines(IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        IItemManager itemManager = this.repo.itemManager();
        IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)IBaseBuildEngineQueryModel.IBuildEngineQueryModel.ROOT);
        ItemQueryIterator iter = new ItemQueryIterator(this.getBuildClient(), itemQuery, IQueryService.EMPTY_PARAMETERS);
        LinkedList<IBuildEngine> buildEngines = new LinkedList<IBuildEngine>();
        while (iter.hasNext(monitor)) {
            List engineHandles = iter.next(512, monitor);
            buildEngines.addAll(itemManager.fetchCompleteItems(engineHandles, 1, monitor));
        }
        Iterator enginesIter = buildEngines.iterator();
        while (enginesIter.hasNext()) {
            Object next = enginesIter.next();
            if (next != null) continue;
            enginesIter.remove();
        }
        return buildEngines;
    }

    protected Control createDialogArea(Composite parent) {
        TreeColumn containerColumn;
        Dialog.applyDialogFont((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        Label viewPackageLabel = new Label(composite, 0);
        if (!this.isSelectingForRollback) {
            viewPackageLabel.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_DIALOG_DESCRIPTION);
        } else {
            viewPackageLabel.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_DIALOG_DESCRIPTION_ROLLBACK);
        }
        Composite selectPackageTableComposite = new Composite(composite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        selectPackageTableComposite.setLayout((Layout)tableColumnLayout);
        GridDataFactory.fillDefaults().indent(5, 0).hint(-1, 150).grab(true, false).applyTo((Control)selectPackageTableComposite);
        this.selectPackageTable = new Table(selectPackageTableComposite, 68160);
        TableColumn packageColumn = new TableColumn(this.selectPackageTable, 16384, 0);
        packageColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_PACKAGE_COLUMN);
        tableColumnLayout.setColumnData((Widget)packageColumn, (ColumnLayoutData)new ColumnWeightData(35));
        packageColumn.addSelectionListener(this.getPackageColumnSelectionListener(this.selectPackageTable, packageColumn, 0));
        TableColumn loadColumn = new TableColumn(this.selectPackageTable, 16384, 1);
        loadColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_LOADED_COLUMN);
        tableColumnLayout.setColumnData((Widget)loadColumn, (ColumnLayoutData)new ColumnWeightData(30));
        loadColumn.addSelectionListener(this.getPackageColumnSelectionListener(this.selectPackageTable, loadColumn, 1));
        TableColumn deployColumn = new TableColumn(this.selectPackageTable, 16384, 2);
        deployColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_PREVIOUSLY_DEPLOYED_COLUMN);
        tableColumnLayout.setColumnData((Widget)deployColumn, (ColumnLayoutData)new ColumnWeightData(30));
        deployColumn.addSelectionListener(this.getPackageColumnSelectionListener(this.selectPackageTable, deployColumn, 2));
        this.selectPackageTable.pack();
        this.selectPackageTableViewer = new TableViewer(this.selectPackageTable);
        this.selectPackageTable.setHeaderVisible(true);
        this.selectPackageTable.setLinesVisible(true);
        this.selectPackageTable.setSortColumn(this.selectPackageTable.getColumn(0));
        this.selectPackageTable.setSortDirection(1024);
        SelectPackageTableContentProvider contentProvider = new SelectPackageTableContentProvider();
        SelectPackageTableLabelProvider labelProvider = new SelectPackageTableLabelProvider();
        this.selectPackageTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.selectPackageTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.comparatorPackage = new AutomationViewerComparator();
        this.comparatorPackage.setColumn(0);
        this.comparatorPackage.setAscending(false);
        this.selectPackageTableViewer.setComparator((ViewerComparator)this.comparatorPackage);
        this.selectPackageTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectPackageMember selection = (SelectPackageMember)((IStructuredSelection)ViewPackageDialog.this.selectPackageTableViewer.getSelection()).getFirstElement();
                ViewPackageDialog.this.packageHandle = selection.getPackageHandle();
                ViewPackageDialog.this.updatePackageDetailsSection(ViewPackageDialog.this.packageHandle);
            }
        });
        this.selectPackageTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ViewPackageDialog.this.okPressed();
            }
        });
        for (IPackageHandle packageHandle : this.packageHandles) {
            this.querying.add(new SelectPackageMember(packageHandle.getLabel(), com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_PENDING_MSG, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_PENDING_MSG, packageHandle));
            this.selectPackageTableViewer.setInput(this.querying);
        }
        Job job = new Job(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_QUERYING_DATA_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    UUID buildAgentUUID = null;
                    try {
                        block7: for (IBuildEngine engine : ViewPackageDialog.this.getBuildEngines((IProgressMonitor)new NullProgressMonitor())) {
                            for (Object object : engine.getSupportedBuildDefinitions()) {
                                IBuildDefinitionHandle definition = (IBuildDefinitionHandle)object;
                                if (!definition.getItemId().equals((Object)ViewPackageDialog.this.deploymentDefinitionUUID)) continue;
                                buildAgentUUID = engine.getItemId();
                                continue block7;
                            }
                        }
                    }
                    catch (TeamRepositoryException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    IDeployment deploy = null;
                    IDeploymentJFSClient deployJFS = (IDeploymentJFSClient)ViewPackageDialog.this.repo.getClientLibrary(IDeploymentJFSClient.class);
                    for (IPackageHandle packageHandle : ViewPackageDialog.this.packageHandles) {
                        String packages = packageHandle.getLabel();
                        String hasLoaded = com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_NO_LABEL;
                        String hasDeployed = com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_NO_LABEL;
                        if (buildAgentUUID != null) {
                            try {
                                deploy = deployJFS.getDeployment(ViewPackageDialog.this.packageDefinitionUUID, ViewPackageDialog.this.deploymentDefinitionUUID, buildAgentUUID);
                            }
                            catch (TeamRepositoryException e) {
                                e.printStackTrace();
                            }
                            ViewPackageDialog.this.loadInfo = deploy.getLoadInfo();
                            ViewPackageDialog.this.deployInfo = deploy.getDeployInfos();
                            for (ILoadInfo info : ViewPackageDialog.this.loadInfo) {
                                if (!packageHandle.getBuildResultUUID().equals((Object)info.getPackageResultUUID())) continue;
                                hasLoaded = com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_YES_LABEL;
                            }
                            for (IDeployInfo infoD : ViewPackageDialog.this.deployInfo) {
                                if (!packageHandle.getBuildResultUUID().equals((Object)infoD.getPackageResultUUID())) continue;
                                hasDeployed = com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_YES_LABEL;
                            }
                        }
                        for (SelectPackageMember query : ViewPackageDialog.this.querying) {
                            if (!query.getPackages().equals(packages)) continue;
                            query.setLoaded(hasLoaded);
                            query.setPreviouslyDeployed(hasDeployed);
                        }
                    }
                    UIJob job = new UIJob(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_UPDATING_TABLE_JOB_NAME){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (!ViewPackageDialog.this.selectPackageTableViewer.getControl().isDisposed()) {
                                ViewPackageDialog.this.selectPackageTableViewer.refresh();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        Section detailsSection = new Section(composite, 256);
        detailsSection.setTitleBarBorderColor(Display.getCurrent().getSystemColor(1));
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)detailsSection);
        detailsSection.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_PACKAGE_DETAILS_SECTION_NAME);
        this.detailsComposite = new Composite((Composite)detailsSection, 0);
        this.detailsComposite.setLayoutData((Object)new GridData(768));
        GridLayout detailsLayout = new GridLayout(3, false);
        layout.marginLeft = 10;
        this.detailsComposite.setLayout((Layout)detailsLayout);
        Label packageDefL = new Label(this.detailsComposite, 0);
        packageDefL.setLayoutData((Object)GridDataFactory.fillDefaults().span(1, 0).create());
        packageDefL.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_PACKAGE_LABEL);
        this.packageDef = new Label(this.detailsComposite, 64);
        this.packageDef.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 0).create());
        this.packageDef.setText(this.packageL);
        Label locationLabelL = new Label(this.detailsComposite, 0);
        locationLabelL.setLayoutData((Object)GridDataFactory.fillDefaults().span(1, 0).create());
        locationLabelL.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_LOCATION_LABEL);
        this.locationLabel = new Label(this.detailsComposite, 64);
        this.locationLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 0).create());
        this.locationLabel.setText(this.locationL);
        Label timestampLabelL = new Label(this.detailsComposite, 0);
        timestampLabelL.setLayoutData((Object)GridDataFactory.fillDefaults().span(1, 0).create());
        timestampLabelL.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_TIMESTAMP_LABEL);
        this.timestampLabel = new Label(this.detailsComposite, 0);
        this.timestampLabel.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 0).create());
        this.timestampLabel.setText(this.timestampL);
        Composite packageDetailsTreeComposite = new Composite(this.detailsComposite, 0);
        TreeColumnLayout treeColumnLayoutDetails = new TreeColumnLayout();
        packageDetailsTreeComposite.setLayout((Layout)treeColumnLayoutDetails);
        GridDataFactory.fillDefaults().indent(5, 0).hint(-1, 150).grab(true, false).span(3, 1).applyTo((Control)packageDetailsTreeComposite);
        this.packageDetailsTree = new Tree(packageDetailsTreeComposite, 2120);
        if (this.template.contains("ibmi")) {
            containerColumn = new TreeColumn(this.packageDetailsTree, 16384, 0);
            containerColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_LIBRARY_COLUMN);
            treeColumnLayoutDetails.setColumnData((Widget)containerColumn, (ColumnLayoutData)new ColumnWeightData(40));
            containerColumn.addSelectionListener(this.getDetailsColumnSelectionListener(this.packageDetailsTree, containerColumn, 0));
            TreeColumn objectColumn = new TreeColumn(this.packageDetailsTree, 16384, 1);
            objectColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_OBJECT_COLUMN);
            treeColumnLayoutDetails.setColumnData((Widget)objectColumn, (ColumnLayoutData)new ColumnWeightData(30));
            objectColumn.addSelectionListener(this.getDetailsColumnSelectionListener(this.packageDetailsTree, objectColumn, 1));
            TreeColumn objectTypeColumn = new TreeColumn(this.packageDetailsTree, 16384, 2);
            objectTypeColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_OBJECT_TYPE_COLUMN);
            treeColumnLayoutDetails.setColumnData((Widget)objectTypeColumn, (ColumnLayoutData)new ColumnWeightData(30));
            objectTypeColumn.addSelectionListener(this.getDetailsColumnSelectionListener(this.packageDetailsTree, objectTypeColumn, 2));
        } else if (this.template.contains("zos")) {
            containerColumn = new TreeColumn(this.packageDetailsTree, 16384, 0);
            containerColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_PDS_COLUMN);
            treeColumnLayoutDetails.setColumnData((Widget)containerColumn, (ColumnLayoutData)new ColumnWeightData(60));
            containerColumn.addSelectionListener(this.getDetailsColumnSelectionListener(this.packageDetailsTree, containerColumn, 0));
            TreeColumn memberColumn = new TreeColumn(this.packageDetailsTree, 16384, 1);
            memberColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_MEMBER_COLUMN);
            treeColumnLayoutDetails.setColumnData((Widget)memberColumn, (ColumnLayoutData)new ColumnWeightData(20));
            memberColumn.addSelectionListener(this.getDetailsColumnSelectionListener(this.packageDetailsTree, memberColumn, 1));
            TreeColumn changeTypeColumn = new TreeColumn(this.packageDetailsTree, 16384, 2);
            changeTypeColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_CHANGE_TYPE_COLUMN);
            treeColumnLayoutDetails.setColumnData((Widget)changeTypeColumn, (ColumnLayoutData)new ColumnWeightData(20));
            changeTypeColumn.addSelectionListener(this.getDetailsColumnSelectionListener(this.packageDetailsTree, changeTypeColumn, 2));
        }
        this.packageDetailsTree.pack();
        this.packageDetailsTree.setHeaderVisible(true);
        this.packageDetailsTree.setLinesVisible(true);
        this.packageDetailsTree.setSortColumn(this.packageDetailsTree.getColumn(0));
        this.packageDetailsTree.setSortDirection(128);
        this.packageDetailsTreeViewer = new TreeViewer(this.packageDetailsTree);
        this.packageDetailsTreeViewer.setContentProvider((IContentProvider)new PackageDetailsTreeContentsProvider());
        this.packageDetailsTreeViewer.setLabelProvider((IBaseLabelProvider)new PackageDetailsTableLabelProvider(this.template.contains("ibmi")));
        this.comparatorPackageDetails = new AutomationViewerComparator();
        this.comparatorPackageDetails.setColumn(0);
        this.packageDetailsTreeViewer.setComparator((ViewerComparator)this.comparatorPackageDetails);
        detailsSection.setClient((Control)this.detailsComposite);
        Label hiddenLabel = new Label(this.detailsComposite, 0);
        hiddenLabel.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 0).create());
        hiddenLabel.setSize(1, 1);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    public void updateLabels(String packageL, String locationL, String timestampL) {
        this.packageDef.setText(packageL);
        this.locationLabel.setText(locationL);
        this.timestampLabel.setText(timestampL);
        this.locationLabel.getParent().layout();
    }

    protected void updatePackageDetailsSection(final IPackageHandle packageHandle) {
        Job ljob = new Job(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_GETTING_PACKAGE_INFORMATION_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                List<PackageDetailsMember> result;
                ViewPackageDialog.this.client = (IPackageJFSClient)ViewPackageDialog.this.repo.getClientLibrary(IPackageJFSClient.class);
                ViewPackageDialog.this.pkg = null;
                ArrayList<PackageDetailsMember> hfsFiles = new ArrayList<PackageDetailsMember>();
                ArrayList<PackageDetailsMember> nonHfsFiles = new ArrayList<PackageDetailsMember>();
                try {
                    ViewPackageDialog.this.pkg = ViewPackageDialog.this.client.getPackage(packageHandle.getBuildResultUUID(), packageHandle.getBuildDefinitionUUID());
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                ViewPackageDialog.this.packageContainer = ViewPackageDialog.this.pkg.getContainers();
                ViewPackageDialog.this.packageL = ViewPackageDialog.this.pkg.getLabel();
                ViewPackageDialog.this.locationL = ViewPackageDialog.this.pkg.getLocation();
                String formatedTime = TimeFormatHelper.getDateString((long)ViewPackageDialog.this.pkg.getTimestamp());
                ViewPackageDialog.this.timestampL = formatedTime;
                for (Container container : ViewPackageDialog.this.packageContainer) {
                    ViewPackageDialog.this.resource = container.getResourcesIterator();
                    String containerName = container.getName();
                    boolean hfs = "directory".equals(container.getType());
                    while (ViewPackageDialog.this.resource.hasNext()) {
                        Resource resourceContainer = (Resource)ViewPackageDialog.this.resource.next();
                        String object = resourceContainer.getName();
                        String objectType = resourceContainer.getIbmiType();
                        PackageDetailsMember mapping = new PackageDetailsMember(containerName, object, objectType, resourceContainer);
                        if (hfs) {
                            hfsFiles.add(mapping);
                            continue;
                        }
                        nonHfsFiles.add(mapping);
                    }
                }
                if (hfsFiles.isEmpty()) {
                    result = nonHfsFiles;
                } else if (nonHfsFiles.isEmpty()) {
                    result = hfsFiles;
                } else {
                    AutomationCategoryNode nonHfsCategory = new AutomationCategoryNode(ViewPackageDialog.this.template.contains("ibmi") ? Messages.AbstractAutomationConfigurationEditor_ADD_LIBRARY_OBJECTS : Messages.AbstractAutomationConfigurationEditor_ADD_MVS, 1);
                    nonHfsCategory.getChildren().addAll(nonHfsFiles);
                    AutomationCategoryNode hfsCategory = new AutomationCategoryNode(Messages.AbstractAutomationConfigurationEditor_ADD_HFS, 2);
                    hfsCategory.getChildren().addAll(hfsFiles);
                    result = Arrays.asList(nonHfsCategory, hfsCategory);
                }
                final String packageLfinal = ViewPackageDialog.this.packageL;
                final String locationLfinal = ViewPackageDialog.this.locationL;
                final String timestampLfinal = ViewPackageDialog.this.timestampL;
                UIJob job = new UIJob(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.ViewPackageDialog_UPDATING_TABLE_JOB_NAME){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!ViewPackageDialog.this.packageDef.isDisposed()) {
                            ViewPackageDialog.this.updateLabels(packageLfinal, locationLfinal, timestampLfinal);
                            ViewPackageDialog.this.packageDetailsTreeViewer.setInput(result);
                            ViewPackageDialog.this.packageDetailsTreeViewer.expandAll();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
                return Status.OK_STATUS;
            }
        };
        ljob.schedule();
    }
}

