/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.internal.ui.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionSelectionDialog;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.enterprise.deployment.dialogs.RequestDeployDialog;
import com.ibm.team.enterprise.deployment.internal.ui.nls.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SelectDeploymentDefinitionDialog
extends BuildDefinitionSelectionDialog {
    private static final String zOSNonSeqDeploymentId = "com.ibm.team.enterprise.deployment.nonseq.zos";
    private static final String IBMiNonSeqDeploymentId = "com.ibm.team.enterprise.deployment.nonseq.ibmi";
    private static final String templateId = "com.ibm.team.build.internal.template.id";

    public SelectDeploymentDefinitionDialog(Shell parentShell) {
        super(parentShell, false);
        this.setTitle(Messages.SelectDeploymentDefinitionDialog_TITLE);
        this.setMessage(Messages.SelectDeploymentDefinitionDialog_MESSAGE);
    }

    protected void okPressed() {
        super.okPressed();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part instanceof BuildQueryView || part instanceof IBuildResultContext) {
            IBuildDefinition buildDefinition = this.getFirstSelectedBuildDefinition();
            RequestDeployDialog dialog = this.createDialog(this.getShell(), buildDefinition);
            dialog.open();
        }
    }

    protected RequestDeployDialog createDialog(Shell shell, IBuildDefinition buildDefinition) {
        return new RequestDeployDialog(shell, (IBuildDefinitionHandle)buildDefinition);
    }

    public void setListElements(Object[] elements) {
        if (elements == null) {
            super.setListElements(elements);
            return;
        }
        boolean isIBMi = false;
        boolean isZOS = false;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        IBuildResultRecord record = null;
        if (part instanceof BuildQueryView) {
            BuildQueryView view = (BuildQueryView)part;
            IStructuredSelection selection = (IStructuredSelection)view.getViewer().getSelection();
            if (!selection.isEmpty()) {
                Object first = selection.getFirstElement();
                record = (IBuildResultRecord)Platform.getAdapterManager().getAdapter(first, IBuildResultRecord.class);
            }
        } else if (part instanceof IBuildResultContext) {
            IBuildResultContext editor = (IBuildResultContext)part;
            record = editor.getBuildResultRecord();
        }
        if (record != null) {
            IBuildDefinition definition = record.getBuildDefinition();
            IBuildProperty property = definition.getProperty(templateId);
            if (property != null && property.getValue().contains("ibmi")) {
                isIBMi = true;
            } else if (property != null && property.getValue().contains("zos")) {
                isZOS = true;
            }
        }
        ArrayList<IBuildDefinition> buildDefinitions = new ArrayList<IBuildDefinition>();
        boolean isAtLeastOneBuildDefinition = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object currentElement = objectArray[n2];
            if (currentElement instanceof IBuildDefinition) {
                IBuildDefinition buildDefinition;
                IBuildProperty property;
                if (!isAtLeastOneBuildDefinition) {
                    isAtLeastOneBuildDefinition = true;
                }
                if ((property = (buildDefinition = (IBuildDefinition)currentElement).getProperty(templateId)) != null) {
                    String templateValue = property.getValue();
                    if (isIBMi && IBMiNonSeqDeploymentId.equals(templateValue) || isZOS && zOSNonSeqDeploymentId.equals(templateValue)) {
                        buildDefinitions.add(buildDefinition);
                    }
                }
            }
            ++n2;
        }
        if (!buildDefinitions.isEmpty()) {
            super.setListElements(buildDefinitions.toArray());
        } else if (isAtLeastOneBuildDefinition) {
            super.setListElements(buildDefinitions.toArray());
        } else {
            super.setListElements(elements);
        }
    }
}

