/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.internal.ui.dialogs;

import com.ibm.team.enterprise.automation.ui.table.AutomationCategoryNode;
import com.ibm.team.enterprise.deployment.internal.ui.dialogs.PackageDetailsMember;
import com.ibm.team.enterprise.deployment.internal.ui.nls.Messages;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PackageDetailsTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final boolean isIBMi;

    public PackageDetailsTableLabelProvider(boolean isIBMi) {
        this.isIBMi = isIBMi;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof PackageDetailsMember) {
            PackageDetailsMember member = (PackageDetailsMember)element;
            switch (columnIndex) {
                case 0: {
                    return member.getContainerName();
                }
                case 1: {
                    return member.getObject();
                }
                case 2: {
                    if (this.isIBMi) {
                        return member.getObjectType();
                    }
                    return this.getTypeOfChange(member);
                }
            }
        } else if (element instanceof AutomationCategoryNode) {
            if (columnIndex == 0) {
                return ((AutomationCategoryNode)element).getName();
            }
            return "";
        }
        return null;
    }

    private String getTypeOfChange(PackageDetailsMember member) {
        String containerChangeType;
        String string = containerChangeType = member.getContainerDetails() == null || member.getContainerDetails().getContainer() == null ? null : member.getContainerDetails().getContainer().getChangeType();
        if ("DELETE".equals(containerChangeType)) {
            return Messages.ViewPackageDialog_DELETE;
        }
        return Messages.ViewPackageDialog_CREATE_OR_UPDATE;
    }
}

