/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.internal.ui.dialogs;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.ui.dialogs.requestbuild.IRequestBuildSectionFactory;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AddEditRestoreMappingDialog;
import com.ibm.team.enterprise.automation.ui.RestoreMappingMember;
import com.ibm.team.enterprise.automation.ui.RestoreMappingTableContentProvider;
import com.ibm.team.enterprise.automation.ui.RestoreMappingTableLabelProvider;
import com.ibm.team.enterprise.automation.ui.table.AutomationViewerComparator;
import com.ibm.team.enterprise.build.client.packaging.IPackageJFSClient;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.common.Messages;
import com.ibm.team.enterprise.deployment.internal.ui.dialogs.SelectPackageMember;
import com.ibm.team.enterprise.deployment.internal.ui.dialogs.ViewPackageDialog;
import com.ibm.team.enterprise.deployment.ui.DeploymentUIPlugin;
import com.ibm.team.enterprise.packaging.common.jfs.IPackage;
import com.ibm.team.enterprise.packaging.common.jfs.IPackageHandle;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.prefs.BackingStoreException;

public class DeploymentRequestBuildSection
extends RequestBuildSection {
    public static final String PREFERENCE_RESTORE_MAPPING_PREFIX = "personalRestoreMapping";
    public static final String PREFERENCE_HFS_DIRECTORY_PREFIX = "hfsDirectory";
    private static final String restorePropertyId = "team.deploy.common.restoreMappingList";
    private static final String templateDefPropertyId = "com.ibm.team.build.internal.template.id";
    private static final String zOSDef_NONSEQ = "com.ibm.team.enterprise.deployment.nonseq.zos";
    private final IBuildResultRecord record;
    private AutomationViewerComparator comparator;
    private DeployType deployType = DeployType.LOADANDDEPLOY;
    private Job pkgJob = null;
    private UIJob pkgUIJob = null;
    private UIUpdaterJob wrkUIJob = null;
    private Button openSummaryWorkItemButton;
    private Button personalDeployButton;
    private Button restoreMappingsAddButton;
    private Button restoreMappingsEditButton;
    private Button restoreMappingsRemoveButton;
    private Button viewPackageButton;
    private Combo deployTypeCombo;
    private Composite deploymentBuildOptionsComposite;
    private Composite treeComposite;
    private Label personalHFSTargetDirLabel;
    private Table restoreMappingTable;
    private TableViewer restoreMappingTableViewer;
    private Text packageSelectionText;
    private Text personalHFSTargetDirText;
    private UUID packageDefinitionUUID;
    private UUID selectedPackageUUID;
    private String personalHFSTargetDir;
    private String selectedPackageLabel;
    private String template;
    private String delimiter = ";";
    private boolean includesUnsupportedBuild = false;
    private boolean isPersonalDeploy = false;
    private boolean openSummaryWorkItem = false;
    private boolean retrievedPackages = false;
    private boolean toContainerListSet = false;
    private final List<SelectPackageMember> packageMembers = new ArrayList<SelectPackageMember>();
    private final Hashtable<String, RestoreMappingMember> restoreMappingMembers = new Hashtable();
    private final List<String> toContainersFromDefinition = new ArrayList<String>();
    private List<IPackageHandle> packageHandles;
    private SelectPackageMember result = null;
    private SelectPackageMember defaultResult = null;

    protected DeploymentRequestBuildSection(RequestBuildSectionSite site) {
        super(site);
        this.record = this.resolveSelectedPackageResult();
    }

    private IBuildResultRecord resolveSelectedPackageResult() {
        String template;
        IBuildResultRecord record = null;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part instanceof BuildQueryView) {
            BuildQueryView view = (BuildQueryView)part;
            IStructuredSelection selection = (IStructuredSelection)view.getViewer().getSelection();
            Object selectedObject = selection.getFirstElement();
            if (selectedObject != null) {
                record = (IBuildResultRecord)Platform.getAdapterManager().getAdapter(selectedObject, IBuildResultRecord.class);
            }
        } else if (part instanceof IBuildResultContext) {
            IBuildResultContext editor = (IBuildResultContext)part;
            record = editor.getBuildResultRecord();
        }
        if (!(record == null || (template = record.getBuildDefinition().getPropertyValue(templateDefPropertyId, null)) != null && template.startsWith("com.ibm.team.enterprise.packaging."))) {
            record = null;
        }
        return record;
    }

    public void createContent(Composite parent) {
        super.createContent(parent);
        ((GridData)this.getSection().getLayoutData()).exclude = true;
        this.getSection().setVisible(false);
    }

    protected void createSectionContent(Section section) {
        if (this.deploymentBuildOptionsComposite != null && !this.deploymentBuildOptionsComposite.isDisposed()) {
            this.cancelPkgJob();
            this.cancelPkgUIJob();
            this.cancelWrkUIJob();
            this.deploymentBuildOptionsComposite.dispose();
        }
        this.deploymentBuildOptionsComposite = new Composite((Composite)section, 0);
        this.deploymentBuildOptionsComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 10;
        this.deploymentBuildOptionsComposite.setLayout((Layout)layout);
        section.setClient((Control)this.deploymentBuildOptionsComposite);
        IBuildConfigurationElement element = this.getSite().getBuildDefinition().getConfigurationElement("com.ibm.team.enterprise.deployment");
        if (element == null) {
            element = this.getSite().getBuildDefinition().getConfigurationElement("com.ibm.team.enterprise.deployment.nonseq");
        }
        if (element != null) {
            ((GridData)this.getSection().getLayoutData()).exclude = false;
            this.getSection().setVisible(true);
            this.createDropdown(this.deploymentBuildOptionsComposite);
            if (element.getElementId().equals("com.ibm.team.enterprise.deployment.nonseq")) {
                this.createPackageSelectionSection(this.deploymentBuildOptionsComposite);
            }
            if (element.getElementId().equals("com.ibm.team.enterprise.deployment.nonseq")) {
                this.createPersonalDeploySection(this.deploymentBuildOptionsComposite);
            }
            this.openSummaryWorkItemButton = new Button(this.deploymentBuildOptionsComposite, 32);
            this.openSummaryWorkItemButton.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.OPEN_SUMMARY_WORK_ITEM);
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            this.openSummaryWorkItemButton.setLayoutData((Object)data);
            this.openSummaryWorkItem = false;
            this.wrkUIJob = new UIUpdaterJob(""){
                boolean disableSummaryWorkItemButton;

                public IStatus runInBackground(IProgressMonitor monitor) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    this.disableSummaryWorkItemButton = DeploymentRequestBuildSection.this.isDisableWorkItemCreation();
                    DeploymentRequestBuildSection.this.checkForDeprecatedBuild();
                    return super.runInBackground(monitor);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (this.disableSummaryWorkItemButton) {
                        DeploymentRequestBuildSection.this.openSummaryWorkItemButton.setEnabled(false);
                    }
                    DeploymentRequestBuildSection.this.openSummaryWorkItemButton.setSelection(DeploymentRequestBuildSection.this.openSummaryWorkItem);
                    DeploymentRequestBuildSection.this.openSummaryWorkItemButton.addSelectionListener(DeploymentRequestBuildSection.this.getSummaryWorkItemListener());
                    DeploymentRequestBuildSection.this.cancelWrkUIJob(false);
                    return super.runInUI(monitor);
                }
            };
            this.wrkUIJob.schedule();
            this.getSection().setExpanded(true);
        } else {
            Label noOptionsLabel = new Label(this.deploymentBuildOptionsComposite, 64);
            noOptionsLabel.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildDialog_NO_OPTIONS);
        }
    }

    private void checkForDeprecatedBuild() {
        IBuildDefinition packageDefinition;
        UUID packageDefUUID = this.getPackageDefinitionUUID();
        if (packageDefUUID != null && (packageDefinition = this.resolveBuildDefinition(packageDefUUID.getUuidValue())) != null) {
            IBuildProperty buildUUID = packageDefinition.getProperty("team.package.zos.buildDefinition.uuid");
            if (buildUUID == null) {
                buildUUID = packageDefinition.getProperty("team.package.common.buildDefinition.uuid");
            }
            if (buildUUID != null && buildUUID.getValue() != null) {
                IBuildDefinition sourceBuildDefinition = this.resolveBuildDefinition(buildUUID.getValue());
                this.includesUnsupportedBuild = sourceBuildDefinition != null && IBuildUtility.isOldDependencyBuild((IBuildDefinition)sourceBuildDefinition);
            }
        }
    }

    private IBuildDefinition resolveBuildDefinition(String uuidValue) {
        if (this.getSite().getTeamRepository() != null && !uuidValue.isEmpty()) {
            IItemHandle definitionHandle = IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuidValue), null);
            try {
                return (IBuildDefinition)this.getSite().getTeamRepository().itemManager().fetchCompleteItem(definitionHandle, 0, null);
            }
            catch (TeamRepositoryException e) {
                return null;
            }
        }
        return null;
    }

    private boolean isDisableWorkItemCreation() {
        boolean disabled = false;
        try {
            IProcessArea processArea = this.getProcessArea();
            if (processArea == null) {
                return disabled;
            }
            IProcessClientService processService = (IProcessClientService)this.getSite().getTeamRepository().getClientLibrary(IProcessClientService.class);
            IClientProcess clientProcess = processService.getClientProcess(processArea, null);
            IProcessConfigurationData data = clientProcess.getProjectConfigurationData("com.ibm.team.enterprise.process.configuration.packaging.resultWorkItem", null);
            if (data != null) {
                IProcessConfigurationElement[] elements = data.getElements();
                int i = 0;
                while (i < elements.length) {
                    IProcessConfigurationElement element = elements[i];
                    if ("resultWorkItem".equals(element.getName())) {
                        disabled = Boolean.parseBoolean(element.getAttribute("disable"));
                    }
                    ++i;
                }
            }
        }
        catch (TeamRepositoryException ex) {
            ex.printStackTrace();
        }
        return disabled;
    }

    protected IProcessArea getProcessArea() throws TeamRepositoryException {
        IProcessAreaHandle paHandle = this.getSite().getBuildDefinition().getProcessArea();
        if (paHandle != null) {
            return (IProcessArea)this.getSite().getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)paHandle, 0, null);
        }
        return null;
    }

    private void createDropdown(Composite composite) {
        Label comboLabel = new Label(composite, 0);
        comboLabel.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_DEPLOYTYPE_LABEL);
        this.deployTypeCombo = new Combo(composite, 12);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.deployTypeCombo);
        this.deployTypeCombo.add(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_LOADANDDEPLOY_OPTION);
        this.deployTypeCombo.add(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_LOAD_OPTION);
        this.deployTypeCombo.add(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_DEPLOY_OPTION);
        this.deployTypeCombo.add(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_ROLLBACK_OPTION);
        this.deployTypeCombo.select(0);
        this.deployTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String comboText = DeploymentRequestBuildSection.this.deployTypeCombo.getText();
                if (comboText.equalsIgnoreCase(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_LOADANDDEPLOY_OPTION)) {
                    DeploymentRequestBuildSection.this.deployType = DeployType.LOADANDDEPLOY;
                    DeploymentRequestBuildSection.this.packageSelectionText.setEnabled(true);
                    DeploymentRequestBuildSection.this.viewPackageButton.setEnabled(true);
                    DeploymentRequestBuildSection.this.personalDeployButton.setEnabled(true);
                } else if (comboText.equalsIgnoreCase(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_LOAD_OPTION)) {
                    DeploymentRequestBuildSection.this.deployType = DeployType.LOAD;
                    DeploymentRequestBuildSection.this.packageSelectionText.setEnabled(true);
                    DeploymentRequestBuildSection.this.viewPackageButton.setEnabled(true);
                    DeploymentRequestBuildSection.this.personalDeployButton.setEnabled(true);
                } else if (comboText.equalsIgnoreCase(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_DEPLOY_OPTION)) {
                    DeploymentRequestBuildSection.this.deployType = DeployType.DEPLOY;
                    DeploymentRequestBuildSection.this.packageSelectionText.setEnabled(true);
                    DeploymentRequestBuildSection.this.viewPackageButton.setEnabled(true);
                    DeploymentRequestBuildSection.this.personalDeployButton.setEnabled(true);
                } else if (comboText.equalsIgnoreCase(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_ROLLBACK_OPTION)) {
                    DeploymentRequestBuildSection.this.deployType = DeployType.ROLLBACK;
                    if (DeploymentRequestBuildSection.this.isMultipleRollbackAllowed()) {
                        DeploymentRequestBuildSection.this.packageSelectionText.setEnabled(true);
                        DeploymentRequestBuildSection.this.viewPackageButton.setEnabled(true);
                    } else {
                        DeploymentRequestBuildSection.this.packageSelectionText.setEnabled(false);
                        DeploymentRequestBuildSection.this.viewPackageButton.setEnabled(false);
                    }
                    DeploymentRequestBuildSection.this.personalDeployButton.setEnabled(false);
                }
                DeploymentRequestBuildSection.this.getSite().revalidate();
            }
        });
    }

    protected String getSectionName() {
        return com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildDialog_OPTIONS;
    }

    protected SelectionListener getSummaryWorkItemListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentRequestBuildSection.this.openSummaryWorkItem = DeploymentRequestBuildSection.this.openSummaryWorkItemButton.getSelection();
            }
        };
    }

    public void applyProperties(IBuildDefinition buildDefinition) {
        if (this.hasDeploymentConfiguration()) {
            String action = "";
            if (this.deployType == DeployType.LOAD) {
                action = "loadMain";
            } else if (this.deployType == DeployType.DEPLOY) {
                action = "deployMain";
            } else if (this.deployType == DeployType.ROLLBACK) {
                action = "rollbackMain";
            }
            buildDefinition.setProperty("team.deploy.common.action", action);
            buildDefinition.setProperty("team.deploy.common.openSummaryWorkItem", Boolean.toString(this.openSummaryWorkItem));
            if (this.selectedPackageUUID != null) {
                buildDefinition.setProperty("team.deploy.common.packageResultUUID", this.selectedPackageUUID.getUuidValue());
                buildDefinition.setProperty("team.deploy.common.packageLabel", this.selectedPackageLabel);
                if (this.isPersonalDeploy) {
                    String restoreMappingValue = this.createRestoreMappingString();
                    buildDefinition.setProperty(restorePropertyId, restoreMappingValue);
                    DeploymentUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_RESTORE_MAPPING_PREFIX + this.getSite().getBuildDefinition().getId(), restoreMappingValue);
                    if (this.personalHFSTargetDir != null) {
                        buildDefinition.setProperty("team.enterprise.deployment.hfs.runtimeRoot.personal.dir", this.personalHFSTargetDir);
                        DeploymentUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_HFS_DIRECTORY_PREFIX + this.getSite().getBuildDefinition().getId(), this.personalHFSTargetDir);
                    }
                    try {
                        InstanceScope.INSTANCE.getNode("com.ibm.team.enterprise.deployment.ui").flush();
                    }
                    catch (BackingStoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected boolean hasDeploymentConfiguration() {
        return this.getSite().getBuildDefinition().getConfigurationElement("com.ibm.team.enterprise.deployment") != null || this.getSite().getBuildDefinition().getConfigurationElement("com.ibm.team.enterprise.deployment.nonseq") != null;
    }

    private void getAddEditRestoreMappingDialog(Shell shell, String fromContainer, String toContainer, String template) {
        Object[] results;
        AddEditRestoreMappingDialog dialog;
        if (!this.toContainerListSet) {
            IBuildProperty property = this.getSite().getBuildDefinition().getProperty(restorePropertyId);
            String mappingValue = property.getValue();
            StringTokenizer tokenizer = new StringTokenizer(mappingValue, this.delimiter);
            while (tokenizer.hasMoreTokens()) {
                tokenizer.nextToken();
                this.toContainersFromDefinition.add(tokenizer.nextToken());
            }
            this.toContainerListSet = true;
        }
        if ((dialog = new AddEditRestoreMappingDialog(shell, fromContainer, toContainer, template, this.toContainersFromDefinition)).open() == 0 && (results = dialog.getResult()).length > 0) {
            RestoreMappingMember result = (RestoreMappingMember)results[0];
            this.restoreMappingMembers.put(result.getFromContainer(), result);
            if (!result.getFromContainer().equals(fromContainer)) {
                this.restoreMappingMembers.remove(fromContainer);
            }
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DeploymentRequestBuildSection.this.restoreMappingTableViewer.setInput(new ArrayList(DeploymentRequestBuildSection.this.restoreMappingMembers.values()));
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    private void getViewPackageDialog(Shell shell, ITeamRepository repo, List<IPackageHandle> packageHandles) {
        Object[] results;
        ViewPackageDialog dialog;
        UUID element = this.getSite().getBuildDefinition().getItemId();
        this.packageDefinitionUUID = this.getPackageDefinitionUUID();
        boolean isSelectingForRollback = false;
        if (this.deployType == DeployType.ROLLBACK) {
            isSelectingForRollback = true;
        }
        if ((dialog = new ViewPackageDialog(shell, repo, packageHandles, element, this.packageDefinitionUUID, this.template, isSelectingForRollback)).open() == 0 && (results = dialog.getResult()).length > 0 && results[0] != null) {
            this.result = (SelectPackageMember)results[0];
            this.selectedPackageLabel = this.result.getPackageHandle().getLabel();
            this.selectedPackageUUID = this.result.getPackageHandle().getBuildResultUUID();
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DeploymentRequestBuildSection.this.packageSelectionText.setText(DeploymentRequestBuildSection.this.result.getPackages());
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            this.getSite().revalidate();
        }
    }

    private String createRestoreMappingString() {
        String mapping = "";
        Set<String> fromSet = this.restoreMappingMembers.keySet();
        for (String fromContainerString : fromSet) {
            if (mapping.length() != 0) {
                mapping = String.valueOf(mapping) + this.delimiter;
            }
            mapping = String.valueOf(mapping) + fromContainerString + this.delimiter + this.restoreMappingMembers.get(fromContainerString).getToContainer();
        }
        return mapping;
    }

    private void removeRestoreMappingEntry(List<RestoreMappingMember> selection) {
        for (RestoreMappingMember item : selection) {
            this.restoreMappingMembers.remove(item.getFromContainer());
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DeploymentRequestBuildSection.this.restoreMappingTableViewer.setInput(new ArrayList(DeploymentRequestBuildSection.this.restoreMappingMembers.values()));
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    protected void updateRestoreMappingsButtonsEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.restoreMappingTableViewer.getSelection();
        this.restoreMappingsEditButton.setEnabled(selection.size() == 1);
        this.restoreMappingsRemoveButton.setEnabled(selection.size() >= 1);
    }

    public void mergeRestoreMappingMembers(List<RestoreMappingMember> members) {
        for (RestoreMappingMember member : members) {
            if (this.restoreMappingMembers.containsKey(member.getFromContainer())) continue;
            this.restoreMappingMembers.put(member.getFromContainer(), member);
        }
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                DeploymentRequestBuildSection.this.restoreMappingTableViewer.setInput(new ArrayList(DeploymentRequestBuildSection.this.restoreMappingMembers.values()));
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected SelectionListener getPersonalDeployButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentRequestBuildSection.this.isPersonalDeploy = DeploymentRequestBuildSection.this.personalDeployButton.getSelection();
                DeploymentRequestBuildSection.this.getSite().setProperty("personalBuild", (Object)DeploymentRequestBuildSection.this.isPersonalDeploy);
                DeploymentRequestBuildSection.this.restoreMappingTable.setEnabled(DeploymentRequestBuildSection.this.isPersonalDeploy);
                DeploymentRequestBuildSection.this.restoreMappingsAddButton.setEnabled(DeploymentRequestBuildSection.this.isPersonalDeploy);
                DeploymentRequestBuildSection.this.restoreMappingsEditButton.setEnabled(false);
                DeploymentRequestBuildSection.this.restoreMappingsRemoveButton.setEnabled(false);
                DeploymentRequestBuildSection.this.personalHFSTargetDirLabel.setEnabled(DeploymentRequestBuildSection.this.isPersonalDeploy);
                DeploymentRequestBuildSection.this.personalHFSTargetDirText.setEnabled(DeploymentRequestBuildSection.this.isPersonalDeploy);
            }
        };
    }

    private void createPersonalDeploySection(Composite parentComposite) {
        try {
            TableColumn toColumn;
            TableColumn fromColumn;
            this.personalDeployButton = new Button(parentComposite, 32);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.personalDeployButton);
            this.personalDeployButton.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_PERSONAL_DEPLOY_CHECKBOX);
            this.personalDeployButton.addSelectionListener(this.getPersonalDeployButtonListener());
            this.treeComposite = new Composite(parentComposite, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginLeft = 10;
            this.treeComposite.setLayout((Layout)layout);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.treeComposite);
            this.template = this.getSite().getBuildDefinition().getProperty(templateDefPropertyId).getValue();
            if (this.template.contains("ibmi")) {
                this.delimiter = ";;";
            }
            Composite tableComposite = new Composite(this.treeComposite, 0);
            TableColumnLayout tableColumnLayout = new TableColumnLayout();
            tableComposite.setLayout((Layout)tableColumnLayout);
            GridDataFactory.fillDefaults().indent(5, 0).hint(-1, 100).grab(true, false).applyTo((Control)tableComposite);
            this.restoreMappingTable = new Table(tableComposite, 68418);
            if (this.template.contains("ibmi")) {
                fromColumn = new TableColumn(this.restoreMappingTable, 16384, 0);
                fromColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.RestoreMappingComposite_FROM_LIBRARY);
                tableColumnLayout.setColumnData((Widget)fromColumn, (ColumnLayoutData)new ColumnWeightData(50));
                fromColumn.addSelectionListener(this.getColumnSelectionListener(this.restoreMappingTable, fromColumn, 0));
                toColumn = new TableColumn(this.restoreMappingTable, 16384, 1);
                toColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.RestoreMappingComposite_TO_LIBRARY);
                tableColumnLayout.setColumnData((Widget)toColumn, (ColumnLayoutData)new ColumnWeightData(50));
                toColumn.addSelectionListener(this.getColumnSelectionListener(this.restoreMappingTable, toColumn, 1));
            } else {
                fromColumn = new TableColumn(this.restoreMappingTable, 16384, 0);
                fromColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.RestoreMappingComposite_FROM_PDS);
                tableColumnLayout.setColumnData((Widget)fromColumn, (ColumnLayoutData)new ColumnWeightData(50));
                fromColumn.addSelectionListener(this.getColumnSelectionListener(this.restoreMappingTable, fromColumn, 0));
                toColumn = new TableColumn(this.restoreMappingTable, 16384, 1);
                toColumn.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.RestoreMappingComposite_TO_PDS);
                tableColumnLayout.setColumnData((Widget)toColumn, (ColumnLayoutData)new ColumnWeightData(50));
                toColumn.addSelectionListener(this.getColumnSelectionListener(this.restoreMappingTable, toColumn, 1));
            }
            this.restoreMappingTable.pack();
            this.restoreMappingTableViewer = new TableViewer(this.restoreMappingTable);
            this.restoreMappingTable.setHeaderVisible(true);
            this.restoreMappingTable.setLinesVisible(true);
            this.restoreMappingTable.setSortColumn(this.restoreMappingTable.getColumn(0));
            this.restoreMappingTable.setSortDirection(128);
            this.restoreMappingTable.setEnabled(false);
            RestoreMappingTableContentProvider contentProvider = new RestoreMappingTableContentProvider();
            RestoreMappingTableLabelProvider labelProvider = new RestoreMappingTableLabelProvider();
            this.restoreMappingTableViewer.setContentProvider((IContentProvider)contentProvider);
            this.restoreMappingTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.comparator = new AutomationViewerComparator();
            this.comparator.setColumn(0);
            this.restoreMappingTableViewer.setComparator((ViewerComparator)this.comparator);
            this.restoreMappingTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    DeploymentRequestBuildSection.this.updateRestoreMappingsButtonsEnablement();
                }
            });
            this.restoreMappingTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    RestoreMappingMember selection = (RestoreMappingMember)((IStructuredSelection)DeploymentRequestBuildSection.this.restoreMappingTableViewer.getSelection()).getFirstElement();
                    DeploymentRequestBuildSection.this.getAddEditRestoreMappingDialog(DeploymentRequestBuildSection.this.restoreMappingTable.getShell(), selection.getFromContainer(), selection.getToContainer(), DeploymentRequestBuildSection.this.template);
                }
            });
            boolean mappingFromDefinition = false;
            String mappingValue = DeploymentUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_RESTORE_MAPPING_PREFIX + this.getSite().getBuildDefinition().getId());
            if (mappingValue == null || mappingValue.equals("")) {
                IBuildProperty property = this.getSite().getBuildDefinition().getProperty(restorePropertyId);
                mappingValue = property.getValue();
                mappingFromDefinition = true;
            }
            StringTokenizer tokenizer = new StringTokenizer(mappingValue, this.delimiter);
            while (tokenizer.hasMoreTokens()) {
                String fromContainer = tokenizer.nextToken();
                String toContainer = tokenizer.nextToken();
                RestoreMappingMember mapping = mappingFromDefinition ? new RestoreMappingMember(fromContainer, "") : new RestoreMappingMember(fromContainer, toContainer);
                this.restoreMappingMembers.put(fromContainer, mapping);
            }
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DeploymentRequestBuildSection.this.restoreMappingTableViewer.setInput(new ArrayList(DeploymentRequestBuildSection.this.restoreMappingMembers.values()));
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            Composite buttonBar = new Composite(this.treeComposite, 0);
            buttonBar.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
            buttonBar.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
            this.restoreMappingsAddButton = new Button(buttonBar, 8);
            this.restoreMappingsAddButton.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.RestoreMappingComposite_ADD_BUTTON_LABEL);
            this.restoreMappingsAddButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            this.restoreMappingsAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeploymentRequestBuildSection.this.getAddEditRestoreMappingDialog(DeploymentRequestBuildSection.this.restoreMappingTable.getShell(), "", "", DeploymentRequestBuildSection.this.template);
                }
            });
            this.restoreMappingsAddButton.setEnabled(false);
            this.restoreMappingsEditButton = new Button(buttonBar, 8);
            this.restoreMappingsEditButton.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.RestoreMappingComposite_EDIT_BUTTON_LABEL);
            this.restoreMappingsEditButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            this.restoreMappingsEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RestoreMappingMember selection = (RestoreMappingMember)((IStructuredSelection)DeploymentRequestBuildSection.this.restoreMappingTableViewer.getSelection()).getFirstElement();
                    DeploymentRequestBuildSection.this.getAddEditRestoreMappingDialog(DeploymentRequestBuildSection.this.restoreMappingTable.getShell(), selection.getFromContainer(), selection.getToContainer(), DeploymentRequestBuildSection.this.template);
                }
            });
            this.restoreMappingsEditButton.setEnabled(false);
            this.restoreMappingsRemoveButton = new Button(buttonBar, 8);
            this.restoreMappingsRemoveButton.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.RestoreMappingComposite_REMOVE_BUTTON_LABEL);
            this.restoreMappingsRemoveButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            this.restoreMappingsRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List selection = ((IStructuredSelection)DeploymentRequestBuildSection.this.restoreMappingTableViewer.getSelection()).toList();
                    DeploymentRequestBuildSection.this.removeRestoreMappingEntry(selection);
                }
            });
            this.restoreMappingsRemoveButton.setEnabled(false);
            Composite hfsComposite = new Composite(this.treeComposite, 0);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)hfsComposite);
            GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(2).applyTo(hfsComposite);
            this.personalHFSTargetDirLabel = new Label(hfsComposite, 64);
            this.personalHFSTargetDirLabel.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_TEXT_HFSROOT_DIR);
            GridDataFactory.fillDefaults().grab(false, false).align(1, 2).indent(5, 0).applyTo((Control)this.personalHFSTargetDirLabel);
            this.personalHFSTargetDirText = new Text(hfsComposite, 2052);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.personalHFSTargetDirText);
            this.addTooltip(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_TEXT_HFSROOT_DIR_TOOLTIP, (Control)this.personalHFSTargetDirLabel);
            this.addTooltip(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentNonSequentialConfigurationEditor_TEXT_HFSROOT_DIR_TOOLTIP, (Control)this.personalHFSTargetDirText);
            this.personalHFSTargetDirLabel.setEnabled(false);
            this.personalHFSTargetDirText.setEnabled(false);
            this.personalHFSTargetDirText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DeploymentRequestBuildSection.this.personalHFSTargetDir = DeploymentRequestBuildSection.this.personalHFSTargetDirText.getText();
                }
            });
            this.personalHFSTargetDir = DeploymentUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_HFS_DIRECTORY_PREFIX + this.getSite().getBuildDefinition().getId());
            if (this.personalHFSTargetDir != null) {
                this.personalHFSTargetDirText.setText(this.personalHFSTargetDir);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTooltip(final String tooltip, final Control c) {
        new TooltipSupport(c, true, false){

            public Object getElement(Control control, int x, int y) {
                return c;
            }

            protected String getMarkup(Object element, boolean isFocus) {
                return tooltip;
            }
        };
    }

    protected SelectionListener getColumnSelectionListener(final Table table, final TableColumn tableColumn, final int columnNum) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentRequestBuildSection.this.comparator.setColumn(columnNum);
                if (table.getSortColumn() == tableColumn) {
                    if (table.getSortDirection() == 1024) {
                        table.setSortDirection(128);
                    } else {
                        table.setSortDirection(1024);
                    }
                } else {
                    table.setSortColumn(tableColumn);
                    table.setSortDirection(128);
                }
                DeploymentRequestBuildSection.this.restoreMappingTableViewer.refresh();
            }
        };
    }

    private void createPackageSelectionSection(Composite parentComposite) {
        try {
            Label label = new Label(parentComposite, 0);
            label.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_PACKAGE_LABEL);
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)label);
            this.packageSelectionText = new Text(parentComposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.packageSelectionText);
            if (this.record != null) {
                this.pkgJob = this.getPackageRecordJob();
                this.pkgJob.schedule();
            } else {
                this.pkgJob = this.getPackageSelectionJob();
                this.pkgJob.schedule();
            }
            this.viewPackageButton = new Button(parentComposite, 8);
            GridDataFactory.fillDefaults().applyTo((Control)this.viewPackageButton);
            this.viewPackageButton.setText(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_VIEW_PACKAGE_BUTTON_TEXT);
            this.viewPackageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (!DeploymentRequestBuildSection.this.retrievedPackages) {
                        DeploymentRequestBuildSection.this.pkgJob = DeploymentRequestBuildSection.this.getPackageSelectionJob();
                        DeploymentRequestBuildSection.this.pkgJob.schedule();
                    }
                    DeploymentRequestBuildSection.this.getViewPackageDialog(DeploymentRequestBuildSection.this.restoreMappingTable.getShell(), DeploymentRequestBuildSection.this.getSite().getTeamRepository(), DeploymentRequestBuildSection.this.packageHandles);
                }
            });
            if (this.record != null) {
                String selectedLabel = this.record.getBuildResult().getLabel();
                this.packageSelectionText.setText(selectedLabel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Job getPackageRecordJob() {
        return new Job(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_GETTING_PACKAGE_INFORMATION_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                IPackageJFSClient clientLibrary = (IPackageJFSClient)DeploymentRequestBuildSection.this.getSite().getTeamRepository().getClientLibrary(IPackageJFSClient.class);
                IBuildResult buildResult = DeploymentRequestBuildSection.this.record.getBuildResult();
                UUID uuid1 = buildResult.getItemId();
                UUID uuid2 = buildResult.getBuildDefinition().getItemId();
                try {
                    final IPackage pkg = clientLibrary.getPackage(uuid1, uuid2);
                    if (!monitor.isCanceled()) {
                        DeploymentRequestBuildSection.this.pkgUIJob = new UIJob(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_UPDATING_PACKAGE_INFO_TABLE_JOB_NAME){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (!monitor.isCanceled() && DeploymentRequestBuildSection.this.hasPackageSelectionText() && !DeploymentRequestBuildSection.this.packageSelectionText.getText().equals("") && DeploymentRequestBuildSection.this.packageSelectionText.getText().equals(pkg.getLabel())) {
                                    DeploymentRequestBuildSection.this.selectedPackageLabel = pkg.getLabel();
                                    DeploymentRequestBuildSection.this.selectedPackageUUID = pkg.getBuildResultUUID();
                                    DeploymentRequestBuildSection.this.getSite().revalidate();
                                }
                                DeploymentRequestBuildSection.this.cancelPkgUIJob(false);
                                return Status.OK_STATUS;
                            }
                        };
                        if (!monitor.isCanceled()) {
                            DeploymentRequestBuildSection.this.pkgUIJob.schedule();
                        }
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                DeploymentRequestBuildSection.this.cancelPkgJob(false);
                return Status.OK_STATUS;
            }
        };
    }

    private Job getPackageSelectionJob() {
        return new Job(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_GETTING_PACKAGE_INFORMATION_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                IPackageJFSClient clientLibrary = (IPackageJFSClient)DeploymentRequestBuildSection.this.getSite().getTeamRepository().getClientLibrary(IPackageJFSClient.class);
                DeploymentRequestBuildSection.this.packageDefinitionUUID = DeploymentRequestBuildSection.this.getPackageDefinitionUUID();
                try {
                    DeploymentRequestBuildSection.this.packageHandles = clientLibrary.getAllPackageHandles(DeploymentRequestBuildSection.this.packageDefinitionUUID);
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (DeploymentRequestBuildSection.this.packageHandles == null) {
                    return new Status(4, "com.ibm.team.enterprise.deployment.ui", com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_GETTING_PACKAGE_INFORMATION_JOB_ERROR);
                }
                for (IPackageHandle packageHandle : DeploymentRequestBuildSection.this.packageHandles) {
                    String packages = packageHandle.getLabel();
                    SelectPackageMember mapping = new SelectPackageMember(packages, "", "", packageHandle);
                    DeploymentRequestBuildSection.this.packageMembers.add(mapping);
                }
                if (!monitor.isCanceled()) {
                    DeploymentRequestBuildSection.this.pkgUIJob = new UIJob(com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_UPDATING_PACKAGE_INFO_TABLE_JOB_NAME){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            if (DeploymentRequestBuildSection.this.hasPackageSelectionText()) {
                                int size;
                                if (!DeploymentRequestBuildSection.this.packageSelectionText.getText().equals("")) {
                                    String selectedLabel = DeploymentRequestBuildSection.this.packageSelectionText.getText();
                                    for (IPackageHandle packageHandle : DeploymentRequestBuildSection.this.packageHandles) {
                                        if (!selectedLabel.equals(packageHandle.getLabel())) continue;
                                        DeploymentRequestBuildSection.this.selectedPackageLabel = packageHandle.getLabel();
                                        DeploymentRequestBuildSection.this.selectedPackageUUID = packageHandle.getBuildResultUUID();
                                    }
                                }
                                if ((size = DeploymentRequestBuildSection.this.packageMembers.size()) != 0 && DeploymentRequestBuildSection.this.packageSelectionText.getText().equals("")) {
                                    DeploymentRequestBuildSection.this.defaultResult = (SelectPackageMember)DeploymentRequestBuildSection.this.packageMembers.get(size - 1);
                                    DeploymentRequestBuildSection.this.packageSelectionText.setText(DeploymentRequestBuildSection.this.defaultResult.getPackages());
                                    DeploymentRequestBuildSection.this.selectedPackageLabel = DeploymentRequestBuildSection.this.defaultResult.getPackageHandle().getLabel();
                                    DeploymentRequestBuildSection.this.selectedPackageUUID = DeploymentRequestBuildSection.this.defaultResult.getPackageHandle().getBuildResultUUID();
                                }
                                if (monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                DeploymentRequestBuildSection.this.getSite().revalidate();
                            }
                            DeploymentRequestBuildSection.this.cancelPkgUIJob(false);
                            return Status.OK_STATUS;
                        }
                    };
                }
                if (!monitor.isCanceled()) {
                    DeploymentRequestBuildSection.this.pkgUIJob.schedule();
                }
                DeploymentRequestBuildSection.this.retrievedPackages = true;
                DeploymentRequestBuildSection.this.cancelPkgJob(false);
                return Status.OK_STATUS;
            }
        };
    }

    private UUID getPackageDefinitionUUID() {
        List properties = this.getSite().getBuildDefinition().getProperties();
        for (IBuildProperty property : properties) {
            if (!property.getName().equals("team.deploy.common.packagedefinitionUUID")) continue;
            return UUID.valueOf((String)property.getValue());
        }
        return null;
    }

    public void cancelPkgJob() {
        this.cancelPkgJob(true);
    }

    private synchronized void cancelPkgJob(boolean cancel) {
        if (this.pkgJob != null) {
            if (cancel) {
                this.pkgJob.cancel();
            }
            this.pkgJob = null;
        }
    }

    public void cancelPkgUIJob() {
        this.cancelPkgUIJob(true);
    }

    private synchronized void cancelPkgUIJob(boolean cancel) {
        if (this.pkgUIJob != null) {
            if (cancel) {
                this.pkgUIJob.cancel();
            }
            this.pkgUIJob = null;
        }
    }

    public void cancelWrkUIJob() {
        this.cancelWrkUIJob(true);
    }

    private synchronized void cancelWrkUIJob(boolean cancel) {
        if (this.wrkUIJob != null) {
            if (cancel) {
                this.wrkUIJob.cancel();
            }
            this.wrkUIJob = null;
        }
    }

    public boolean isMultipleRollbackAllowed() {
        boolean isMultiRollback = false;
        IBuildProperty multiRollbackProperty = this.getSite().getBuildDefinition().getProperty("team.deploy.common.rollback.multipleAllowed");
        if (multiRollbackProperty != null) {
            isMultiRollback = Boolean.parseBoolean(multiRollbackProperty.getValue());
        }
        return isMultiRollback;
    }

    private boolean isNonseqTemplate() {
        String templateId;
        IBuildProperty property;
        IBuildDefinition buildDef = this.getSite().getBuildDefinition();
        return buildDef != null && (property = buildDef.getProperty(templateDefPropertyId)) != null && ((templateId = property.getValue()) != null && templateId.equals(zOSDef_NONSEQ) || templateId.contains("nonseq.ibmi"));
    }

    public boolean validate2() {
        if (this.includesUnsupportedBuild) {
            this.getSite().addErrorMessage((Object)this, Messages.DEPRECATED_TEMPLATE_NOT_SUPPORTED);
            return false;
        }
        if (!this.isSetPackageSelectionText() && this.deployType != DeployType.ROLLBACK && this.isNonseqTemplate()) {
            this.getSite().addErrorMessage((Object)this, com.ibm.team.enterprise.deployment.internal.ui.nls.Messages.DeploymentRequestBuildSection_ERROR_NO_PACKAGE_SELECTED);
            return false;
        }
        this.getSite().removeErrorMessage((Object)this);
        return super.validate2();
    }

    private boolean hasPackageSelectionText() {
        if (this.packageSelectionText == null) {
            return false;
        }
        return !this.packageSelectionText.isDisposed();
    }

    private boolean isSetPackageSelectionText() {
        if (this.packageSelectionText == null) {
            return false;
        }
        if (this.packageSelectionText.isDisposed()) {
            return false;
        }
        if (this.packageSelectionText.getText() == null) {
            return false;
        }
        return !this.packageSelectionText.getText().trim().isEmpty();
    }

    public static enum DeployType {
        LOADANDDEPLOY,
        LOAD,
        DEPLOY,
        ROLLBACK,
        UNINSTALL;

    }

    public static class Factory
    implements IRequestBuildSectionFactory {
        public RequestBuildSection createRequestBuildSection(RequestBuildSectionSite site) {
            return new DeploymentRequestBuildSection(site);
        }
    }
}

