/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.dialogs;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestParams;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialog;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.enterprise.build.client.deployment.IDeploymentClient;
import com.ibm.team.enterprise.deployment.dialogs.Messages;
import com.ibm.team.enterprise.deployment.internal.ui.dialogs.DeploymentRequestBuildSection;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class RequestDeployDialog
extends RequestBuildDialog {
    public RequestDeployDialog(Shell parentShell, IBuildDefinitionHandle buildDefinitionHandle) {
        super(parentShell, buildDefinitionHandle);
    }

    protected void cancelPressed() {
        this.cancelJobs();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.cancelJobs();
        super.okPressed();
    }

    private void cancelJobs() {
        for (RequestBuildSection section : this.fSections) {
            if (!(section instanceof DeploymentRequestBuildSection)) continue;
            DeploymentRequestBuildSection deploymentSection = (DeploymentRequestBuildSection)section;
            deploymentSection.cancelPkgJob();
            deploymentSection.cancelPkgUIJob();
            deploymentSection.cancelWrkUIJob();
            break;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.setTitle(Messages.RequestDeployDialog_PAGE_TITLE);
        return control;
    }

    protected IBuildRequest requestBuild(ITeamRepository teamRepository, IBuildDefinitionHandle buildDefinitionHandle, IBuildProperty[] newAndModifiedBuildProperties, IBuildProperty[] deletedBuildProperties, boolean allowDuplicateRequests, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        IDeploymentClient deploymentClient;
        IWorkItemHandle wiHandle;
        IBuildRequestParams params = BuildItemFactory.createBuildRequestParams();
        params.setBuildDefinition(buildDefinitionHandle);
        params.getNewOrModifiedBuildProperties().addAll(Arrays.asList(newAndModifiedBuildProperties));
        params.getDeletedBuildProperties().addAll(Arrays.asList(deletedBuildProperties));
        params.setAllowDuplicateRequests(allowDuplicateRequests);
        params.setPersonalBuild(this.fIsPersonalBuild);
        if (this.fHandlingEngine != null) {
            params.getPotentialHandlers().add(this.fHandlingEngine);
        }
        if ((wiHandle = (deploymentClient = (IDeploymentClient)teamRepository.getClientLibrary(IDeploymentClient.class)).deploy3(params, monitor)) != null && this.getSummaryWorkItemPropertyValue(newAndModifiedBuildProperties).booleanValue()) {
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage activePage = window != null ? window.getActivePage() : null;
                    WorkItemUI.openEditor((IWorkbenchPage)activePage, (Object)wiHandle);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return null;
    }

    protected String getHeaderText() {
        return Messages.RequestDeployDialog_DESCRIPTION;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RequestDeployDialog_DIALOG_TITLE);
    }

    Boolean getSummaryWorkItemPropertyValue(IBuildProperty[] newAndModifiedBuildProperties) {
        IBuildProperty[] iBuildPropertyArray = newAndModifiedBuildProperties;
        int n = newAndModifiedBuildProperties.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildProperty property = iBuildPropertyArray[n2];
            if (property.getName().equals("team.deploy.common.openSummaryWorkItem")) {
                return Boolean.parseBoolean(property.getValue());
            }
            ++n2;
        }
        return false;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point point = super.getInitialLocation(initialSize);
        point.y = point.y > 100 ? (point.y -= 100) : 0;
        return point;
    }
}

