/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.common.model.query.BaseBuildEngineQueryModel;
import com.ibm.team.enterprise.build.client.packaging.IPackageJFSClient;
import com.ibm.team.enterprise.deployment.dialogs.Messages;
import com.ibm.team.enterprise.packaging.common.jfs.IPackageHandle;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class QueryDeployedPackagesDialog
extends TitleAreaDialog {
    private Combo deploymentDefinitionCombo;
    private Combo buildEngineCombo;
    private Combo packageResultCombo;
    private Combo packageDefinitionCombo;
    private IBuildDefinition deploymentDefinition;
    private IBuildDefinition packageDefinition;
    private IBuildEngine buildEngine;
    private IPackageHandle packageHandle;
    private final ITeamRepository repository;
    private UIUpdaterJob job1 = null;
    private UIUpdaterJob job2 = null;
    private UIUpdaterJob job3 = null;
    private UIUpdaterJob job4 = null;

    public QueryDeployedPackagesDialog(Shell parentShell, ITeamRepository repository, IBuildDefinition deploymentDefinition) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.repository = repository;
        this.deploymentDefinition = deploymentDefinition;
        this.packageDefinition = this.getPackageDefinition(deploymentDefinition);
        this.setHelpAvailable(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.QueryDeployedPackagesDialog_DIALOG_TITLE);
    }

    public IBuildDefinition getDeploymentDefinition() {
        return this.deploymentDefinition;
    }

    public IBuildEngine getBuildEngine() {
        return this.buildEngine;
    }

    public IPackageHandle getPackageHandle() {
        return this.packageHandle;
    }

    public IBuildDefinition getPackageDefinition() {
        return this.packageDefinition;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.QueryDeployedPackagesDialog_DIALOG_TITLE);
        this.setMessage(Messages.QueryDeployedPackagesDialog_DIALOG_DESCRIPTION);
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        Composite mainComposite = new Composite(dialogAreaComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainComposite);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(mainComposite);
        Label label = new Label(mainComposite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
        label = new Label(mainComposite, 0);
        label.setText(Messages.QueryDeployedPackagesDialog_DEPLOYMENT_DEFINITION_LABEL);
        label.setLayoutData((Object)new GridData());
        this.deploymentDefinitionCombo = new Combo(mainComposite, 0);
        this.deploymentDefinitionCombo.setLayoutData((Object)new GridData(768));
        this.fillDeploymentDefinitionCombo();
        this.deploymentDefinitionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QueryDeployedPackagesDialog.this.deploymentDefinitionCombo.getText().equals("*")) {
                    QueryDeployedPackagesDialog.this.packageDefinitionCombo.setText("*");
                    QueryDeployedPackagesDialog.this.buildEngineCombo.setText("*");
                    QueryDeployedPackagesDialog.this.packageResultCombo.setText("*");
                } else {
                    String selectedDefinitionId = QueryDeployedPackagesDialog.this.deploymentDefinitionCombo.getText();
                    QueryDeployedPackagesDialog.this.deploymentDefinition = (IBuildDefinition)QueryDeployedPackagesDialog.this.deploymentDefinitionCombo.getData(selectedDefinitionId);
                    QueryDeployedPackagesDialog.this.fillPackageDefinitionCombo();
                    QueryDeployedPackagesDialog.this.fillBuildEngineCombo();
                }
            }
        });
        label = new Label(mainComposite, 0);
        label.setText(Messages.QueryDeployedPackagesDialog_PACKAGE_DEFINITION_LABEL);
        label.setLayoutData((Object)new GridData());
        this.packageDefinitionCombo = new Combo(mainComposite, 0);
        this.packageDefinitionCombo.setLayoutData((Object)new GridData(256));
        this.fillPackageDefinitionCombo();
        this.packageDefinitionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (QueryDeployedPackagesDialog.this.packageDefinitionCombo.getText().equals("*")) {
                    QueryDeployedPackagesDialog.this.deploymentDefinitionCombo.setText("*");
                    QueryDeployedPackagesDialog.this.buildEngineCombo.setText("*");
                    QueryDeployedPackagesDialog.this.packageResultCombo.setText("*");
                } else {
                    QueryDeployedPackagesDialog.this.packageDefinition = (IBuildDefinition)QueryDeployedPackagesDialog.this.packageDefinitionCombo.getData(QueryDeployedPackagesDialog.this.packageDefinitionCombo.getText());
                    QueryDeployedPackagesDialog.this.fillPackageResultCombo();
                }
            }
        });
        label = new Label(mainComposite, 0);
        label.setText(Messages.QueryDeployedPackagesDialog_BUILD_AGENT_LABEL);
        label.setLayoutData((Object)new GridData());
        this.buildEngineCombo = new Combo(mainComposite, 0);
        this.buildEngineCombo.setLayoutData((Object)new GridData(256));
        this.fillBuildEngineCombo();
        this.buildEngineCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QueryDeployedPackagesDialog.this.buildEngineCombo.getText().equals("*")) {
                    QueryDeployedPackagesDialog.this.deploymentDefinitionCombo.setText("*");
                    QueryDeployedPackagesDialog.this.packageDefinitionCombo.setText("*");
                    QueryDeployedPackagesDialog.this.packageResultCombo.setText("*");
                } else {
                    String selectedBuildEngineId = QueryDeployedPackagesDialog.this.buildEngineCombo.getText();
                    QueryDeployedPackagesDialog.this.buildEngine = (IBuildEngine)QueryDeployedPackagesDialog.this.buildEngineCombo.getData(selectedBuildEngineId);
                }
            }
        });
        label = new Label(mainComposite, 0);
        label.setText(Messages.QueryDeployedPackagesDialog_PACKAGES_LABEL);
        label.setLayoutData((Object)new GridData());
        this.packageResultCombo = new Combo(mainComposite, 0);
        this.packageResultCombo.setLayoutData((Object)new GridData(256));
        this.fillPackageResultCombo();
        this.packageResultCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!QueryDeployedPackagesDialog.this.packageResultCombo.getText().equals("*")) {
                    String packageLabel = QueryDeployedPackagesDialog.this.packageResultCombo.getText();
                    QueryDeployedPackagesDialog.this.packageHandle = (IPackageHandle)QueryDeployedPackagesDialog.this.packageResultCombo.getData(packageLabel);
                }
            }
        });
        return dialogAreaComposite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private void fillDeploymentDefinitionCombo() {
        if (this.job2 != null) {
            this.job2.cancel();
        } else {
            this.job2 = new UIUpdaterJob(""){
                List<IBuildDefinition> deploymentDefinitions;
                {
                    this.deploymentDefinitions = null;
                }

                public IStatus runInBackground(IProgressMonitor monitor) {
                    try {
                        this.deploymentDefinitions = QueryDeployedPackagesDialog.this.queryDeploymentDefinitions();
                        Collections.sort(this.deploymentDefinitions, new BuildDefinitionComparator());
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                    return super.runInBackground(monitor);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    QueryDeployedPackagesDialog.this.deploymentDefinitionCombo.add("*");
                    QueryDeployedPackagesDialog.this.deploymentDefinitionCombo.select(0);
                    for (IBuildDefinition deploymentDefinition : this.deploymentDefinitions) {
                        QueryDeployedPackagesDialog.this.deploymentDefinitionCombo.add(deploymentDefinition.getId());
                        QueryDeployedPackagesDialog.this.deploymentDefinitionCombo.setData(deploymentDefinition.getId(), (Object)deploymentDefinition);
                    }
                    if (QueryDeployedPackagesDialog.this.deploymentDefinition != null) {
                        QueryDeployedPackagesDialog.this.deploymentDefinitionCombo.setText(QueryDeployedPackagesDialog.this.deploymentDefinition.getId());
                    }
                    return super.runInUI(monitor);
                }
            };
        }
        this.job2.schedule();
    }

    private void fillBuildEngineCombo() {
        this.buildEngineCombo.removeAll();
        this.buildEngineCombo.add("*");
        this.buildEngineCombo.select(0);
        if (this.deploymentDefinition == null) {
            return;
        }
        if (this.job1 != null) {
            this.job1.cancel();
        } else {
            this.job1 = new UIUpdaterJob(""){
                List<IBuildEngine> buildEngines;
                {
                    this.buildEngines = null;
                }

                public IStatus runInBackground(IProgressMonitor monitor) {
                    try {
                        this.buildEngines = QueryDeployedPackagesDialog.this.queryBuildEngines((IBuildDefinitionHandle)QueryDeployedPackagesDialog.this.deploymentDefinition);
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                    return super.runInBackground(monitor);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    QueryDeployedPackagesDialog.this.buildEngineCombo.add("");
                    for (IBuildEngine buildEngine : this.buildEngines) {
                        QueryDeployedPackagesDialog.this.buildEngineCombo.setText(buildEngine.getId());
                        QueryDeployedPackagesDialog.this.buildEngineCombo.setData(buildEngine.getId(), (Object)buildEngine);
                    }
                    return super.runInUI(monitor);
                }
            };
        }
        this.job1.schedule();
    }

    private List<IBuildEngine> queryBuildEngines(IBuildDefinitionHandle buildDefinitionHandle) throws TeamRepositoryException {
        BaseBuildEngineQueryModel.BuildEngineQueryModel buildEngineQueryModel = BaseBuildEngineQueryModel.BuildEngineQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildEngineQueryModel);
        IPredicate left = buildEngineQueryModel.supportedBuildDefinitions().itemId()._eq((IUUID)query.newUUIDArg());
        IPredicate right = buildEngineQueryModel.active()._isTrue();
        query.filter(left._and(right));
        ITeamRepository repository = (ITeamRepository)buildDefinitionHandle.getOrigin();
        IQueryService queryService = ((TeamRepository)repository).getQueryService();
        IItemQueryPage queryPage = queryService.queryItems(query, new Object[]{buildDefinitionHandle.getItemId()}, Integer.MAX_VALUE);
        IItemHandle[] itemHandles = queryPage.handlesAsArray();
        return repository.itemManager().fetchCompleteItems(Arrays.asList(itemHandles), 0, null);
    }

    private IBuildDefinition getPackageDefinition(IBuildDefinition deploymentDefinition) {
        if (deploymentDefinition == null) {
            return null;
        }
        try {
            IBuildProperty packageDefinitionUUIDProperty = deploymentDefinition.getProperty("team.deploy.common.packagedefinitionUUID");
            if (packageDefinitionUUIDProperty != null) {
                String packageDefinitionUUIDValue = packageDefinitionUUIDProperty.getValue();
                UUID packageDefinitionUUID = UUID.valueOf((String)packageDefinitionUUIDValue);
                IBuildDefinitionHandle packageDefinitionHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(packageDefinitionUUID, null);
                return (IBuildDefinition)((ITeamRepository)deploymentDefinition.getOrigin()).itemManager().fetchCompleteItem((IItemHandle)packageDefinitionHandle, 0, null);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        return null;
    }

    private void fillPackageResultCombo() {
        this.packageResultCombo.removeAll();
        this.packageResultCombo.setText("*");
        this.packageResultCombo.select(0);
        if (this.packageDefinition == null) {
            return;
        }
        if (this.job3 != null) {
            this.job3.cancel();
        } else {
            this.job3 = new UIUpdaterJob(""){
                List<IPackageHandle> packageHandles;
                {
                    this.packageHandles = null;
                }

                public IStatus runInBackground(IProgressMonitor monitor) {
                    try {
                        IPackageJFSClient client = (IPackageJFSClient)QueryDeployedPackagesDialog.this.repository.getClientLibrary(IPackageJFSClient.class);
                        this.packageHandles = client.getAllPackageHandles(QueryDeployedPackagesDialog.this.packageDefinition.getItemId());
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                    return super.runInBackground(monitor);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    QueryDeployedPackagesDialog.this.packageResultCombo.add("*");
                    for (IPackageHandle packageHandle : this.packageHandles) {
                        QueryDeployedPackagesDialog.this.packageResultCombo.add(packageHandle.getLabel());
                        QueryDeployedPackagesDialog.this.packageResultCombo.setData(packageHandle.getLabel(), (Object)packageHandle);
                    }
                    return super.runInUI(monitor);
                }
            };
        }
        this.job3.schedule();
    }

    private void fillPackageDefinitionCombo() {
        this.packageDefinitionCombo.removeAll();
        this.packageDefinitionCombo.add("*");
        this.packageDefinitionCombo.select(0);
        if (this.job4 != null) {
            this.job4.cancel();
        } else {
            this.job4 = new UIUpdaterJob(""){
                List<IBuildDefinition> packageDefinitions;
                {
                    this.packageDefinitions = null;
                }

                public IStatus runInBackground(IProgressMonitor monitor) {
                    try {
                        if (QueryDeployedPackagesDialog.this.deploymentDefinition != null) {
                            QueryDeployedPackagesDialog.this.packageDefinition = QueryDeployedPackagesDialog.this.getPackageDefinition(QueryDeployedPackagesDialog.this.deploymentDefinition);
                        } else {
                            this.packageDefinitions = QueryDeployedPackagesDialog.this.queryPackageDefinitions();
                            Collections.sort(this.packageDefinitions, new BuildDefinitionComparator());
                        }
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                    return super.runInBackground(monitor);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    if (QueryDeployedPackagesDialog.this.deploymentDefinition != null) {
                        QueryDeployedPackagesDialog.this.packageDefinitionCombo.setText(QueryDeployedPackagesDialog.this.packageDefinition.getId());
                        QueryDeployedPackagesDialog.this.packageDefinitionCombo.setData(QueryDeployedPackagesDialog.this.packageDefinition.getId(), (Object)QueryDeployedPackagesDialog.this.packageDefinition);
                    } else {
                        for (IBuildDefinition packageDefinition : this.packageDefinitions) {
                            QueryDeployedPackagesDialog.this.packageDefinitionCombo.add(packageDefinition.getId());
                            QueryDeployedPackagesDialog.this.packageDefinitionCombo.setData(packageDefinition.getId(), (Object)packageDefinition);
                        }
                    }
                    return super.runInUI(monitor);
                }
            };
        }
        this.job4.schedule();
    }

    private List<IBuildDefinition> queryPackageDefinitions() throws TeamRepositoryException {
        return this.queryDefinitions("com.ibm.team.enterprise.packaging.nonseq");
    }

    private List<IBuildDefinition> queryDeploymentDefinitions() throws TeamRepositoryException {
        return this.queryDefinitions("com.ibm.team.enterprise.deployment.nonseq");
    }

    private List<IBuildDefinition> queryDefinitions(String buildConfigurationElementId) throws TeamRepositoryException {
        BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel model = BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        IPredicate left = model.configurationElements().elementId()._eq(buildConfigurationElementId);
        query.filter(left);
        IQueryService queryService = ((TeamRepository)this.repository).getQueryService();
        IItemQueryPage queryPage = queryService.queryItems(query, IQueryService.EMPTY_PARAMETERS, Integer.MAX_VALUE);
        IItemHandle[] itemHandles = queryPage.handlesAsArray();
        return this.repository.itemManager().fetchCompleteItems(Arrays.asList(itemHandles), 0, null);
    }

    class BuildDefinitionComparator
    implements Comparator<IBuildDefinition> {
        BuildDefinitionComparator() {
        }

        @Override
        public int compare(IBuildDefinition def1, IBuildDefinition def2) {
            return def1.getId().compareTo(def2.getId());
        }
    }
}

