/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.build.ui.dialogs.EnterpriseBuildDefinitionSelectionDialog;
import com.ibm.team.process.common.IProcessAreaHandle;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Shell;

public class DeploymentBuildDefinitionSelectionDialog
extends EnterpriseBuildDefinitionSelectionDialog {
    private final boolean isZOS;
    private final boolean isIBMi;
    private final boolean isLUW;
    private String zOSPackagingID = "com.ibm.team.enterprise.packaging.zos";
    private String ibmiPackagingID = "com.ibm.team.enterprise.packaging.ibmi";
    private final String luwPackagingID = "com.ibm.team.enterprise.packaging.luw";

    public DeploymentBuildDefinitionSelectionDialog(Shell parent, boolean isNonSeq, boolean isZOS, boolean isIBMi, boolean isLUW) {
        this(parent, isNonSeq, isZOS, isIBMi, isLUW, null);
    }

    public DeploymentBuildDefinitionSelectionDialog(Shell parent, boolean isNonSeq, boolean isZOS, boolean isIBMi, boolean isLUW, IProcessAreaHandle processArea) {
        super(parent, false, processArea);
        this.isZOS = isZOS;
        this.isIBMi = isIBMi;
        this.isLUW = isLUW;
        if (isNonSeq) {
            this.zOSPackagingID = "com.ibm.team.enterprise.packaging.nonseq.zos";
            this.ibmiPackagingID = "com.ibm.team.enterprise.packaging.nonseq.ibmi";
        }
    }

    public void setListElements(Object[] elements) {
        if (elements == null) {
            super.setListElements(elements);
            return;
        }
        ArrayList<IBuildDefinition> buildDefinitions = new ArrayList<IBuildDefinition>();
        boolean isAtLeastOneBuildDefinition = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object currentElement = objectArray[n2];
            if (currentElement instanceof IBuildDefinition) {
                IBuildDefinition buildDefinition;
                IBuildProperty buildProperty;
                if (!isAtLeastOneBuildDefinition) {
                    isAtLeastOneBuildDefinition = true;
                }
                if ((buildProperty = (buildDefinition = (IBuildDefinition)currentElement).getProperty("com.ibm.team.build.internal.template.id")) != null) {
                    String template = buildProperty.getValue();
                    if (this.isZOS && template.equals(this.zOSPackagingID)) {
                        buildDefinitions.add(buildDefinition);
                    } else if (this.isIBMi && template.equals(this.ibmiPackagingID)) {
                        buildDefinitions.add(buildDefinition);
                    } else if (this.isLUW && template.equals("com.ibm.team.enterprise.packaging.luw")) {
                        buildDefinitions.add(buildDefinition);
                    }
                }
            }
            ++n2;
        }
        if (!buildDefinitions.isEmpty()) {
            super.setListElements(buildDefinitions.toArray());
        } else if (isAtLeastOneBuildDefinition) {
            super.setListElements(buildDefinitions.toArray());
        } else {
            super.setListElements(elements);
        }
    }
}

