/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.luw.deployment.taskdefs;

import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import com.ibm.team.luw.deployment.taskdefs.Messages;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.eclipse.osgi.util.NLS;

public class ValidateLUWPermissionsAndDeleteFilesTask
extends Task {
    private String deployDestination = null;
    private String manifest = null;
    private String deployPackageDir = null;

    public void execute() throws BuildException {
        FileSet fileSet;
        block10: {
            Project project = this.getProject();
            fileSet = new FileSet();
            this.deployPackageDir = project.getProperty("team.deploy.common.deployPackage.dir");
            if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30(project)) {
                File deltaDeployFile = new File(String.valueOf(this.deployPackageDir) + File.separator + "deltaDeployed.xml");
                try {
                    ManifestReader mr = ManifestReader.getInstance();
                    if (deltaDeployFile.exists()) {
                        Manifest mf = mr.getManifest(deltaDeployFile);
                        List containers = mf.getUpdatedContainers();
                        for (Container c : containers) {
                            if (!c.getType().equalsIgnoreCase("directory")) continue;
                            String folder = c.getName();
                            Iterator iter = c.getResourcesIterator();
                            while (iter.hasNext()) {
                                com.ibm.team.enterprise.automation.manifest.Resource resourceFilter = (com.ibm.team.enterprise.automation.manifest.Resource)iter.next();
                                if (!resourceFilter.getType().equalsIgnoreCase("file") && !resourceFilter.getType().equalsIgnoreCase("directory")) continue;
                                fileSet.setIncludes(String.valueOf(folder) + File.separator + resourceFilter.getName());
                            }
                        }
                        break block10;
                    }
                    throw new BuildException(Messages.ValidateLUWPermissionsAndDeleteFilesTask_DELTA_DEPLOY_FILE_NOT_CREATED_ERROR_MSG);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BuildException(NLS.bind((String)Messages.ValidateLUWPermissionsAndDeleteFilesTask_EXCEPTION_PROCESSING_DELTA_DEPLOY_MANIFEST_ERROR_MSG, (Object)deltaDeployFile.getAbsolutePath()));
                }
            }
            this.manifest = String.valueOf(this.deployPackageDir) + File.separator + "package.mf";
            fileSet.setIncludesfile(new File(this.manifest));
        }
        if (fileSet.hasPatterns()) {
            File file;
            fileSet.setDir(new File(this.deployDestination));
            fileSet.setProject(this.getProject());
            for (Resource nextFile : fileSet) {
                this.getProject().log(NLS.bind((String)Messages.ValidateLUWPermissionsAndDeleteFilesTask_CHECKING_FILE_LOG_MSG, (Object)nextFile.getName()));
                file = new File(String.valueOf(this.deployDestination) + File.separator + nextFile.getName());
                if (!file.exists()) continue;
                if (!file.canRead()) {
                    throw new BuildException(NLS.bind((String)Messages.ValidateLUWPermissionsAndDeleteFilesTask_COULD_NOT_READ_FILE_AT_LOCATION_ERROR_MSG, (Object)file.getAbsolutePath()));
                }
                if (file.canWrite()) continue;
                throw new BuildException(NLS.bind((String)Messages.ValidateLUWPermissionsAndDeleteFilesTask_COULD_NOT_WRITE_FILE_AT_LOCATION_ERROR_MSG, (Object)file.getAbsolutePath()));
            }
            for (Resource nextFile : fileSet) {
                file = new File(String.valueOf(this.deployDestination) + File.separator + nextFile.getName());
                if (!file.exists()) continue;
                this.getProject().log(NLS.bind((String)Messages.ValidateLUWPermissionsAndDeleteFilesTask_DELETING_FILE_LOG_MSG, (Object)nextFile.getName()));
                if (file.delete()) continue;
                throw new BuildException(NLS.bind((String)Messages.ValidateLUWPermissionsAndDeleteFilesTask_FAILED_TO_DELETE_FILE_ROLLBACK_REQUIRED_ERROR_MSG, (Object)file.getAbsolutePath()));
            }
        }
    }

    public void setDeployDestination(String deployDestination) {
        this.deployDestination = deployDestination;
    }
}

