/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.luw.deployment.taskdefs;

import com.ibm.team.enterprise.automation.parsers.ContainerMappingDocument;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class ValidateLUWDeployTask
extends Task {
    private String restoreMappingFilePath = null;

    public void execute() throws BuildException {
        String targetContainer;
        File restoreMappingFile;
        Project project = this.getProject();
        if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30(project) && (restoreMappingFile = new File(this.restoreMappingFilePath)).exists() && (targetContainer = this.getRestoreContainerMapping()) != null) {
            project.setProperty("team.deploy.luw.runtimeRoot.dir", targetContainer);
        }
    }

    private String getRestoreContainerMapping() {
        ContainerMappingDocument parser = new ContainerMappingDocument();
        FileInputStream fileInput = null;
        try {
            fileInput = new FileInputStream(this.restoreMappingFilePath);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.restoreMappingFilePath) + " cannot be found.");
        }
        parser.parse((InputStream)fileInput);
        Properties properties = parser.getContainerMappingProperties();
        String targetContainer = null;
        Collection<Object> targets = properties.values();
        for (Object target : targets) {
            targetContainer = (String)target;
        }
        return targetContainer;
    }

    public void setRestoreMappingFilePath(String restoreMappingFilePath) {
        this.restoreMappingFilePath = restoreMappingFilePath;
    }
}

