/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.luw.deployment.taskdefs;

import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.deployment.taskdefs.GenerateDeployStatusTask;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import com.ibm.team.luw.deployment.taskdefs.Messages;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class LUWUninstallTask
extends Task {
    private String runtimeDir = null;
    private String rollbackDir = null;
    private String deployStatusFile = null;
    private String cumulativeDeployXML = null;

    public void execute() throws BuildException {
        block10: {
            Project project = this.getProject();
            if (!CheckDeploymentVersions.isDefinitionVersionGreaterThan30(project)) {
                return;
            }
            if (this.deployStatusFile == null) {
                this.deployStatusFile = project.getProperty("team.deploy.common.deployStatusFile");
            }
            if (this.rollbackDir == null) {
                this.rollbackDir = project.getProperty("team.deploy.common.rollback.dir");
            }
            if (this.cumulativeDeployXML == null) {
                this.cumulativeDeployXML = String.valueOf(project.getProperty("team.deploy.common.localPackageRoot.dir")) + File.separator + project.getProperty("team.deploy.common.applicationName") + File.separator + project.getProperty("team.deploy.common.version") + File.separator + "cumulativeDeployed.xml";
            }
            try {
                this.restoreBackUps(project);
                File cumulativeDeployFile = new File(this.cumulativeDeployXML);
                if (cumulativeDeployFile.exists()) {
                    File containerFile;
                    Manifest cumulativeManifest = ManifestReader.getInstance().getManifest(cumulativeDeployFile);
                    List deleteContainers = cumulativeManifest.getCreatedContainers();
                    for (Container c : deleteContainers) {
                        Iterator iter = c.getResourcesIterator();
                        while (iter.hasNext()) {
                            Resource resource = (Resource)iter.next();
                            this.deleteFile(String.valueOf(this.runtimeDir) + File.separator + c.getName() + File.separator + resource.getName(), project);
                        }
                        containerFile = new File(String.valueOf(this.runtimeDir) + File.separator + c.getName());
                        if (!c.getChangeType().equals("ADD") || containerFile.listFiles() != null && containerFile.listFiles().length != 0) continue;
                        this.deleteFile(String.valueOf(this.runtimeDir) + File.separator + c.getName(), project);
                    }
                    for (Container c : deleteContainers) {
                        containerFile = new File(String.valueOf(this.runtimeDir) + File.separator + c.getName());
                        if (!c.getChangeType().equals("ADD") || containerFile.listFiles() != null && containerFile.listFiles().length != 0) continue;
                        this.deleteFile(String.valueOf(this.runtimeDir) + File.separator + c.getName(), project);
                    }
                    break block10;
                }
                throw new BuildException(Messages.LUWUninstallTask_CUMULATIVE_DEPLOY_MANIFEST_FILE_DOES_NOT_EXIST_ERROR_MSG);
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteFile(String filePath, Project project) throws BuildException {
        project.log(NLS.bind((String)Messages.LUWUninstallTask_CHECKING_FILE_LOG_MSG, (Object)filePath));
        File resourceFile = new File(filePath);
        if (resourceFile.exists()) {
            if (!resourceFile.canRead()) {
                throw new BuildException(NLS.bind((String)Messages.LUWRollbackTask_COULD_NOT_READ_FILE_ERROR_MSG, (Object)filePath));
            }
            if (!resourceFile.canWrite()) {
                throw new BuildException(NLS.bind((String)Messages.LUWRollbackTask_COULD_NOT_WRITE_FILE_ERROR_MSG, (Object)filePath));
            }
            project.log(NLS.bind((String)Messages.LUWUninstallTask_DELETING_FILE_LOG_MSG, (Object)filePath));
            if (!resourceFile.delete()) {
                throw new BuildException(NLS.bind((String)Messages.LUWRollbackTask_FAILED_TO_DELETE_FILE_ERROR_MSG, (Object)filePath));
            }
        }
    }

    private List<String> getTimestampList() throws Exception {
        ArrayList<String> timestampList = new ArrayList<String>();
        String timestamps = GenerateDeployStatusTask.getTimestamps(this.deployStatusFile);
        StringTokenizer strTokens = new StringTokenizer(timestamps, ",");
        while (strTokens.hasMoreTokens()) {
            timestampList.add(strTokens.nextToken());
        }
        return timestampList;
    }

    public static final void unzipBackupFile(File srcFile, String destDir, Project project) throws BuildException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(srcFile, 1);
                Enumeration<? extends ZipEntry> zipEntry = zipFile.entries();
                int BUFFER = 2048;
                while (zipEntry.hasMoreElements()) {
                    int read;
                    ZipEntry entry = zipEntry.nextElement();
                    File destFile = new File(String.valueOf(destDir) + File.separator + entry.getName());
                    if (entry.isDirectory()) {
                        if (destFile.exists()) continue;
                        destFile.mkdirs();
                        continue;
                    }
                    destFile.getParentFile().mkdirs();
                    InputStream inputStream = zipFile.getInputStream(entry);
                    BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destFile));
                    byte[] buffer = new byte[BUFFER];
                    while ((read = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, read);
                    }
                    inputStream.close();
                    outputStream.close();
                }
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void restoreBackUps(Project project) throws Exception {
        List<String> timestampList = this.getTimestampList();
        for (String timestamp : timestampList) {
            String backupFileName;
            File backupFile;
            File timestampDir = new File(String.valueOf(this.rollbackDir) + File.separator + timestamp);
            if (!timestampDir.exists() || !timestampDir.isDirectory() || !(backupFile = new File(backupFileName = String.valueOf(this.rollbackDir) + File.separator + timestamp + File.separator + "backup.zip")).exists()) continue;
            LUWUninstallTask.unzipBackupFile(backupFile, this.runtimeDir, project);
            project.log(NLS.bind((String)Messages.LUWUninstallTask_UNZIPPING_FILE_LOG_MSG, (Object)backupFile));
        }
    }

    public void setRuntimeDir(String runtimeDir) {
        this.runtimeDir = runtimeDir;
    }
}

