/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.luw.deployment.taskdefs;

import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import com.ibm.team.luw.deployment.taskdefs.Messages;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class LUWRollbackTask
extends Task {
    String rollbackDir = null;
    String runtimeDir = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        Project project = this.getProject();
        try {
            if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30(project)) {
                File containerFile;
                Resource resource;
                Iterator iter;
                File rollbackManifestFile = new File(String.valueOf(this.rollbackDir) + File.separator + "rollbackManifest.xml");
                if (!rollbackManifestFile.exists()) throw new BuildException(Messages.LUWRollbackTask_ROLLBACK_MANIFEST_DOES_NOT_EXIST_ERROR_MSG);
                Manifest rollbackManifest = ManifestReader.getInstance().getManifest(rollbackManifestFile);
                List deleteContainers = rollbackManifest.getDeletedContainers();
                List updateContainers = rollbackManifest.getUpdatedContainers();
                for (Container c : deleteContainers) {
                    iter = c.getResourcesIterator();
                    while (iter.hasNext()) {
                        resource = (Resource)iter.next();
                        this.deleteFile(String.valueOf(this.runtimeDir) + File.separator + c.getName() + File.separator + resource.getName(), project);
                    }
                    containerFile = new File(String.valueOf(this.runtimeDir) + File.separator + c.getName());
                    if (!c.getChangeType().equals("DELETE") || containerFile.listFiles() != null && containerFile.listFiles().length != 0) continue;
                    this.deleteFile(String.valueOf(this.runtimeDir) + File.separator + c.getName(), project);
                }
                for (Container c : deleteContainers) {
                    containerFile = new File(String.valueOf(this.runtimeDir) + File.separator + c.getName());
                    if (!c.getChangeType().equals("DELETE") || containerFile.listFiles() != null && containerFile.listFiles().length != 0) continue;
                    this.deleteFile(String.valueOf(this.runtimeDir) + File.separator + c.getName(), project);
                }
                for (Container c : updateContainers) {
                    iter = c.getResourcesIterator();
                    while (iter.hasNext()) {
                        resource = (Resource)iter.next();
                        this.deleteFile(String.valueOf(this.runtimeDir) + File.separator + c.getName() + File.separator + resource.getName(), project);
                    }
                }
            } else {
                project.setProperty("team.deploy.common.30BuildDef", "true");
            }
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        File backUpZip = new File(String.valueOf(this.rollbackDir) + File.separator + "backup.zip");
        if (!backUpZip.exists()) return;
        project.setProperty("team.deploy.luw.temp.backupZipExists", "true");
    }

    public void deleteFile(String filePath, Project project) throws BuildException {
        project.log(NLS.bind((String)Messages.LUWRollbackTask_CHECKING_FILE_LOG_MSG, (Object)filePath));
        File resourceFile = new File(filePath);
        if (resourceFile.exists()) {
            if (!resourceFile.canRead()) {
                throw new BuildException(NLS.bind((String)Messages.LUWRollbackTask_COULD_NOT_READ_FILE_ERROR_MSG, (Object)filePath));
            }
            if (!resourceFile.canWrite()) {
                throw new BuildException(NLS.bind((String)Messages.LUWRollbackTask_COULD_NOT_WRITE_FILE_ERROR_MSG, (Object)filePath));
            }
            project.log(NLS.bind((String)Messages.LUWRollbackTask_DELETING_FILE_LOG_MSG, (Object)filePath));
            if (!resourceFile.delete()) {
                throw new BuildException(NLS.bind((String)Messages.LUWRollbackTask_FAILED_TO_DELETE_FILE_ERROR_MSG, (Object)filePath));
            }
        }
    }

    public void setRuntimeDir(String runtimeDir) {
        this.runtimeDir = runtimeDir;
    }

    public void setRollbackDir(String rollbackDir) {
        this.rollbackDir = rollbackDir;
    }
}

