/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.luw.deployment.taskdefs;

import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.ManifestWriter;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.deployment.hfs.Messages;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class LUWBackupRuntimeDirectoryTask
extends Task {
    private String deployDestination = null;
    private String manifest = null;
    private String deployPackageDir = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        Project project = this.getProject();
        try (PrintWriter out = null;){
            try {
                this.deployPackageDir = project.getProperty("team.deploy.common.deployPackage.dir");
                String zipCompatibleBackupFileName = String.valueOf(this.deployPackageDir) + File.separator + "backupFiles.asLUWFileSet";
                if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30(project)) {
                    out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(zipCompatibleBackupFileName), "UTF-8")));
                    this.manifest = String.valueOf(this.deployPackageDir) + File.separator + "packageManifest.xml";
                    File rollbackBackup = new File(String.valueOf(project.getProperty("team.deploy.common.rollback.dir")) + File.separator + "backup.zip");
                    if (rollbackBackup.exists()) {
                        rollbackBackup.delete();
                    }
                    File manifestFile = new File(this.manifest);
                    Manifest deltaManifest = new Manifest();
                    deltaManifest.setType("MANIFEST_REPORT");
                    Hashtable<String, Container> updatedContainers = new Hashtable<String, Container>();
                    Hashtable<String, Container> createdContainers = new Hashtable<String, Container>();
                    ManifestReader mr = ManifestReader.getInstance();
                    if (!manifestFile.exists()) throw new BuildException(NLS.bind((String)Messages.BackUpHFSFilesTask_PACKAGE_MANIFEST_NOT_FOUND_ERROR_MSG, (Object)this.manifest));
                    Manifest mf = mr.getManifest(manifestFile);
                    List containers = mf.getContainers();
                    for (Container c : containers) {
                        if (!c.getType().equalsIgnoreCase("directory")) continue;
                        String folder = c.getName();
                        Iterator iter = c.getResourcesIterator();
                        while (iter.hasNext()) {
                            File containerFile;
                            Resource resourceFilter = (Resource)iter.next();
                            if (!resourceFilter.getType().equalsIgnoreCase("file") && !resourceFilter.getType().equalsIgnoreCase("directory")) continue;
                            File resourceFile = new File(String.valueOf(this.deployDestination) + File.separator + folder + File.separator + resourceFilter.getName());
                            if (resourceFile.exists()) {
                                Container updateContainer = (Container)updatedContainers.get(folder);
                                if (updateContainer == null) {
                                    updateContainer = new Container();
                                    updateContainer.setName(folder);
                                    updateContainer.setType("directory");
                                    containerFile = new File(String.valueOf(this.deployDestination) + File.separator + folder);
                                    if (containerFile.exists()) {
                                        updateContainer.setChangeType("UPDATE");
                                    } else {
                                        updateContainer.setChangeType("ADD");
                                    }
                                    deltaManifest.getUpdatedContainers().add(updateContainer);
                                    updatedContainers.put(folder, updateContainer);
                                }
                                updateContainer.addResource(resourceFilter);
                                out.println(String.valueOf(folder) + File.separator + resourceFilter.getName());
                                continue;
                            }
                            Container createdContainer = (Container)createdContainers.get(folder);
                            if (createdContainer == null) {
                                createdContainer = new Container();
                                createdContainer.setName(folder);
                                createdContainer.setType("directory");
                                containerFile = new File(String.valueOf(this.deployDestination) + File.separator + folder);
                                if (containerFile.exists()) {
                                    createdContainer.setChangeType("UPDATE");
                                } else {
                                    createdContainer.setChangeType("ADD");
                                }
                                deltaManifest.getCreatedContainers().add(createdContainer);
                                createdContainers.put(folder, createdContainer);
                            }
                            createdContainer.addResource(resourceFilter);
                        }
                    }
                    String deltaDeployFilepath = String.valueOf(project.getProperty("team.deploy.common.deployPackage.dir")) + File.separator + "deltaDeployed.xml";
                    ManifestWriter writer = ManifestWriter.getInstance();
                    writer.write(new File(deltaDeployFilepath), deltaManifest);
                    out.flush();
                    out.close();
                    FileInputStream zipCompatibleBackupFileStream = new FileInputStream(new File(zipCompatibleBackupFileName));
                    if (zipCompatibleBackupFileStream.read() != -1) {
                        project.setProperty("team.deploy.luw.temp.backupFiles", zipCompatibleBackupFileName);
                    }
                    String timestamp = null;
                    String isCompletePackageValue = project.getProperty("team.deploy.common.isCompletePackage");
                    timestamp = Boolean.parseBoolean(isCompletePackageValue) ? project.getProperty("team.deploy.common.newDeployTimeStamp") : project.getProperty("team.deploy.common.newUpdateDeployTimeStamp");
                    String backupFileLocation = String.valueOf(project.getProperty("team.deploy.common.rollback.dir")) + File.separator + timestamp;
                    File timstampDir = new File(backupFileLocation);
                    if (!timstampDir.exists()) {
                        timstampDir.mkdir();
                    }
                    project.setProperty("team.deploy.luw.temp.backupFileLocation", backupFileLocation);
                    return;
                } else {
                    project.setProperty("team.deploy.common.30BuildDef", "true");
                }
                return;
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setDeployDestination(String deployDestination) {
        this.deployDestination = deployDestination;
    }
}

