/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.team.enterprise.deployment.toolkit.manifest.AbstractGenerateManifest;
import com.ibm.team.scm.common.internal.util.XMLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GenerateRollbackManifest
extends AbstractGenerateManifest {
    private String CREATED_TAG = "created";
    private String DELETED_TAG = "deleted";
    private String UPDATED_TAG = "updated";
    private String TRANSIENT = "_tmp";
    private String CONTAINER_TAG = "container";
    private String RESOURCE_TAG = "resource";
    private String CHANGE_TYPE = "changeType";
    private String ADD_TYPE = "ADD";
    private String DELETE_TYPE = "DELETE";
    private String SIZE_TYPE = "size";
    private String LAST_MODIFIED_TIME_TYPE = "lastModifiedTimestamp";
    private String WORKITEM_NUMBER_TYPE = "workItemId";
    private String WORKITEM_UUID_TYPE = "workItemUUID";
    private String ROLLBACK_WORKITEM_NUMBER_TYPE = "rollbackWorkItemId";
    private String ROLLBACK_WORKITEM_UUID_TYPE = "rollbackWorkItemUUID";
    private String MISSING_ATTR = "missing";

    public GenerateRollbackManifest(String deltaDeployManifestPath, String rollbackManifestPath) throws Exception {
        super(deltaDeployManifestPath, rollbackManifestPath);
        DocumentBuilderFactory docBldrFactory = XMLUtil.getSecureDocumentBuilderFactory();
        docBldrFactory.setIgnoringElementContentWhitespace(true);
        docBldrFactory.setCoalescing(true);
        docBldrFactory.setIgnoringComments(true);
        try {
            NodeList deletedTmpNodes;
            NodeList updatedNodes;
            NodeList deletedNodes;
            DocumentBuilder docBldr = docBldrFactory.newDocumentBuilder();
            Document document = docBldr.parse(this.inputManifest);
            NodeList createdNodes = document.getElementsByTagName(this.CREATED_TAG);
            if (createdNodes.getLength() > 0) {
                Node createdNode = createdNodes.item(0);
                document.renameNode(createdNode, null, String.valueOf(this.DELETED_TAG) + this.TRANSIENT);
                int containerCount = 0;
                NodeList createdChildNodes = createdNode.getChildNodes();
                int i = 0;
                while (i < createdChildNodes.getLength()) {
                    Node container = createdChildNodes.item(i);
                    if (container.getNodeName().equals(this.CONTAINER_TAG)) {
                        ++containerCount;
                        int j = 0;
                        while (j < container.getAttributes().getLength()) {
                            NamedNodeMap attributes = container.getAttributes();
                            Node type = attributes.getNamedItem(this.CHANGE_TYPE);
                            if (type.getNodeValue().equals(this.ADD_TYPE)) {
                                type.setNodeValue(this.DELETE_TYPE);
                            }
                            ++j;
                        }
                        this.cleanUpAttributes(container, document);
                    }
                    ++i;
                }
                if (containerCount == 0) {
                    createdNode.getParentNode().removeChild(createdNode);
                }
            }
            if ((deletedNodes = document.getElementsByTagName(this.DELETED_TAG)).getLength() > 0) {
                Node deletedNode = deletedNodes.item(0);
                document.renameNode(deletedNode, null, this.CREATED_TAG);
                int containerCount = 0;
                NodeList deletedChildNodes = deletedNode.getChildNodes();
                int i = 0;
                while (i < deletedChildNodes.getLength()) {
                    Node container = deletedChildNodes.item(i);
                    if (container.getNodeName().equals(this.CONTAINER_TAG)) {
                        int j = 0;
                        while (j < container.getAttributes().getLength()) {
                            NamedNodeMap attributes = container.getAttributes();
                            Node type = attributes.getNamedItem(this.CHANGE_TYPE);
                            type.setNodeValue(this.ADD_TYPE);
                            ++j;
                        }
                        this.cleanUpAttributes(container, document);
                        int resourceCount = 0;
                        NodeList containerKids = container.getChildNodes();
                        int j2 = 0;
                        while (j2 < containerKids.getLength()) {
                            Node kid = containerKids.item(j2);
                            if (kid.getNodeName().equals(this.RESOURCE_TAG)) {
                                Node missing = kid.getAttributes().getNamedItem(this.MISSING_ATTR);
                                if (missing != null && Boolean.parseBoolean(missing.getNodeValue())) {
                                    container.removeChild(kid);
                                    --j2;
                                } else {
                                    ++resourceCount;
                                }
                            }
                            ++j2;
                        }
                        if (resourceCount == 0) {
                            deletedNode.removeChild(container);
                            --i;
                        } else {
                            ++containerCount;
                        }
                    }
                    ++i;
                }
                if (containerCount == 0) {
                    deletedNode.getParentNode().removeChild(deletedNode);
                }
            }
            if ((updatedNodes = document.getElementsByTagName(this.UPDATED_TAG)).getLength() > 0) {
                Node updatedNode = updatedNodes.item(0);
                int containerCount = 0;
                NodeList updatedChildNodes = updatedNode.getChildNodes();
                int i = 0;
                while (i < updatedChildNodes.getLength()) {
                    Node container = updatedChildNodes.item(i);
                    if (container.getNodeName().equals(this.CONTAINER_TAG)) {
                        ++containerCount;
                        this.cleanUpAttributes(container, document);
                    }
                    ++i;
                }
                if (containerCount == 0) {
                    updatedNode.getParentNode().removeChild(updatedNode);
                }
            }
            if ((deletedTmpNodes = document.getElementsByTagName(String.valueOf(this.DELETED_TAG) + this.TRANSIENT)).getLength() > 0) {
                document.renameNode(deletedTmpNodes.item(0), null, this.DELETED_TAG);
            }
            this.saveRollbackFile(document);
            this.convertToDefaultEncoding();
        }
        catch (ParserConfigurationException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (TransformerConfigurationException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    private void convertToDefaultEncoding() {
        try {
            File tempFile = new File(String.valueOf(this.outputManifest.getAbsolutePath()) + ".tmp");
            BufferedReader br = new BufferedReader(new FileReader(this.outputManifest));
            PrintWriter pw = new PrintWriter(new FileWriter(tempFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                pw.println(line);
                pw.flush();
            }
            pw.close();
            br.close();
            if (!this.outputManifest.delete()) {
                return;
            }
            tempFile.renameTo(this.outputManifest);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private void cleanUpAttributesOnResource(NamedNodeMap attributes, Document document) {
        Node workItemUUID;
        Node workItemNumber;
        Node lastModifiedTime;
        Node size = attributes.getNamedItem(this.SIZE_TYPE);
        if (size != null) {
            attributes.removeNamedItem(this.SIZE_TYPE);
        }
        if ((lastModifiedTime = attributes.getNamedItem(this.LAST_MODIFIED_TIME_TYPE)) != null) {
            attributes.removeNamedItem(this.LAST_MODIFIED_TIME_TYPE);
        }
        if ((workItemNumber = attributes.getNamedItem(this.WORKITEM_NUMBER_TYPE)) != null) {
            Attr attr = document.createAttribute(this.ROLLBACK_WORKITEM_NUMBER_TYPE);
            attr.setValue(workItemNumber.getNodeValue());
            attributes.removeNamedItem(this.WORKITEM_NUMBER_TYPE);
            attributes.setNamedItem(attr);
        }
        if ((workItemUUID = attributes.getNamedItem(this.WORKITEM_UUID_TYPE)) != null) {
            Attr attr = document.createAttribute(this.ROLLBACK_WORKITEM_UUID_TYPE);
            attr.setValue(workItemUUID.getNodeValue());
            attributes.removeNamedItem(this.WORKITEM_UUID_TYPE);
            attributes.setNamedItem(attr);
        }
    }

    private void cleanUpAttributes(Node container, Document document) {
        NodeList resources = container.getChildNodes();
        int i = 0;
        while (i < resources.getLength()) {
            Node resource = resources.item(i);
            if (resource.getNodeName().equals(this.RESOURCE_TAG)) {
                this.cleanUpAttributesOnResource(resource.getAttributes(), document);
            }
            ++i;
        }
    }
}

