/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit;

import com.ibm.team.enterprise.deployment.toolkit.Messages;
import java.io.File;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.eclipse.osgi.util.NLS;

public class DeploymentCleanupListener
implements BuildListener {
    public void buildStarted(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
        Project proj = event.getProject();
        String action = proj.getProperty("team.deploy.common.action");
        if (action != null && action.equals("deployMain") || action.equals("")) {
            String deployPackageDir = proj.getProperty("team.deploy.common.deployPackage.dir");
            try {
                File file = new File(deployPackageDir);
                if (file.exists()) {
                    proj.log(Messages.DeploymentCleanupListener_CLEANING_UP_DEPLOY_PACKAGE_DIR_INFO_MSG);
                    this.recursiveDelete(file);
                }
            }
            catch (Exception e) {
                proj.log(NLS.bind((String)Messages.DeploymentCleanupListener_FAILED_CLEANUP_PACKAGE_DIR, (Object)deployPackageDir), (Throwable)e, 1);
            }
            String restoreMappingFile = proj.getProperty("team.deploy.common.restoreMappingPath");
            try {
                File file = new File(restoreMappingFile);
                if (file.exists()) {
                    proj.log(Messages.DeploymentCleanupListener_CLEANING_UP_RESTORE_MAPPING_FILE_INFO_MSG);
                    file.delete();
                }
            }
            catch (Exception e) {
                proj.log(NLS.bind((String)Messages.DeploymentCleanupListener_FAILED_CLEAN_RESTORE_MAPPING_FILE, (Object)restoreMappingFile), (Throwable)e, 1);
            }
        }
    }

    protected void recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                this.recursiveDelete(childFile);
                ++n2;
            }
        }
        file.delete();
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }
}

