/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.osgi.util.NLS;

public class SetPackagingProperties
extends AbstractTeamBuildTask {
    private static final String VARIABLE_START = "${";
    private static final String VARIABLE_END = "}";
    private static final String PACKAGE_DEFINITION_UUID = "team.deploy.common.packagedefinitionUUID";
    private static final String PACKAGE_VERSION_PROPERTY = "team.package.common.version";
    private static final String PACKAGE_APP_DESC_PROPERTY = "team.package.common.applicationDescription";
    private static final String PACKAGE_APP_NAME_PROPERTY = "team.package.common.applicationName";
    private static final String PACKAGE_ZOS_SCRIPT = "team.package.zos.script";
    private static final String DEPLOY_VERSION_PROPERTY = "team.deploy.common.version";
    private static final String DEPLOY_APP_DESC_PROPERTY = "team.deploy.common.applicationDescription";
    private static final String DEPLOY_APP_NAME_PROPERTY = "team.deploy.common.applicationName";
    private static final String DEPLOY_ZOS_SCRIPT = "team.deploy.zos.script";
    private static final String DEPLOY_TEMPLATE_ID = "com.ibm.team.build.internal.template.id";
    private static final String DEPLOY_ZOS_PACKAGE = "com.ibm.team.enterprise.packaging.zos";
    private static final String DEPLOY_DEFINITION_VERSION_PROPERTY = "team.deploy.common.definition.version";
    private static final String DEPLOY_DEFINITION_VERSION_EXPECTED_VALUE = "3.0.1";

    protected void doExecute() throws Exception {
        Project proj = this.getProject();
        String versionCheckSet = proj.getProperty(DEPLOY_DEFINITION_VERSION_PROPERTY);
        if (versionCheckSet != null && versionCheckSet.compareTo(DEPLOY_DEFINITION_VERSION_EXPECTED_VALUE) >= 0) {
            proj.log(Messages.SetPackagingProperties_SETTING_PROPERTIES_LOG_MESSAGE);
            IBuildDefinition packageDef = this.getPackageDefinition(this.getTeamRepository());
            String prop = this.substitutePropertyVariables(packageDef.getProperty(PACKAGE_APP_NAME_PROPERTY).getValue(), proj);
            proj.setProperty(DEPLOY_APP_NAME_PROPERTY, prop);
            proj.log("team.deploy.common.applicationName = " + prop);
            prop = this.substitutePropertyVariables(packageDef.getProperty(PACKAGE_APP_DESC_PROPERTY).getValue(), proj);
            proj.setProperty(DEPLOY_APP_DESC_PROPERTY, prop);
            proj.log("team.deploy.common.applicationDescription = " + prop);
            prop = this.substitutePropertyVariables(packageDef.getProperty(PACKAGE_VERSION_PROPERTY).getValue(), proj);
            proj.setProperty(DEPLOY_VERSION_PROPERTY, prop);
            proj.log("team.deploy.common.version = " + prop);
            if (packageDef.getProperty(DEPLOY_TEMPLATE_ID).getValue().equals(DEPLOY_ZOS_PACKAGE)) {
                prop = this.substitutePropertyVariables(packageDef.getProperty(PACKAGE_ZOS_SCRIPT).getValue(), proj);
                proj.setProperty(DEPLOY_ZOS_SCRIPT, prop);
                proj.log("team.deploy.zos.script = " + prop);
            }
        }
    }

    private String substitutePropertyVariables(String property, Project proj) throws BuildException {
        String prop = property;
        while (prop.contains(VARIABLE_START)) {
            int startIndex = prop.indexOf(VARIABLE_START);
            if (startIndex == -1) continue;
            int endIndex = prop.indexOf(VARIABLE_END);
            if (endIndex != -1) {
                StringBuffer newPropertyValue = new StringBuffer();
                newPropertyValue.append(prop.substring(0, startIndex));
                newPropertyValue.append(proj.getProperty("env." + prop.substring(startIndex + 2, endIndex)));
                if (prop.length() > endIndex + 1) {
                    newPropertyValue.append(prop.substring(endIndex + 1));
                }
                prop = newPropertyValue.toString();
                continue;
            }
            throw new BuildException(NLS.bind((String)Messages.SetPackagingProperties_MISSING_BRACKET_DURING_PROPERTY_SUBSTITUTION_ERROR_MESSAGE, (Object)property));
        }
        return prop;
    }

    private IBuildDefinition getPackageDefinition(ITeamRepository teamRepository) throws TeamRepositoryException {
        UUID packageUUID = null;
        try {
            packageUUID = UUID.valueOf((String)this.getProject().getProperty(PACKAGE_DEFINITION_UUID));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        IItem item = null;
        IBuildDefinitionHandle packageDefHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(packageUUID, null);
        try {
            item = this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)packageDefHandle, 1, this.getProgressMonitor());
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        boolean cfr_ignored_0 = item instanceof IBuildDefinitionHandle;
        return (IBuildDefinition)item;
    }

    protected void collectAntAttributes(List arg0) {
    }
}

