/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.query.IBaseBuildEngineQueryModel;
import com.ibm.team.build.internal.client.ProxyHelper;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.enterprise.automation.internal.AutomationPasswordHelper;
import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class SetFTPPropertiesTask
extends Task {
    private ITeamRepository fTeamRepository = null;

    static {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        BuildItemFactory.initializeBuildPackage();
    }

    public void execute() throws BuildException {
        Project proj = this.getProject();
        String password = this.getProvidedPassword();
        proj.setProperty("team.deploy.common.load.ftp.calculated.password", password);
        proj.setProperty("team.deploy.common.load.ftp.calculated.userid", proj.getProperty("team.deploy.common.load.ftp.userid"));
        proj.setProperty("team.deploy.common.load.ftp.calculated.hostname", proj.getProperty("team.deploy.common.load.ftp.hostname"));
    }

    protected List<IBuildEngine> getBuildEngines(IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        IItemManager itemManager = this.getTeamRepository().itemManager();
        IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)IBaseBuildEngineQueryModel.IBuildEngineQueryModel.ROOT);
        ItemQueryIterator iter = new ItemQueryIterator(this.getBuildClient(), itemQuery, IQueryService.EMPTY_PARAMETERS);
        LinkedList<IBuildEngine> buildEngines = new LinkedList<IBuildEngine>();
        while (iter.hasNext(monitor)) {
            List engineHandles = iter.next(512, monitor);
            buildEngines.addAll(itemManager.fetchCompleteItems(engineHandles, 1, monitor));
        }
        Iterator enginesIter = buildEngines.iterator();
        while (enginesIter.hasNext()) {
            Object next = enginesIter.next();
            if (next != null) continue;
            enginesIter.remove();
        }
        return buildEngines;
    }

    private ITeamBuildClient getBuildClient() throws IOException, TeamRepositoryException {
        return ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository());
    }

    protected String getProvidedPassword() throws BuildException {
        File passwordFile = this.getPasswordFile();
        if (passwordFile != null) {
            try {
                return this.decryptPassword(passwordFile);
            }
            catch (Exception exception) {
                throw new BuildException(NLS.bind((String)Messages.SetFTPPropertiesTask_CANNOT_GET_PASSWORD_FROM_PWD_FILE_ERROR_MSG, (Object)passwordFile.getAbsolutePath()), (Throwable)exception);
            }
        }
        throw new BuildException(Messages.SetFTPPropertiesTask_PASSWORD_FILE_DOES_NOT_EXIST_ERROR_MSG);
    }

    private String decryptPassword(File passwordFile) throws GeneralSecurityException, IOException {
        return AutomationPasswordHelper.getPassword((File)passwordFile);
    }

    private String decryptPassword(String password) throws GeneralSecurityException, UnsupportedEncodingException {
        return AutomationPasswordHelper.getPassword((String)password);
    }

    private File getPasswordFile() throws BuildException {
        Project proj = this.getProject();
        String passwordFilePath = proj.getProperty("team.deploy.common.load.ftp.passwordFile");
        if (passwordFilePath == null || passwordFilePath.equals("") || passwordFilePath.startsWith("$")) {
            throw new BuildException(NLS.bind((String)Messages.SetFTPPropertiesTask_PASSWORD_FILE_PROPERTY_NOT_SET_ERROR_MSG, (Object)"team.deploy.common.load.ftp.passwordFile"));
        }
        File file = new File(passwordFilePath);
        if (file.exists()) {
            return file;
        }
        throw new BuildException(NLS.bind((String)Messages.SetFTPPropertiesTask_PASSWORD_FILE_DOES_NOT_EXIST_WITH_PATH_ERROR_MSG, (Object)passwordFilePath));
    }

    protected IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    public String getUserId() throws FileNotFoundException, IOException {
        return this.getProject().getProperty("env.JAZZ_USER");
    }

    protected ITeamRepository getTeamRepository() throws TeamRepositoryException, FileNotFoundException, IOException {
        if (this.fTeamRepository == null) {
            this.fTeamRepository = TeamPlatform.getTeamRepositoryService().getUnmanagedRepository(this.getRepositoryAddress());
            final String userId = this.getUserId();
            final String password = this.getTeamRepositoryPassword();
            this.fTeamRepository.registerLoginHandler(new ITeamRepository.ILoginHandler(){

                public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repo) {
                    return new ITeamRepository.ILoginHandler.ILoginInfo(){

                        public String getUserId() {
                            return userId;
                        }

                        public String getPassword() {
                            return password;
                        }
                    };
                }
            });
            String host = ProxyHelper.getProxyHost((String)this.getRepositoryAddress());
            if (host != null) {
                int port = ProxyHelper.getProxyPort((String)this.getRepositoryAddress());
                String proxyType = ProxyHelper.getProxyType((String)this.getRepositoryAddress());
                this.fTeamRepository.setProxy(host, proxyType, port, userId, password);
            }
        }
        if (!this.fTeamRepository.loggedIn()) {
            this.fTeamRepository.login(this.getProgressMonitor());
        }
        return this.fTeamRepository;
    }

    protected String getTeamRepositoryPassword() throws TeamRepositoryException, FileNotFoundException, IOException {
        File passwordFile = new File(this.getTeamRepositoryPasswordFile());
        try {
            return this.decryptPassword(passwordFile);
        }
        catch (Exception exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
    }

    public String getTeamRepositoryPasswordFile() throws FileNotFoundException, IOException {
        return this.getProject().getProperty("env.JAZZ_PASSWORD_FILE");
    }

    public String getRepositoryAddress() throws FileNotFoundException, IOException {
        return this.getProject().getProperty("env.repositoryAddress");
    }
}

