/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.automation.taskdefs.AbstractRequestBuildTask;
import com.ibm.team.enterprise.build.client.packaging.IPackageJFSClient;
import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import com.ibm.team.enterprise.packaging.common.jfs.IPackageHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public final class RequestDeploymentBuildTask
extends AbstractRequestBuildTask {
    public static final String TASK_NAME = "RequestDeploymentBuildTask";
    public static final String DEPLOY_PACKAGE_LABEL_ATTRIBUTE = "packageLabel";
    public static final String DEPLOY_PACKAGE_LABEL_PROPERTY = "team.deploy.common.packageLabel";
    public static final String DEPLOY_PACKAGE_RESULT_UUID_ATTRIBUTE = "packageResultUUID";
    public static final String DEPLOY_PACKAGE_RESULT_UUID_PROPERTY = "team.deploy.common.packageResultUUID";
    public static final String DEPLOY_REMOTE_PACKAGE_DIR_ATTRIBUTE = "remotePackageDir";
    public static final String DEPLOY_REMOTE_PACKAGE_DIR_PROPERTY = "team.deploy.common.remotePackage.dir";
    public static final String DEPLOY_ACTION_ATTRIBUTE = "deployAction";
    public static final String DEPLOY_ACTION_PROPERTY = "team.deploy.common.action";
    public static final String DEPLOY_ACTION_PROPERTYVALUE_LOAD_AND_DEPLOY = "";
    public static final String DEPLOY_ACTION_PROPERTYVALUE_LOAD = "loadMain";
    public static final String DEPLOY_ACTION_PROPERTYVALUE_DEPLOY = "deployMain";
    public static final String DEPLOY_ACTION_PROPERTYVALUE_ROLLBACK = "rollbackMain";
    static final String SLASH = "/";
    private String fPackageLabel = null;
    private UUID fPackageResultUuid = null;
    private String fPackageResultUuidString = null;
    private String fRemotePackageDir = null;
    private String fRemotePackageRootDir = null;
    private UUID fPackageDefinitionUuid = null;
    private String fDeployAction = null;
    private String fDeployActionProperty = null;

    protected void collectAntAttributes(List antAttributes) {
        super.collectAntAttributes(antAttributes);
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(DEPLOY_PACKAGE_LABEL_ATTRIBUTE, this.fPackageLabel, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(DEPLOY_PACKAGE_RESULT_UUID_ATTRIBUTE, this.fPackageResultUuidString, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(DEPLOY_REMOTE_PACKAGE_DIR_ATTRIBUTE, this.fRemotePackageDir, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(DEPLOY_ACTION_ATTRIBUTE, this.fDeployAction, false));
    }

    protected HashMap<String, String> getExtendedProperties() throws Exception {
        this.findRequiredPropertyValues();
        HashMap<String, String> antProperties = new HashMap<String, String>();
        antProperties.put(DEPLOY_PACKAGE_LABEL_PROPERTY, this.fPackageLabel);
        antProperties.put(DEPLOY_PACKAGE_RESULT_UUID_PROPERTY, this.fPackageResultUuid.getUuidValue());
        antProperties.put(DEPLOY_REMOTE_PACKAGE_DIR_PROPERTY, this.fRemotePackageDir);
        if (this.fDeployAction != null) {
            antProperties.put(DEPLOY_ACTION_PROPERTY, this.fDeployActionProperty);
        }
        return antProperties;
    }

    protected void findRequiredPropertyValues() throws Exception {
        this.setDeployActionProperty();
        this.findDeployDefinitionProperties();
        this.setPackageResult();
        this.setRemotePackageDirectory();
    }

    private void setPackageResult() throws Exception {
        if (this.fPackageResultUuidString == null && this.fPackageLabel == null) {
            throw new BuildException(NLS.bind((String)Messages.RequestDeploymentBuildTask_INVALID_DEPLOYMENT_PROPERTY, (Object)DEPLOY_PACKAGE_LABEL_ATTRIBUTE));
        }
        if (this.fPackageResultUuidString != null && this.fPackageLabel != null) {
            throw new BuildException(NLS.bind((String)Messages.RequestDeploymentBuildTask__CONFLICTING_TASK_ATTRIBUTES, (Object[])new Object[]{TASK_NAME, DEPLOY_PACKAGE_LABEL_ATTRIBUTE, DEPLOY_PACKAGE_RESULT_UUID_ATTRIBUTE}));
        }
        if (this.fPackageLabel != null) {
            this.fPackageResultUuid = this.findPackageResult();
            this.fPackageResultUuidString = this.fPackageResultUuid.getUuidValue();
        } else {
            this.fPackageLabel = this.findPackageLabel();
        }
    }

    private UUID findPackageResult() throws BuildException {
        try {
            IPackageJFSClient clientLibrary = (IPackageJFSClient)this.getTeamRepository().getClientLibrary(IPackageJFSClient.class);
            List packageHandles = clientLibrary.getAllPackageHandles(this.fPackageDefinitionUuid);
            for (IPackageHandle packageHandle : packageHandles) {
                if (!packageHandle.getLabel().equals(this.fPackageLabel)) continue;
                return packageHandle.getBuildResultUUID();
            }
        }
        catch (TeamRepositoryException e) {
            throw new BuildException(NLS.bind((String)Messages.RequestDeploymentBuildTask_INVALID_DEPLOYMENT_PROPERTY, (Object)DEPLOY_PACKAGE_LABEL_PROPERTY), (Throwable)e);
        }
        throw new BuildException(NLS.bind((String)Messages.RequestDeploymentBuildTask_INVALID_DEPLOYMENT_PROPERTY, (Object)DEPLOY_PACKAGE_LABEL_PROPERTY));
    }

    private String findPackageLabel() throws BuildException {
        try {
            IPackageJFSClient clientLibrary = (IPackageJFSClient)this.getTeamRepository().getClientLibrary(IPackageJFSClient.class);
            List packageHandles = clientLibrary.getAllPackageHandles(this.fPackageDefinitionUuid);
            for (IPackageHandle packageHandle : packageHandles) {
                if (!this.fPackageResultUuid.equals((Object)packageHandle.getBuildResultUUID())) continue;
                return packageHandle.getLabel();
            }
        }
        catch (TeamRepositoryException e) {
            throw new BuildException(NLS.bind((String)Messages.RequestDeploymentBuildTask_INVALID_DEPLOYMENT_PROPERTY, (Object)DEPLOY_PACKAGE_RESULT_UUID_PROPERTY));
        }
        throw new BuildException(NLS.bind((String)Messages.RequestDeploymentBuildTask_INVALID_DEPLOYMENT_PROPERTY, (Object)DEPLOY_PACKAGE_RESULT_UUID_PROPERTY));
    }

    private void setRemotePackageDirectory() throws Exception {
        if (this.fRemotePackageDir == null) {
            this.fRemotePackageDir = new String(String.valueOf(this.fRemotePackageRootDir) + SLASH + this.fPackageDefinitionUuid.getUuidValue() + SLASH + this.fPackageLabel);
        }
    }

    private void setDeployActionProperty() {
        if (this.fDeployAction == null) {
            this.fDeployActionProperty = DEPLOY_ACTION_PROPERTYVALUE_LOAD_AND_DEPLOY;
        } else if (this.fDeployAction.equalsIgnoreCase("load")) {
            this.fDeployActionProperty = DEPLOY_ACTION_PROPERTYVALUE_LOAD;
        } else if (this.fDeployAction.equalsIgnoreCase("deploy")) {
            this.fDeployActionProperty = DEPLOY_ACTION_PROPERTYVALUE_DEPLOY;
        } else if (this.fDeployAction.equalsIgnoreCase("rollback")) {
            this.fDeployActionProperty = DEPLOY_ACTION_PROPERTYVALUE_ROLLBACK;
        } else if (this.fDeployAction.equalsIgnoreCase("loadAndDeploy")) {
            this.fDeployActionProperty = DEPLOY_ACTION_PROPERTYVALUE_LOAD_AND_DEPLOY;
        } else {
            throw new BuildException(NLS.bind((String)Messages.RequestDeploymentBuildTask_INVALID_DEPLOYMENT_PROPERTY, (Object)DEPLOY_ACTION_ATTRIBUTE));
        }
    }

    public void setDeployAction(String deployAction) {
        this.fDeployAction = deployAction;
    }

    public String getDeployAction() {
        return this.fDeployAction;
    }

    public void setBuildDefinitionId(String buildDefinitionId) {
        super.setBuildDefinitionId(buildDefinitionId);
    }

    public String getPackageLabel() {
        return this.fPackageLabel;
    }

    public void setPackageLabel(String packageLabel) {
        this.fPackageLabel = packageLabel;
    }

    public String getPackageResultUUID() {
        return this.fPackageResultUuidString;
    }

    public void setPackageResultUUID(String packageResultUuidString) {
        this.fPackageResultUuidString = packageResultUuidString;
        this.fPackageResultUuid = UUID.valueOf((String)this.fPackageResultUuidString);
    }

    public String getRemotePackageDir() {
        return this.fRemotePackageDir;
    }

    public void setRemotePackageDir(String remotePackageDir) {
        this.fRemotePackageDir = remotePackageDir;
    }

    private void findDeployDefinitionProperties() throws Exception {
        List properties = this.getBuildDefinition(this.getBuildDefinitionId()).getProperties();
        for (IBuildProperty property : properties) {
            if (property.getName().equals("team.deploy.common.packagedefinitionUUID")) {
                this.fPackageDefinitionUuid = UUID.valueOf((String)property.getValue());
            } else if (property.getName().equals("team.deploy.common.remotePackageRoot.dir")) {
                this.fRemotePackageRootDir = property.getValue();
            }
            if (this.fPackageDefinitionUuid == null || this.fRemotePackageRootDir == null) continue;
            return;
        }
        if (this.fRemotePackageRootDir == null) {
            throw new BuildException(NLS.bind((String)Messages.RequestDeploymentBuildTask_INVALID_DEPLOYMENT_PROPERTY, (Object)"team.deploy.common.remotePackageRoot.dir"));
        }
        if (this.fPackageDefinitionUuid == null) {
            throw new BuildException(NLS.bind((String)Messages.RequestDeploymentBuildTask_INVALID_DEPLOYMENT_PROPERTY, (Object)"team.deploy.common.packagedefinitionUUID"));
        }
    }
}

