/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import com.ibm.team.enterprise.deployment.taskdefs.RecordDeployedObjectsTask;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import com.ibm.team.repository.client.ITeamRepository;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.IProgressMonitor;

public class RecordRolledBackObjectsTask
extends RecordDeployedObjectsTask {
    private String rollbackDir;
    private String lastUpdateDeployTimeStamp;
    private String lastDeployTimeStamp;

    @Override
    public void execute() throws BuildException {
        Project proj = this.getProject();
        proj.log(Messages.RecordRolledBackObjectsTask_RECORDING_ROLLED_BACK_OBJECTS_LOG_MSG);
        if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30(proj)) {
            try {
                File rollbackManifestFile = new File(String.valueOf(this.rollbackDir) + "rollbackManifest.xml");
                if (rollbackManifestFile.exists()) {
                    Manifest rollbackManifest = ManifestReader.getInstance().getManifest(rollbackManifestFile);
                    ArrayList<IBuildResultContribution> contributions = new ArrayList<IBuildResultContribution>();
                    IBuildResultContribution summaryContribution = BuildItemFactory.createBuildResultContribution();
                    IBuildEngine buildEngine = this.getBuildEngine();
                    String hostname = buildEngine.getConfigurationElement("com.ibm.rational.buildforge.buildagent").getConfigurationProperty("com.ibm.rational.buildforge.buildagent.hostname").getValue();
                    summaryContribution.setLabel(proj.getProperty("team.deploy.common.filesystem"));
                    summaryContribution.setExtendedContributionTypeId(AutomationResultContribution.ROLLBACK_OVERVIEW_EXTENDED_CONTRIBUTION_ID);
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME, proj.getProperty("team.deploy.common.applicationName"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION, proj.getProperty("team.deploy.common.version"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_DESCRIPTION, proj.getProperty("team.deploy.common.applicationDescription"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_HOST_NAME, hostname);
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_SUMMARY_WORKITEM, proj.getProperty("team.enterprise.deployment.summaryWorkItemId"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_SUMMARY_WORKITEM_UUID, proj.getProperty("team.enterprise.deployment.summaryWorkItemUUID"));
                    if (Boolean.parseBoolean(proj.getProperty("team.deploy.common.rollback.multipleAllowed"))) {
                        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_MULTI_ROLLBACK, "true");
                    }
                    if (!this.getProject().getProperty("com.ibm.team.build.internal.template.id").contains("nonseq")) {
                        if (this.lastUpdateDeployTimeStamp != null && !this.lastUpdateDeployTimeStamp.isEmpty()) {
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_DIR, String.valueOf(this.localPackageDir) + "/C" + this.lastDeployTimeStamp + "/U" + this.lastUpdateDeployTimeStamp);
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, this.lastUpdateDeployTimeStamp);
                        } else {
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_DIR, String.valueOf(this.localPackageDir) + "/C" + this.lastDeployTimeStamp);
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, this.lastDeployTimeStamp);
                        }
                    }
                    contributions.add(summaryContribution);
                    String runtimeRoot = this.resolveRuntimeRoot();
                    this.recordContainers(rollbackManifest.getCreatedContainers(), contributions, null, runtimeRoot, "Created");
                    this.recordContainers(rollbackManifest.getUpdatedContainers(), contributions, null, runtimeRoot, "Updated");
                    this.recordContainers(rollbackManifest.getDeletedContainers(), contributions, null, runtimeRoot, "Deleted");
                    IBuildResult buildResult = this.getBuildResult();
                    ITeamRepository teamRepository = this.getTeamRepository();
                    IProgressMonitor progressMonitor = this.getProgressMonitor();
                    ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).addBuildResultContributions((IBuildResultHandle)buildResult, contributions.toArray(new IBuildResultContribution[contributions.size()]), progressMonitor);
                }
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setDeployStatusFile(String deployStatusFile) {
        File deployStatusPropertiesFile = new File(deployStatusFile);
        if (deployStatusPropertiesFile.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(deployStatusPropertiesFile);
                Properties deployProperties = new Properties();
                deployProperties.load(inputStream);
                this.lastUpdateDeployTimeStamp = deployProperties.getProperty("team.deploy.common.lastUpdateDeployTimeStamp");
                this.lastDeployTimeStamp = deployProperties.getProperty("team.deploy.common.lastDeployTimeStamp");
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setRollbackDir(String rollbackDir) {
        this.rollbackDir = rollbackDir;
    }
}

