/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.enterprise.automation.taskdefs.AbstractAutomationPublisherTask;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import com.ibm.team.repository.client.ITeamRepository;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class RecordLoadedPackageTask
extends AbstractAutomationPublisherTask {
    private String localPackageDir;
    final String SLASH = "/";
    final String BUILDFORGE_BUILD_AGENT_ELEMENT = "com.ibm.rational.buildforge.buildagent";
    final String BUILDFORGE_BUILD_AGENT_HOSTNAME = "com.ibm.rational.buildforge.buildagent.hostname";

    public void execute() throws BuildException {
        Project proj = this.getProject();
        if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30(proj)) {
            try {
                IBuildResultContribution summaryContribution = BuildItemFactory.createBuildResultContribution();
                IBuildEngine buildEngine = this.getBuildEngine();
                String hostname = buildEngine.getConfigurationElement("com.ibm.rational.buildforge.buildagent").getConfigurationProperty("com.ibm.rational.buildforge.buildagent.hostname").getValue();
                summaryContribution.setLabel(proj.getProperty("team.deploy.common.filesystem"));
                summaryContribution.setExtendedContributionTypeId(AutomationResultContribution.LOAD_OVERVIEW_EXTENDED_CONTRIBUTION_ID);
                summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_HOST_NAME, hostname);
                summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_DIR, this.localPackageDir);
                summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_SUMMARY_WORKITEM, proj.getProperty("team.enterprise.deployment.summaryWorkItemId"));
                summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_SUMMARY_WORKITEM_UUID, proj.getProperty("team.enterprise.deployment.summaryWorkItemUUID"));
                String templateId = proj.getProperty("com.ibm.team.build.internal.template.id");
                if (templateId.contains("nonseq")) {
                    String timestamp = this.localPackageDir.substring(this.localPackageDir.lastIndexOf(File.separator) + 1);
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, timestamp);
                } else {
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME, proj.getProperty("team.deploy.common.applicationName"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION, proj.getProperty("team.deploy.common.version"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_DESCRIPTION, proj.getProperty("team.deploy.common.applicationDescription"));
                    String timestamp = this.localPackageDir.substring(this.localPackageDir.lastIndexOf(File.separator) + 2);
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, timestamp);
                }
                ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository()).addBuildResultContribution((IBuildResultHandle)this.getBuildResult(), summaryContribution, this.getProgressMonitor());
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void setLocalPackageDir(String dir) {
        this.localPackageDir = dir;
    }
}

