/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.automation.taskdefs.AbstractAutomationPublisherTask;
import com.ibm.team.enterprise.automation.taskdefs.WorkItemAutomationPublisherTask;
import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import com.ibm.team.repository.client.ITeamRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.IProgressMonitor;

public class RecordDeployedObjectsTask
extends AbstractAutomationPublisherTask {
    protected String localPackageDir;
    protected final String BUILDFORGE_BUILD_AGENT_ELEMENT = "com.ibm.rational.buildforge.buildagent";
    protected final String BUILDFORGE_BUILD_AGENT_HOSTNAME = "com.ibm.rational.buildforge.buildagent.hostname";

    public void execute() throws BuildException {
        Project proj = this.getProject();
        proj.log(Messages.RecordDeployedObjectsTask_RECORD_DEPLOYED_OBJECTS_LOG_MSG);
        if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30(proj)) {
            try {
                File deltaDeployedManifestFile = new File(String.valueOf(this.localPackageDir) + File.separator + "deltaDeployed.xml");
                if (deltaDeployedManifestFile.exists()) {
                    Manifest deltaDeployedManifest = ManifestReader.getInstance().getManifest(deltaDeployedManifestFile);
                    HashSet<String> workItemUUIDs = new HashSet<String>();
                    ArrayList<IBuildResultContribution> contributions = new ArrayList<IBuildResultContribution>();
                    IBuildResultContribution summaryContribution = BuildItemFactory.createBuildResultContribution();
                    IBuildEngine buildEngine = this.getBuildEngine();
                    String hostname = buildEngine.getConfigurationElement("com.ibm.rational.buildforge.buildagent").getConfigurationProperty("com.ibm.rational.buildforge.buildagent.hostname").getValue();
                    summaryContribution.setLabel(proj.getProperty("team.deploy.common.filesystem"));
                    summaryContribution.setExtendedContributionTypeId(AutomationResultContribution.DEPLOYMENT_OVERVIEW_EXTENDED_CONTRIBUTION_ID);
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME, proj.getProperty("team.deploy.common.applicationName"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION, proj.getProperty("team.deploy.common.version"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_DESCRIPTION, proj.getProperty("team.deploy.common.applicationDescription"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_HOST_NAME, hostname);
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_DIR, this.localPackageDir);
                    if (Boolean.parseBoolean(proj.getProperty("team.deploy.common.isCompletePackage"))) {
                        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, proj.getProperty("team.deploy.common.newDeployTimeStamp"));
                    } else {
                        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, proj.getProperty("team.deploy.common.newUpdateDeployTimeStamp"));
                    }
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_SUMMARY_WORKITEM, proj.getProperty("team.enterprise.deployment.summaryWorkItemId"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_SUMMARY_WORKITEM_UUID, proj.getProperty("team.enterprise.deployment.summaryWorkItemUUID"));
                    contributions.add(summaryContribution);
                    String runtimeRoot = this.resolveRuntimeRoot();
                    this.recordContainers(deltaDeployedManifest.getCreatedContainers(), contributions, workItemUUIDs, runtimeRoot, "Created");
                    this.recordContainers(deltaDeployedManifest.getUpdatedContainers(), contributions, workItemUUIDs, runtimeRoot, "Updated");
                    this.recordContainers(deltaDeployedManifest.getDeletedContainers(), contributions, workItemUUIDs, runtimeRoot, "Deleted");
                    IBuildResult buildResult = this.getBuildResult();
                    ITeamRepository teamRepository = this.getTeamRepository();
                    IProgressMonitor progressMonitor = this.getProgressMonitor();
                    ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).addBuildResultContributions((IBuildResultHandle)buildResult, contributions.toArray(new IBuildResultContribution[contributions.size()]), progressMonitor);
                    WorkItemAutomationPublisherTask workItemAutomationPublisherTask = new WorkItemAutomationPublisherTask(workItemUUIDs.toArray(), Boolean.valueOf(true), buildResult, teamRepository);
                    workItemAutomationPublisherTask.execute();
                }
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected String resolveRuntimeRoot() throws IOException {
        String runtimeRoot = "";
        if (this.getProject().getProperty("team.deploy.common.filesystem").equals("luw")) {
            runtimeRoot = String.valueOf(this.getBuildRoot(this.getProject().getProperty("team.deploy.luw.runtimeRoot.dir"))) + File.separator;
        } else {
            String hfsOutputs;
            String propertyName = "team.enterprise.deployment.hfs.runtimeRoot.dir";
            if (Boolean.parseBoolean(this.getProject().getProperty("personalBuild"))) {
                propertyName = "team.enterprise.deployment.hfs.runtimeRoot.personal.dir";
            }
            if ((hfsOutputs = this.getBuildRoot(this.getProject().getProperty(propertyName))) != null && !hfsOutputs.isEmpty() && !(runtimeRoot = hfsOutputs).endsWith(File.separator)) {
                runtimeRoot = String.valueOf(runtimeRoot) + File.separator;
            }
        }
        return runtimeRoot;
    }

    protected void recordContainers(List<Container> containers, List<IBuildResultContribution> contributions, HashSet<String> workItemUUIDs, String runtimeRoot, String changeType) {
        boolean isDeleted = "Deleted".equals(changeType);
        for (Container container : containers) {
            if ("sequential".equals(container.getType())) {
                IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
                contribution.setExtendedContributionTypeId(AutomationResultContribution.DEPLOYED_OBJECT_EXTENDED_CONTRIBUTION_ID);
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER, container.getName());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM, container.getWorkItemId());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM_UUID, container.getWorkitemUUID());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_RESOURCE_TYPE, container.getType());
                boolean isMissing = isDeleted && Boolean.parseBoolean(container.getMissing());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CHANGE_TYPE, isMissing ? "Missing" : changeType);
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER_TYPE, container.getType());
                contributions.add(contribution);
                continue;
            }
            boolean isHFS = "directory".equalsIgnoreCase(container.getType());
            Iterator resourceIterator = container.getResourcesIterator();
            while (resourceIterator.hasNext()) {
                IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
                contribution.setExtendedContributionTypeId(AutomationResultContribution.DEPLOYED_OBJECT_EXTENDED_CONTRIBUTION_ID);
                Resource resource = (Resource)resourceIterator.next();
                String containerName = container.getName();
                if (isHFS && (containerName = ".".equals(containerName) ? runtimeRoot : String.valueOf(runtimeRoot) + containerName).endsWith(File.separator)) {
                    containerName = containerName.substring(0, containerName.length() - 1);
                }
                contribution.setLabel(resource.getName());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER, containerName);
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_LAST_MODIFIED, resource.getLastModifiedTimestamp());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM, resource.getWorkItemId());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM_UUID, resource.getWorkitemUUID());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTTYPE, resource.getIbmiType());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTSUBTYPE, resource.getIbmiAttrribute());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_RESOURCE_TYPE, resource.getType());
                boolean isMissing = isDeleted && Boolean.parseBoolean(resource.getMissing());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CHANGE_TYPE, isMissing ? "Missing" : changeType);
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER_TYPE, container.getType());
                if (workItemUUIDs != null && resource.getWorkitemUUID() != null) {
                    workItemUUIDs.add(resource.getWorkitemUUID());
                }
                contributions.add(contribution);
            }
        }
    }

    public void setLocalPackageDir(String localPackageDir) {
        this.localPackageDir = localPackageDir;
    }
}

