/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import com.ibm.team.enterprise.deployment.toolkit.manifest.GenerateRollbackManifest;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class GenerateRollbackManifestTask
extends Task {
    protected String baseDir;

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void execute() throws BuildException {
        Project proj = this.getProject();
        if (this.isDefinitionVersionGreaterThan30(proj)) {
            File deltaFile;
            String deltaDeployPath = proj.getProperty("deltaDeploy");
            String rollbackPath = proj.getProperty("rollback");
            if (!(deltaDeployPath != null && deltaDeployPath.length() != 0 || (deltaFile = new File(deltaDeployPath = String.valueOf(proj.getProperty("team.deploy.common.deployPackage.dir")) + File.separator + "deltaDeployed.xml")).exists())) {
                proj.log(Messages.GenerateRollbackManifestTask_DELTA_DEPLOY_MANIFEST_NOT_FOUND_ERROR_MSG);
                return;
            }
            if (rollbackPath == null || rollbackPath.length() == 0) {
                rollbackPath = proj.getProperty("com.ibm.team.build.internal.template.id").contains("nonseq") ? (this.isMultipleRollback(proj) ? String.valueOf(proj.getProperty("saveRollbackDir")) + File.separator + "rollbackManifest.xml" : String.valueOf(proj.getProperty("team.deploy.common.localPackageRoot.dir")) + File.separator + proj.getProperty("team.deploy.common.packagedefinitionUUID") + File.separator + "rollbackArchive" + File.separator + "rollbackManifest.xml") : String.valueOf(proj.getProperty("team.deploy.common.localPackageRoot.dir")) + File.separator + proj.getProperty("team.deploy.common.applicationName") + File.separator + proj.getProperty("team.deploy.common.version") + File.separator + "rollbackArchive" + File.separator + "rollbackManifest.xml";
            }
            try {
                proj.log(Messages.GenerateRollbackManifestTask_GENERATING_ROLLBACK_MANIFEST_LOG_MSG);
                new GenerateRollbackManifest(deltaDeployPath, rollbackPath);
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isMultipleRollback(Project project) {
        String isMultipleRollbackString = project.getProperty("team.deploy.common.rollback.multipleAllowed");
        if (isMultipleRollbackString == null) {
            return false;
        }
        return isMultipleRollbackString.equals("true");
    }

    private boolean isDefinitionVersionGreaterThan30(Project project) {
        if (project.getProperty("team.deploy.common.definition.version") != null) {
            return project.getProperty("team.deploy.common.definition.version").compareTo("3.0.0") > 0;
        }
        return false;
    }
}

