/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class GenerateDeployStatusTask
extends Task {
    private String deployStatusFile;
    private String statusLocation;

    public void execute() throws BuildException {
        File statusLocationDir;
        Project proj = this.getProject();
        if (this.statusLocation == null) {
            this.statusLocation = proj.getProperty("team.deploy.common.statusLocation");
        }
        if (this.deployStatusFile == null) {
            this.deployStatusFile = proj.getProperty("team.deploy.common.deployStatusFile");
        }
        if (!(statusLocationDir = new File(this.statusLocation)).exists()) {
            statusLocationDir.mkdirs();
        }
        try {
            String newDeployTimestamp;
            File statusFile = new File(this.deployStatusFile);
            if (!statusFile.exists()) {
                statusFile.createNewFile();
            }
            String timestamps = GenerateDeployStatusTask.getTimestamps(this.deployStatusFile);
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(statusFile)));
            String newUpdateDeployTimestamp = proj.getProperty("team.deploy.common.newUpdateDeployTimeStamp");
            if (newUpdateDeployTimestamp == null) {
                newUpdateDeployTimestamp = "";
            }
            if ((newDeployTimestamp = proj.getProperty("team.deploy.common.newDeployTimeStamp")) == null) {
                newDeployTimestamp = "";
            }
            writer.println("team.deploy.common.lastDeployTimeStamp=" + newDeployTimestamp);
            writer.println("team.deploy.common.lastUpdateDeployTimeStamp=" + newUpdateDeployTimestamp);
            if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30(proj)) {
                StringBuffer strbf = new StringBuffer();
                strbf.append("team.deploy.common.deployTimestamps");
                strbf.append("=");
                if (timestamps != null && timestamps.length() > 0) {
                    String newTimeStamp = proj.getProperty("team.deploy.common.newUpdateDeployTimeStamp");
                    if (newTimeStamp == null) {
                        newTimeStamp = proj.getProperty("team.deploy.common.newDeployTimeStamp");
                    }
                    if (newTimeStamp != null) {
                        strbf.append(newTimeStamp);
                        strbf.append(",");
                    }
                    strbf.append(timestamps);
                } else {
                    strbf.append(proj.getProperty("team.deploy.common.newDeployTimeStamp"));
                }
                writer.println(strbf.toString());
                String rollbackDeployStatusFileName = String.valueOf(proj.getProperty("team.deploy.common.rollback.dir")) + "/deployStatus.properties";
                File rollbackDeployStatusFile = new File(rollbackDeployStatusFileName);
                if (rollbackDeployStatusFile.exists()) {
                    Properties deployProperties = new Properties();
                    deployProperties.load(new FileInputStream(rollbackDeployStatusFileName));
                    String newTimeStamp = proj.getProperty("team.deploy.common.newUpdateDeployTimeStamp");
                    if (newTimeStamp == null) {
                        newTimeStamp = proj.getProperty("team.deploy.common.newDeployTimeStamp");
                    }
                    deployProperties.setProperty("team.deploy.common.lastRollbackTimeStamp", newTimeStamp);
                    deployProperties.store(new FileOutputStream(rollbackDeployStatusFileName), null);
                }
            }
            writer.flush();
            writer.close();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static String getTimestamps(String deployStatusFile) throws FileNotFoundException, IOException {
        String timeStamps = null;
        File statusFile = new File(deployStatusFile);
        if (statusFile.exists()) {
            try (BufferedReader in = null;){
                String line;
                in = new BufferedReader(new FileReader(statusFile));
                while ((line = in.readLine()) != null) {
                    String propertyName;
                    StringTokenizer tokens = new StringTokenizer(line = line.trim(), "=");
                    if (!tokens.hasMoreTokens() || !(propertyName = tokens.nextToken().trim()).equals("team.deploy.common.deployTimestamps")) continue;
                    timeStamps = tokens.nextToken().trim();
                    break;
                }
            }
        }
        return timeStamps;
    }

    public void setDeployStatusFile(String deployStatusFile) {
        this.deployStatusFile = deployStatusFile;
    }

    public String getDeployStatusFile() {
        return this.deployStatusFile;
    }

    public void setStatusLocation(String statusLocation) {
        this.statusLocation = statusLocation;
    }

    public String getStatusLocation() {
        return this.statusLocation;
    }
}

