/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.enterprise.automation.manifest.CumulativeManifestWriter;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class GenerateCumulativeManifestTask
extends Task {
    private String deltaDepolyXML;
    private String cumulativeDeployXML;
    private String rollbackManifestXML;
    private String isRollback = "false";

    public void execute() throws BuildException {
        File deltaFile;
        Project proj = this.getProject();
        if (this.cumulativeDeployXML == null) {
            this.cumulativeDeployXML = this.getProject().getProperty("com.ibm.team.build.internal.template.id").contains("nonseq") ? String.valueOf(proj.getProperty("team.deploy.common.localPackageRoot.dir")) + File.separator + proj.getProperty("team.deploy.common.packagedefinitionUUID") + File.separator + "cumulativeDeployed.xml" : String.valueOf(proj.getProperty("team.deploy.common.localPackageRoot.dir")) + File.separator + proj.getProperty("team.deploy.common.applicationName") + File.separator + proj.getProperty("team.deploy.common.version") + File.separator + "cumulativeDeployed.xml";
        }
        if (Boolean.parseBoolean(this.isRollback)) {
            if (this.rollbackManifestXML == null) {
                this.rollbackManifestXML = String.valueOf(proj.getProperty("team.deploy.common.rollback.dir")) + File.separator + "rollbackManifest.xml";
            }
            deltaFile = new File(this.rollbackManifestXML);
        } else {
            if (this.deltaDepolyXML == null) {
                this.deltaDepolyXML = String.valueOf(proj.getProperty("team.deploy.common.deployPackage.dir")) + File.separator + "deltaDeployed.xml";
            }
            deltaFile = new File(this.deltaDepolyXML);
        }
        if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30(proj)) {
            File manifest = new File(this.cumulativeDeployXML);
            try {
                ManifestReader mr = ManifestReader.getInstance();
                if (deltaFile.exists()) {
                    Manifest delta = mr.getManifest(deltaFile);
                    Manifest cumulative = mr.getManifest(manifest);
                    CumulativeManifestWriter.getInstance().write(manifest, delta, cumulative, Boolean.parseBoolean(this.isRollback));
                }
            }
            catch (Exception e) {
                throw new BuildException(Messages.GenerateCumulativeManifestTask_GENERATING_CUMULATIVE_DEPLOY_MANIFEST_ERROR_MSG, (Throwable)e);
            }
        }
    }

    public String getDeltaDepolyXML() {
        return this.deltaDepolyXML;
    }

    public void setDeltaDeployXML(String deltaDepolyXML) {
        this.deltaDepolyXML = deltaDepolyXML;
    }

    public String getCumulativeDeployXML() {
        return this.cumulativeDeployXML;
    }

    public void setCumulativeDeployXML(String cumulativeDeployXML) {
        this.cumulativeDeployXML = cumulativeDeployXML;
    }

    public String getRollbaclManifestXML() {
        return this.rollbackManifestXML;
    }

    public void setRollbaclManifestXML(String rollbaclManifestXML) {
        this.rollbackManifestXML = rollbaclManifestXML;
    }

    public String getIsRollback() {
        return this.isRollback;
    }

    public void setIsRollback(String isRollback) {
        this.isRollback = isRollback;
    }
}

