/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.enterprise.automation.internal.AutomationPasswordHelper;
import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class DetermineFTPPasswordTask
extends Task {
    public void execute() throws BuildException {
        Project proj = this.getProject();
        String password = this.getProvidedPassword();
        proj.setProperty("team.deploy.common.load.ftp.password", password);
    }

    protected String getProvidedPassword() throws BuildException {
        File passwordFile = this.getPasswordFile();
        if (passwordFile != null) {
            try {
                return this.decryptPassword(passwordFile);
            }
            catch (Exception exception) {
                throw new BuildException(NLS.bind((String)Messages.DetermineFTPPasswordTask_CANNOT_GET_PASSWORD_FROM_PASSWORD_FILE_ERROR_MSG, (Object)passwordFile.getAbsolutePath()), (Throwable)exception);
            }
        }
        throw new BuildException(Messages.DetermineFTPPasswordTask_PASSWORD_FILE_DOES_NOT_EXIST_ERROR_MSG);
    }

    private String decryptPassword(File passwordFile) throws GeneralSecurityException, IOException {
        return AutomationPasswordHelper.getPassword((File)passwordFile);
    }

    private File getPasswordFile() throws BuildException {
        Project proj = this.getProject();
        String passwordFilePath = proj.getProperty("team.deploy.common.load.ftp.passwordFile");
        if (passwordFilePath == null || passwordFilePath.equals("") || passwordFilePath.startsWith("$")) {
            throw new BuildException(NLS.bind((String)Messages.DetermineFTPPasswordTask_PASSWORD_FILE_PROPERTY_NOT_SET_ERROR_MSG, (Object)"team.deploy.common.load.ftp.passwordFile"));
        }
        File file = new File(passwordFilePath);
        if (file.exists()) {
            return file;
        }
        throw new BuildException(NLS.bind((String)Messages.DetermineFTPPasswordTask_PASSWORD_FILE_DOES_NOT_EXIST_WITH_PATH_ERROR_MSG, (Object)passwordFilePath));
    }
}

