/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class ConvertContainerMappingTask
extends Task {
    public void execute() throws BuildException {
        boolean deleteContainerMapping = false;
        Project proj = this.getProject();
        String packageDir = proj.getProperty("team.deploy.common.deployPackage.dir");
        if (packageDir != null && packageDir.trim().length() > 0) {
            String restoreMappingPath = proj.getProperty("team.deploy.common.restoreMappingPath");
            if (restoreMappingPath == null || restoreMappingPath.trim().length() < 1) {
                if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30(proj)) {
                    restoreMappingPath = String.valueOf(packageDir) + File.separator + "containerMapper.xml";
                    deleteContainerMapping = true;
                } else {
                    restoreMappingPath = String.valueOf(packageDir) + File.separator + "map.mf";
                }
            }
            File originalRestoreMappingFile = new File(restoreMappingPath);
            try {
                if (originalRestoreMappingFile.exists()) {
                    if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30(proj)) {
                        File tempConvertedRestoreMappingFile = new File(String.valueOf(packageDir) + File.separator + "Temp_containerMapper.xml");
                        BufferedReader reader = new BufferedReader(new FileReader(originalRestoreMappingFile));
                        OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(tempConvertedRestoreMappingFile), "IBM-1047");
                        BufferedWriter writer = new BufferedWriter(osWriter);
                        String line = reader.readLine();
                        while (line != null) {
                            writer.write(line);
                            writer.newLine();
                            line = reader.readLine();
                        }
                        writer.close();
                        reader.close();
                        if (deleteContainerMapping) {
                            originalRestoreMappingFile.delete();
                        }
                        File convertedRestoreMappingFile = new File(String.valueOf(packageDir) + File.separator + "containerMapper.xml");
                        tempConvertedRestoreMappingFile.renameTo(convertedRestoreMappingFile);
                        proj.setProperty("team.deploy.restoreMappingPath", String.valueOf(packageDir) + File.separator + "containerMapper.xml");
                    }
                    proj.setProperty("team.deploy.restoreMappingPath", originalRestoreMappingFile.getAbsolutePath());
                }
                proj.setProperty("team.deploy.restoreMappingPath", "");
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        } else {
            proj.setProperty("team.deploy.restoreMappingPath", "");
        }
    }
}

