/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class CleanupRollbackDirectoriesTask
extends Task {
    public static final int ROLLBACK_LIMIT_THRESHOLD = 50;
    protected String baseDir;

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void execute() throws BuildException {
        Project proj = this.getProject();
        if (this.isDefinitionVersionGreaterThan30(proj)) {
            String isMultipleRollbackString = proj.getProperty("team.deploy.common.rollback.multipleAllowed");
            if (isMultipleRollbackString == null) {
                return;
            }
            if (!isMultipleRollbackString.equals("true")) {
                return;
            }
            String maximumRollbackString = proj.getProperty("team.deploy.common.rollback.maximumKeep");
            if (maximumRollbackString != null) {
                int maximumRollbacks = Integer.valueOf(maximumRollbackString);
                String rollbackRootDirString = proj.getProperty("team.deploy.common.rollback.dir");
                File rollbackRootDir = new File(rollbackRootDirString);
                File[] directoryListing = rollbackRootDir.listFiles();
                ArrayList<File> rollbackDirs = new ArrayList<File>(directoryListing.length);
                File[] fileArray = directoryListing;
                int n = directoryListing.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        rollbackDirs.add(f);
                    }
                    ++n2;
                }
                if (maximumRollbacks == 0) {
                    if (rollbackDirs.size() > 50) {
                        proj.log(NLS.bind((String)Messages.CleanupRollbackArchivesTask_ROLLBACK_WARNING_MANY_ARCHIVES, (Object[])new Object[]{rollbackDirs.size(), rollbackRootDirString}), 1);
                    }
                    return;
                }
                if (rollbackDirs.size() > Integer.valueOf(maximumRollbacks)) {
                    Collections.sort(rollbackDirs, new Comparator<File>(){

                        @Override
                        public int compare(File f1, File f2) {
                            return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                        }
                    });
                    int i = 0;
                    while (i < rollbackDirs.size() - maximumRollbacks) {
                        String rollbackDir = ((File)rollbackDirs.get(i)).getPath();
                        proj.log(NLS.bind((String)Messages.CleanupRollbackArchivesTask_ROLLBACK_ARCHIVE_DELETED, (Object)rollbackDir), 2);
                        this.recursiveDelete((File)rollbackDirs.get(i));
                        ++i;
                    }
                }
            }
        }
    }

    private boolean isDefinitionVersionGreaterThan30(Project project) {
        if (project.getProperty("team.deploy.common.definition.version") != null) {
            return project.getProperty("team.deploy.common.definition.version").compareTo("3.0.0") > 0;
        }
        return false;
    }

    protected void recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                this.recursiveDelete(childFile);
                ++n2;
            }
        }
        file.delete();
    }

    private void debugLogDirs(File[] dirs) {
        this.log("=====DEBUG: LOG ROLLBACK DIRS=========");
        int i = 0;
        while (i < dirs.length) {
            this.log("[" + i + "]: time:" + dirs[i].lastModified() + "path:" + dirs[i].getPath() + "|||");
            ++i;
        }
        this.log("=====DEBUG: END=========");
    }
}

