/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class CheckRollbackDirectoryTask
extends Task {
    protected String baseDir;

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void execute() throws BuildException {
        Project proj = this.getProject();
        if (this.isDefinitionVersionGreaterThan30(proj)) {
            String rollbackDirString = proj.getProperty("restoreRollbackDir");
            File rollbackDir = new File(rollbackDirString);
            if (rollbackDir.exists()) {
                return;
            }
            proj.log(NLS.bind((String)Messages.CheckRollbackDirectoryTask_ROLLBACK_DOES_NOT_EXIST, (Object)rollbackDirString), 0);
            throw new BuildException(NLS.bind((String)Messages.CheckRollbackDirectoryTask_ROLLBACK_DOES_NOT_EXIST, (Object)rollbackDirString));
        }
    }

    private boolean isDefinitionVersionGreaterThan30(Project project) {
        if (project.getProperty("team.deploy.common.definition.version") != null) {
            return project.getProperty("team.deploy.common.definition.version").compareTo("3.0.0") > 0;
        }
        return false;
    }
}

