/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.enterprise.automation.parsers.ContainerMappingDocument;
import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class CheckDeploymentPropertiesTask
extends Task {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        String restoreMappingPath;
        Project proj = this.getProject();
        String isLoadMethodFTPString = proj.getProperty("isLoadMethodFTP");
        boolean isLoadMethodFTP = Boolean.parseBoolean(isLoadMethodFTPString);
        if (isLoadMethodFTP) {
            return;
        }
        String remotePackageRootDirPath = proj.getProperty("team.deploy.common.remotePackageRoot.dir");
        File remotePackageRootDir = new File(remotePackageRootDirPath);
        if (!remotePackageRootDir.exists()) throw new BuildException(NLS.bind((String)Messages.CheckDeploymentPropertiesTask_PACKAGE_ROOT_DIR_DOES_NOT_EXIST_ERROR_MSG, (Object)remotePackageRootDirPath));
        if (!remotePackageRootDir.isDirectory()) throw new BuildException(NLS.bind((String)Messages.CheckDeploymentPropertiesTask_REMOTE_PACKAGE_ROOT_IS_NOT_A_DIRECTORY_ERROR_MSG, (Object)remotePackageRootDirPath));
        if (!remotePackageRootDir.canRead()) {
            throw new BuildException(NLS.bind((String)Messages.CheckDeploymentPropertiesTask_DO_NOT_HAVE_READ_ACCESS_TO_REMOTE_PACKAGE_ROOT_DIRECTORY_ERROR_MSG, (Object)remotePackageRootDirPath));
        }
        String localPackageRootDirPath = proj.getProperty("team.deploy.common.localPackageRoot.dir");
        File localPackageRootDir = new File(localPackageRootDirPath);
        if (localPackageRootDir.exists()) {
            if (!localPackageRootDir.isDirectory()) throw new BuildException(NLS.bind((String)Messages.CheckDeploymentPropertiesTask_LOCAL_PACKAGE_ROOT_IS_NOT_A_DIRECTORY_ERROR_MSG, (Object)localPackageRootDirPath));
            if (!localPackageRootDir.canRead()) throw new BuildException(NLS.bind((String)Messages.CheckDeploymentPropertiesTask_NO_READ_ACCESS_TO_LOCAL_PACKAGE_ROOT_ERROR_MSG, (Object)localPackageRootDirPath));
            if (!localPackageRootDir.canWrite()) {
                throw new BuildException(NLS.bind((String)Messages.CheckDeploymentPropertiesTask_NO_WRITE_ACCESS_TO_LOCAL_PACKAGE_ROOT_ERROR_MSG, (Object)localPackageRootDirPath));
            }
        }
        if ((restoreMappingPath = proj.getProperty("team.deploy.common.restoreMappingPath")) == null || restoreMappingPath.trim().length() <= 0) return;
        File restoreMappingFile = new File(restoreMappingPath);
        if (!restoreMappingFile.exists()) throw new BuildException(NLS.bind((String)Messages.CheckDeploymentPropertiesTask_RESTORE_MAPPING_FILE_DOES_NOT_EXIST_ERROR_MSG, (Object)restoreMappingPath));
        if (!CheckDeploymentVersions.isDefinitionVersionGreaterThan30(proj)) return;
        ContainerMappingDocument parser = new ContainerMappingDocument();
        try {
            FileInputStream fileInput = new FileInputStream(restoreMappingFile);
            parser.validate((InputStream)fileInput);
            fileInput.close();
            return;
        }
        catch (Exception e) {
            throw new BuildException(NLS.bind((String)Messages.CheckDeploymentPropertiesTask_OVERRIDE_MAPPING_PATH_VALIDATION_ERROR_MSG, (Object)e.getMessage()), (Throwable)e);
        }
    }
}

