/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class CalculateLoadDirectoryTask
extends Task {
    public void execute() throws BuildException {
        String tempName;
        String remoteDirString;
        File remoteDir;
        Project proj = this.getProject();
        String remotePackageRootDirValue = proj.getProperty("team.deploy.common.remotePackageRoot.dir");
        String localPackageRootDirValue = proj.getProperty("team.deploy.common.localPackageRoot.dir");
        String applicationNameValue = proj.getProperty("team.deploy.common.applicationName");
        String versionValue = proj.getProperty("team.deploy.common.version");
        String isCompletePackageValue = proj.getProperty("team.deploy.common.isCompletePackage");
        remotePackageRootDirValue = this.addFileSeparatorIfNeeded(remotePackageRootDirValue);
        localPackageRootDirValue = this.addFileSeparatorIfNeeded(localPackageRootDirValue);
        long lastLoadPackageTimeStamp = -1L;
        String lastLoadPackageTimeStampString = proj.getProperty("team.deploy.common.lastLoadTimeStamp");
        if (lastLoadPackageTimeStampString != null && !lastLoadPackageTimeStampString.equals("") && !lastLoadPackageTimeStampString.startsWith("$")) {
            lastLoadPackageTimeStamp = Long.parseLong(lastLoadPackageTimeStampString);
        }
        long lastLoadUpdatePackageTimeStamp = -1L;
        String lastLoadUpdatePackageTimeStampString = proj.getProperty("team.deploy.common.lastUpdateLoadTimeStamp");
        if (lastLoadUpdatePackageTimeStampString != null && !lastLoadUpdatePackageTimeStampString.equals("") && !lastLoadUpdatePackageTimeStampString.startsWith("$")) {
            lastLoadUpdatePackageTimeStamp = Long.parseLong(lastLoadUpdatePackageTimeStampString);
        }
        if (!(remoteDir = new File(remoteDirString = new String(remotePackageRootDirValue))).exists()) {
            throw new BuildException(NLS.bind((String)Messages.CalculateLoadDirectoryTask_REMOTE_PACKAGE_ROOT_DIR_DOES_NOT_EXIST_ERROR_MSG, (Object)remoteDir));
        }
        remoteDir = new File(remoteDirString = String.valueOf(remoteDirString) + applicationNameValue);
        if (!remoteDir.exists()) {
            throw new BuildException(NLS.bind((String)Messages.CalculateLoadDirectoryTask_REMOTE_DIRECTORY_DOES_NOT_EXIST_ERROR_MSG, (Object)remoteDir, (Object)applicationNameValue));
        }
        remoteDir = new File(remoteDirString = String.valueOf(remoteDirString) + File.separator + versionValue);
        if (!remoteDir.exists()) {
            throw new BuildException(NLS.bind((String)Messages.CalculateLoadDirectoryTask_REMOTE_DIRECTORY_DOES_NOT_EXIST_FOR_VRESION_ERROR_MSG, (Object[])new Object[]{remoteDir, applicationNameValue, versionValue}));
        }
        File[] allFiles = remoteDir.listFiles();
        ArrayList<File> allDirs = new ArrayList<File>();
        File[] fileArray = allFiles;
        int n = allFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && file.getName().startsWith("C")) {
                allDirs.add(file);
            }
            ++n2;
        }
        if (allDirs.size() == 0) {
            throw new BuildException(NLS.bind((String)Messages.CalculateLoadDirectoryTask_NO_COMPLETE_PACKAGE_TO_LOAD_ERROR_MSG, (Object)remotePackageRootDirValue));
        }
        if (Boolean.parseBoolean(isCompletePackageValue)) {
            boolean isSomethingToLoad = false;
            for (File temp : allDirs) {
                tempName = temp.getName();
                String tempNameWithoutPrefix = tempName.substring(1);
                long timestamp = Long.parseLong(tempNameWithoutPrefix);
                if (timestamp <= lastLoadPackageTimeStamp) continue;
                String localPackageDirString = new String(String.valueOf(localPackageRootDirValue) + applicationNameValue + File.separator + versionValue + File.separator + tempName);
                File localPackageDir = new File(localPackageDirString);
                if (localPackageDir.exists()) break;
                boolean success = localPackageDir.mkdirs();
                if (success) {
                    proj.setProperty("team.deploy.common.remotePackage.dir", temp.getAbsolutePath());
                    proj.setProperty("team.deploy.common.localPackage.dir", localPackageDirString);
                    proj.setProperty("team.deploy.common.newLoadTimeStamp", tempNameWithoutPrefix);
                    isSomethingToLoad = true;
                    break;
                }
                throw new BuildException(NLS.bind((String)Messages.CalculateLoadDirectoryTask_LOCAL_PACKAGE_DIR_COULD_NOT_BE_CREATED_ERROR_MSG, (Object)localPackageDirString));
            }
            if (!isSomethingToLoad) {
                throw new BuildException(NLS.bind((String)Messages.CalculateLoadDirectoryTask_NO_COMPLETE_PACKAGE_TO_LOAD_NEWER_THAN_TIMESTAMP_ERROR_MSG, (Object)remotePackageRootDirValue, (Object)lastLoadPackageTimeStamp));
            }
        } else {
            boolean isCompletePackageFound = false;
            for (File temp : allDirs) {
                tempName = temp.getName();
                String tempNameWithoutPrefix = tempName.substring(1);
                long timestamp = Long.parseLong(tempNameWithoutPrefix);
                if (timestamp != lastLoadPackageTimeStamp) continue;
                isCompletePackageFound = true;
                File[] allUpdateFiles = temp.listFiles();
                ArrayList<File> allUpdateDirs = new ArrayList<File>();
                File[] fileArray2 = allUpdateFiles;
                int n3 = allUpdateFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray2[n4];
                    if (file.isDirectory() && file.getName().startsWith("U")) {
                        allUpdateDirs.add(file);
                    }
                    ++n4;
                }
                if (allUpdateDirs.size() == 0) {
                    throw new BuildException(NLS.bind((String)Messages.CalculateLoadDirectoryTask_NO_UPDATE_PACKAGE_TO_LOAD_ERROR_MSG, (Object)temp.getAbsolutePath()));
                }
                boolean isSomethingToLoad = false;
                for (File updateTemp : allUpdateDirs) {
                    boolean success;
                    String updateTempName = updateTemp.getName();
                    String updateTempNameWithoutPrefix = updateTempName.substring(1);
                    long updateTimestamp = Long.parseLong(updateTempNameWithoutPrefix);
                    if (updateTimestamp <= lastLoadUpdatePackageTimeStamp) continue;
                    String localPackageDirString = new String(String.valueOf(localPackageRootDirValue) + applicationNameValue + File.separator + versionValue + File.separator + tempName + File.separator + updateTempName);
                    File localPackageDir = new File(localPackageDirString);
                    if (localPackageDir.exists() || !(success = localPackageDir.mkdirs())) break;
                    proj.setProperty("team.deploy.common.remotePackage.dir", updateTemp.getAbsolutePath());
                    proj.setProperty("team.deploy.common.localPackage.dir", localPackageDirString);
                    proj.setProperty("team.deploy.common.newLoadTimeStamp", tempNameWithoutPrefix);
                    proj.setProperty("team.deploy.common.newUpdateLoadTimeStamp", updateTempNameWithoutPrefix);
                    isSomethingToLoad = true;
                    break;
                }
                if (isSomethingToLoad) break;
                throw new BuildException(NLS.bind((String)Messages.CalculateLoadDirectoryTask_NO_UPDATE_PACKAGE_TO_LOAD_NEWER_THAN_TIMESTAMP_ERROR_MSG, (Object)temp.getAbsolutePath(), (Object)lastLoadUpdatePackageTimeStamp));
            }
            if (!isCompletePackageFound) {
                throw new BuildException(NLS.bind((String)Messages.CalculateLoadDirectoryTask_NO_COMPLETE_PACKAGE_THAT_MATCHES_TIMESTAMP_OF_LAST_LOAD_ERROR_MSG, (Object)remotePackageRootDirValue, (Object)lastLoadPackageTimeStamp));
            }
        }
    }

    private String addFileSeparatorIfNeeded(String path) {
        if (!path.endsWith(File.separator)) {
            return path.concat(File.separator);
        }
        return path;
    }
}

