/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.net.FTP;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.osgi.util.NLS;

public class CalculateFTPLoadDirectoryTask
extends Task {
    private Project proj;
    private FTP ftp;

    public void execute() throws BuildException {
        this.proj = this.getProject();
        String remotePackageRootDirValue = this.proj.getProperty("team.deploy.common.remotePackageRoot.dir");
        String localPackageRootDirValue = this.proj.getProperty("team.deploy.common.localPackageRoot.dir");
        String applicationNameValue = this.proj.getProperty("team.deploy.common.applicationName");
        String versionValue = this.proj.getProperty("team.deploy.common.version");
        String isCompletePackageValue = this.proj.getProperty("team.deploy.common.isCompletePackage");
        remotePackageRootDirValue = this.addFileSeparatorIfNeeded(remotePackageRootDirValue);
        localPackageRootDirValue = this.addFileSeparatorIfNeeded(localPackageRootDirValue);
        long lastLoadPackageTimeStamp = -1L;
        String lastLoadPackageTimeStampString = this.proj.getProperty("team.deploy.common.lastLoadTimeStamp");
        if (lastLoadPackageTimeStampString != null && !lastLoadPackageTimeStampString.equals("") && !lastLoadPackageTimeStampString.startsWith("$")) {
            lastLoadPackageTimeStamp = Long.parseLong(lastLoadPackageTimeStampString);
        }
        long lastLoadUpdatePackageTimeStamp = -1L;
        String lastLoadUpdatePackageTimeStampString = this.proj.getProperty("team.deploy.common.lastUpdateLoadTimeStamp");
        if (lastLoadUpdatePackageTimeStampString != null && !lastLoadUpdatePackageTimeStampString.equals("") && !lastLoadUpdatePackageTimeStampString.startsWith("$")) {
            lastLoadUpdatePackageTimeStamp = Long.parseLong(lastLoadUpdatePackageTimeStampString);
        }
        String hostname = this.proj.getProperty("team.deploy.common.load.ftp.hostname");
        String portString = this.proj.getProperty("team.deploy.common.load.ftp.port");
        String userid = this.proj.getProperty("team.deploy.common.load.ftp.userid");
        String password = this.proj.getProperty("team.deploy.common.load.ftp.password");
        int port = 21;
        port = portString != null && !portString.equals("") && !portString.startsWith("$") ? Integer.parseInt(portString) : 21;
        String remoteDirString = new String(remotePackageRootDirValue);
        this.ftp = new FTP();
        this.ftp.setProject(this.proj);
        this.ftp.init();
        this.ftp.setServer(hostname);
        this.ftp.setPort(port);
        this.ftp.setUserid(userid);
        this.ftp.setPassword(password);
        this.exists(remoteDirString);
        remoteDirString = String.valueOf(remoteDirString) + applicationNameValue;
        this.exists(remoteDirString);
        remoteDirString = String.valueOf(remoteDirString) + File.separator + versionValue;
        List<String> allDirs = this.list(remoteDirString, "C");
        if (allDirs.size() == 0) {
            throw new BuildException(NLS.bind((String)Messages.CalculateFTPLoadDirectoryTask_NO_COMPLETE_PACKAGES_TO_LOAD_ERROR_MSG, (Object)remotePackageRootDirValue));
        }
        if (Boolean.parseBoolean(isCompletePackageValue)) {
            boolean isSomethingToLoad = false;
            for (String temp : allDirs) {
                String tempName = temp;
                String tempNameWithoutPrefix = tempName.substring(1);
                long timestamp = Long.parseLong(tempNameWithoutPrefix);
                if (timestamp <= lastLoadPackageTimeStamp) continue;
                String localPackageDirString = new String(String.valueOf(localPackageRootDirValue) + applicationNameValue + File.separator + versionValue + File.separator + tempName);
                File localPackageDir = new File(localPackageDirString);
                if (localPackageDir.exists()) break;
                boolean success = localPackageDir.mkdirs();
                if (success) {
                    this.proj.setProperty("team.deploy.common.remotePackage.dir", String.valueOf(remoteDirString) + File.separator + tempName);
                    this.proj.setProperty("team.deploy.common.localPackage.dir", localPackageDirString);
                    this.proj.setProperty("team.deploy.common.newLoadTimeStamp", tempNameWithoutPrefix);
                    isSomethingToLoad = true;
                    break;
                }
                throw new BuildException(NLS.bind((String)Messages.CalculateFTPLoadDirectoryTask_LOCAL_PACKAGE_DIRECTORY_COULD_NOT_BE_CREATED_ERROR_MSG, (Object)localPackageDirString));
            }
            if (!isSomethingToLoad) {
                throw new BuildException(NLS.bind((String)Messages.CalculateFTPLoadDirectoryTask_NO_COMPLETE_PACKAGE_TO_LOAD_NEWER_THAN_LAST_TIMESTAMP_ERROR_MSG, (Object)remotePackageRootDirValue, (Object)lastLoadPackageTimeStamp));
            }
        } else {
            boolean isCompletePackageFound = false;
            for (String temp : allDirs) {
                String tempName = temp;
                String tempNameWithoutPrefix = tempName.substring(1);
                long timestamp = Long.parseLong(tempNameWithoutPrefix);
                if (timestamp != lastLoadPackageTimeStamp) continue;
                isCompletePackageFound = true;
                String absoluteTempPath = String.valueOf(remoteDirString) + File.separator + tempName;
                List<String> allUpdateDirs = this.list(absoluteTempPath, "U");
                if (allUpdateDirs.size() == 0) {
                    throw new BuildException(NLS.bind((String)Messages.CalculateFTPLoadDirectoryTask_NO_UPDATE_PACKAGE_TO_LOAD_ERROR_MSG, (Object)absoluteTempPath));
                }
                boolean isSomethingToLoad = false;
                for (String updateTemp : allUpdateDirs) {
                    boolean success;
                    String updateTempName = updateTemp;
                    String updateTempNameWithoutPrefix = updateTempName.substring(1);
                    long updateTimestamp = Long.parseLong(updateTempNameWithoutPrefix);
                    if (updateTimestamp <= lastLoadUpdatePackageTimeStamp) continue;
                    String localPackageDirString = new String(String.valueOf(localPackageRootDirValue) + applicationNameValue + File.separator + versionValue + File.separator + tempName + File.separator + updateTempName);
                    File localPackageDir = new File(localPackageDirString);
                    if (localPackageDir.exists() || !(success = localPackageDir.mkdirs())) break;
                    this.proj.setProperty("team.deploy.common.remotePackage.dir", String.valueOf(this.addFileSeparatorIfNeeded(absoluteTempPath)) + updateTempName);
                    this.proj.setProperty("team.deploy.common.localPackage.dir", localPackageDirString);
                    this.proj.setProperty("team.deploy.common.newLoadTimeStamp", tempNameWithoutPrefix);
                    this.proj.setProperty("team.deploy.common.newUpdateLoadTimeStamp", updateTempNameWithoutPrefix);
                    isSomethingToLoad = true;
                    break;
                }
                if (isSomethingToLoad) break;
                throw new BuildException(NLS.bind((String)Messages.CalculateFTPLoadDirectoryTask_NO_UPDATE_PACKAGE_TO_LOAD_NEWER_THAN_LAST_TIMESTAMP_ERROR_MSG, (Object)temp, (Object)lastLoadUpdatePackageTimeStamp));
            }
            if (!isCompletePackageFound) {
                throw new BuildException(NLS.bind((String)Messages.CalculateFTPLoadDirectoryTask_COULD_NOT_FIND_LAST_COMPLETE_PACKAGE_LOADED_ERROR_MSG, (Object)remotePackageRootDirValue, (Object)lastLoadPackageTimeStamp));
            }
        }
    }

    private String addFileSeparatorIfNeeded(String path) {
        if (!path.endsWith(File.separator)) {
            return path.concat(File.separator);
        }
        return path;
    }

    private void exists(String dir) {
        FTP.Action action = new FTP.Action();
        action.setValue("list");
        this.ftp.setAction(action);
        File listingFile = new File(this.proj.getProperty("team.deploy.common.tempListingFile"));
        this.ftp.setListing(listingFile);
        this.ftp.setRemotedir(dir);
        FileSet fileSet = new FileSet();
        this.ftp.addFileset(fileSet);
        this.ftp.execute();
        if (listingFile.exists()) {
            listingFile.delete();
        }
    }

    private List<String> list(String dir, String prefix) {
        FTP.Action action = new FTP.Action();
        action.setValue("list");
        this.ftp.setAction(action);
        File listingFile = new File(this.proj.getProperty("team.deploy.common.tempListingFile"));
        this.ftp.setListing(listingFile);
        this.ftp.setRemotedir(dir);
        FileSet fileSet = new FileSet();
        this.ftp.addFileset(fileSet);
        this.ftp.execute();
        ArrayList<String> files = new ArrayList<String>();
        if (!listingFile.exists() || listingFile.length() == 0L) {
            return files;
        }
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(listingFile));
                StringTokenizer tokenizer = null;
                String line = reader.readLine();
                while (line != null) {
                    this.proj.log(NLS.bind((String)Messages.CalculateFTPLoadDirectoryTask_LINE_IN_LISTING_FILE_INFO_MSG, (Object)line), 3);
                    tokenizer = new StringTokenizer(line);
                    String token = null;
                    String dirName = null;
                    while (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                        this.proj.log(NLS.bind((String)Messages.CalculateFTPLoadDirectoryTask_TOKEN_FOUND_IN_LINE_INFO_MSG, (Object)token), 3);
                        if (!token.startsWith(prefix)) continue;
                        this.proj.log(NLS.bind((String)Messages.CalculateFTPLoadDirectoryTask_TOKEN_STARTS_WITH_INFO_MSG, (Object)token, (Object)prefix), 3);
                        int sepIndex = token.indexOf(File.separator);
                        if (sepIndex == -1) continue;
                        dirName = token.substring(0, sepIndex);
                        this.proj.log(NLS.bind((String)Messages.CalculateFTPLoadDirectoryTask_DIRECTORY_NAME_FOUND_INFO_MSG, (Object)dirName), 3);
                        files.add(dirName);
                    }
                    line = reader.readLine();
                }
                listingFile.delete();
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return files;
    }
}

