/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.taskdefs;

import com.ibm.team.enterprise.deployment.taskdefs.Messages;
import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class CalculateDeployDirectoryTask
extends Task {
    public void execute() throws BuildException {
        Project proj = this.getProject();
        String localPackageRootDirValue = proj.getProperty("team.deploy.common.localPackageRoot.dir");
        String applicationNameValue = proj.getProperty("team.deploy.common.applicationName");
        String versionValue = proj.getProperty("team.deploy.common.version");
        String isCompletePackageValue = proj.getProperty("team.deploy.common.isCompletePackage");
        localPackageRootDirValue = this.addFileSeparatorIfNeeded(localPackageRootDirValue);
        long lastDeployPackageTimeStamp = -1L;
        String lastDeployPackageTimeStampString = proj.getProperty("team.deploy.common.lastDeployTimeStamp");
        if (lastDeployPackageTimeStampString != null && !lastDeployPackageTimeStampString.equals("") && !lastDeployPackageTimeStampString.startsWith("$")) {
            lastDeployPackageTimeStamp = Long.parseLong(lastDeployPackageTimeStampString);
        }
        long lastDeployUpdatePackageTimeStamp = -1L;
        String lastDeployUpdatePackageTimeStampString = proj.getProperty("team.deploy.common.lastUpdateDeployTimeStamp");
        if (lastDeployUpdatePackageTimeStampString != null && !lastDeployUpdatePackageTimeStampString.equals("") && !lastDeployUpdatePackageTimeStampString.startsWith("$")) {
            lastDeployUpdatePackageTimeStamp = Long.parseLong(lastDeployUpdatePackageTimeStampString);
        }
        long lastRollbackTimestamp = 0L;
        String lastRollbackPackageTimeStampString = proj.getProperty("team.deploy.common.lastRollbackTimeStamp");
        if (lastRollbackPackageTimeStampString != null && !lastRollbackPackageTimeStampString.equals("") && !lastRollbackPackageTimeStampString.startsWith("$")) {
            lastRollbackTimestamp = Long.parseLong(lastRollbackPackageTimeStampString);
        }
        String localApplicationDirString = new String(String.valueOf(localPackageRootDirValue) + applicationNameValue + File.separator + versionValue);
        if (Boolean.parseBoolean(isCompletePackageValue)) {
            File appVersionDir = new File(localApplicationDirString);
            if (appVersionDir.exists()) {
                File[] allFiles = appVersionDir.listFiles();
                ArrayList<File> allDirs = new ArrayList<File>();
                File[] fileArray = allFiles;
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory() && file.getName().startsWith("C")) {
                        allDirs.add(file);
                    }
                    ++n2;
                }
                if (allDirs.size() == 0) {
                    throw new BuildException(NLS.bind((String)Messages.CalculateDeployDirectoryTask_NO_COMPLETE_PACKAGE_FOUND_ERROR_MSG, (Object)localApplicationDirString));
                }
                boolean isSomethingToDeploy = false;
                for (File temp : allDirs) {
                    String tempName = temp.getName();
                    String tempNameWithoutPrefix = tempName.substring(1);
                    long timestamp = Long.parseLong(tempNameWithoutPrefix);
                    if (timestamp <= lastDeployPackageTimeStamp || timestamp <= lastRollbackTimestamp) continue;
                    proj.setProperty("team.deploy.common.deployPackage.dir", temp.getAbsolutePath());
                    proj.setProperty("team.deploy.common.newDeployTimeStamp", tempNameWithoutPrefix);
                    isSomethingToDeploy = true;
                    break;
                }
                if (!isSomethingToDeploy) {
                    throw new BuildException(NLS.bind((String)Messages.CalculateDeployDirectoryTask_NO_COMPLETE_PACKAGE_FOUND_NEWER_THAN_TIMESTAMP_ERROR_MSG, (Object)localApplicationDirString, (Object)lastDeployPackageTimeStamp));
                }
            }
        } else {
            File appVersionDir = new File(localApplicationDirString);
            if (appVersionDir.exists()) {
                File[] allFiles = appVersionDir.listFiles();
                ArrayList<File> allDirs = new ArrayList<File>();
                Object tempName = allFiles;
                int n = allFiles.length;
                int temp = 0;
                while (temp < n) {
                    File file = tempName[temp];
                    if (file.isDirectory() && file.getName().startsWith("C")) {
                        allDirs.add(file);
                    }
                    ++temp;
                }
                if (allDirs.size() == 0) {
                    throw new BuildException(NLS.bind((String)Messages.CalculateDeployDirectoryTask_NO_COMPLETE_PACKAGE_IN_LOCAL_PACKAGE_ROOT_DIR_ERROR_MSG, (Object)localApplicationDirString));
                }
                boolean isCompletePackageFound = false;
                for (File temp2 : allDirs) {
                    tempName = temp2.getName();
                    String tempNameWithoutPrefix = ((String)tempName).substring(1);
                    long timestamp = Long.parseLong(tempNameWithoutPrefix);
                    if (timestamp != lastDeployPackageTimeStamp) continue;
                    isCompletePackageFound = true;
                    File[] allUpdateFiles = temp2.listFiles();
                    ArrayList<File> allUpdateDirs = new ArrayList<File>();
                    File[] fileArray = allUpdateFiles;
                    int n3 = allUpdateFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File file = fileArray[n4];
                        if (file.isDirectory() && file.getName().startsWith("U")) {
                            allUpdateDirs.add(file);
                        }
                        ++n4;
                    }
                    if (allUpdateDirs.size() == 0) {
                        throw new BuildException(NLS.bind((String)Messages.CalculateDeployDirectoryTask_NO_UPDATE_PACKAGE_FOUND_IN_COMPLETE_PACKAGE_ROOT_DIR_ERROR_MSG, (Object)temp2.getAbsolutePath()));
                    }
                    boolean isSomethingToLoad = false;
                    for (File updateTemp : allUpdateDirs) {
                        String updateTempName = updateTemp.getName();
                        String updateTempNameWithoutPrefix = updateTempName.substring(1);
                        long updateTimestamp = Long.parseLong(updateTempNameWithoutPrefix);
                        if (updateTimestamp <= lastDeployUpdatePackageTimeStamp || updateTimestamp <= lastRollbackTimestamp) continue;
                        proj.setProperty("team.deploy.common.deployPackage.dir", updateTemp.getAbsolutePath());
                        proj.setProperty("team.deploy.common.newDeployTimeStamp", tempNameWithoutPrefix);
                        proj.setProperty("team.deploy.common.newUpdateDeployTimeStamp", updateTempNameWithoutPrefix);
                        isSomethingToLoad = true;
                        break;
                    }
                    if (isSomethingToLoad) break;
                    throw new BuildException(NLS.bind((String)Messages.CalculateDeployDirectoryTask_NO_UPDATE_PACKAGE_TO_DEPLOY_NEWER_THAN_TIMESTAMP_ERROR_MSG, (Object)temp2.getAbsolutePath(), (Object)lastDeployUpdatePackageTimeStamp));
                }
                if (!isCompletePackageFound) {
                    throw new BuildException(NLS.bind((String)Messages.CalculateDeployDirectoryTask_NO_COMPLETE_PACKAGE_MATCHING_PREVIOUS_DEPLOY_COMPLETE_TIMESTAMP_ERROR_MSG, (Object)localApplicationDirString, (Object)lastDeployPackageTimeStamp));
                }
            }
        }
    }

    private String addFileSeparatorIfNeeded(String path) {
        if (!path.endsWith(File.separator)) {
            return path.concat(File.separator);
        }
        return path;
    }
}

