/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.hfs;

import com.ibm.team.enterprise.automation.hfs.HFSUtil;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.deployment.hfs.BackUpHFSFilesTask;
import com.ibm.team.enterprise.deployment.hfs.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.eclipse.osgi.util.NLS;

public class DeployHFSFilesTask
extends Task {
    private File manifestFile;
    private File outputDir;
    private String targetDir;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        if (this.manifestFile == null || !this.manifestFile.exists()) throw new BuildException(NLS.bind((String)Messages.BackUpHFSFilesTask_PACKAGE_MANIFEST_NOT_FOUND_ERROR_MSG, (Object)(this.manifestFile == null ? "" : this.manifestFile.getAbsolutePath())));
        try {
            Manifest packageManifest = ManifestReader.getInstance().getManifest(this.manifestFile);
            List createOrUpdateContainers = HFSUtil.getHFSContainers((List)packageManifest.getContainers());
            createOrUpdateContainers.addAll(HFSUtil.getHFSContainers((List)packageManifest.getCreatedContainers()));
            createOrUpdateContainers.addAll(HFSUtil.getHFSContainers((List)packageManifest.getUpdatedContainers()));
            List deletedContainers = HFSUtil.getHFSContainers((List)packageManifest.getDeletedContainers());
            if (createOrUpdateContainers.size() == 0 && deletedContainers.size() == 0) {
                this.getProject().log(Messages.DeployHFSFilesTask_NOTHING_TO_DEPLOY_INFO_MSG, 2);
                return;
            } else {
                File targetOutputsDir = BackUpHFSFilesTask.resolveTargetOutputsDir(this.getProject(), this.getTargetDir());
                if (deletedContainers.size() > 0) {
                    this.deleteFiles(deletedContainers, targetOutputsDir, packageManifest);
                }
                if (createOrUpdateContainers.size() <= 0) return;
                File sourceDir = new File(this.outputDir, "HFS");
                for (Container container : createOrUpdateContainers) {
                    this.copyFiles(container, sourceDir, targetOutputsDir);
                }
            }
            return;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void copyFiles(Container container, File sourceDir, File targetDir) {
        Iterator resources = container.getResourcesIterator();
        while (resources.hasNext()) {
            Resource resource = (Resource)resources.next();
            String relativePath = String.valueOf(container.getName()) + File.separator + resource.getName();
            File sourceFile = new File(sourceDir, relativePath);
            if (sourceFile.exists()) {
                File targetFile = new File(targetDir, relativePath);
                HFSUtil.move((File)sourceFile, (File)targetFile, (Project)this.getProject());
                continue;
            }
            throw new BuildException(NLS.bind((String)Messages.DeployHFSFilesTask_FILE_NOT_FOUND, (Object)sourceFile.getAbsolutePath()));
        }
    }

    private void deleteFiles(List<Container> containers, File targetOutputsDir, Manifest packageManifest) throws IOException {
        File includesFile = new File(String.valueOf(this.manifestFile.getParent()) + File.separator + "deletionManifest.asHFSFileSet");
        PrintWriter includesFileOutput = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(includesFile), "UTF-8")));
        String targetOutputsDirPath = targetOutputsDir.getCanonicalPath();
        if (BackUpHFSFilesTask.processFilesToDelete(containers, targetOutputsDirPath, includesFileOutput, null, packageManifest, this.getProject())) {
            includesFileOutput.flush();
            includesFileOutput.close();
            Delete delete = (Delete)this.getProject().createTask("delete");
            delete.setDir(targetOutputsDir);
            delete.setIncludesfile(includesFile);
            delete.setFailOnError(true);
            delete.execute();
        }
    }

    public void setManifest(File manifest) {
        this.manifestFile = manifest;
    }

    public void setOutputDir(File dir) {
        this.outputDir = dir;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }
}

