/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.hfs;

import com.ibm.team.enterprise.automation.hfs.HFSUtil;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.deployment.hfs.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.osgi.util.NLS;

public class BackUpHFSFilesTask
extends Task {
    private File manifestFile;
    private File outputDir;
    private String outputFile;
    private String rootDir;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        if (this.manifestFile == null || !this.manifestFile.exists()) throw new BuildException(NLS.bind((String)Messages.BackUpHFSFilesTask_PACKAGE_MANIFEST_NOT_FOUND_ERROR_MSG, (Object)(this.manifestFile == null ? "" : this.manifestFile.getAbsolutePath())));
        try {
            Manifest deltaManifest;
            Manifest packageManifest = ManifestReader.getInstance().getManifest(this.manifestFile);
            String manifestDir = this.manifestFile.getParent();
            boolean shouldSerializeManifest = false;
            File deltaManifestFile = new File(String.valueOf(manifestDir) + File.separator + "deltaDeployed.xml");
            if (deltaManifestFile.exists()) {
                deltaManifest = ManifestReader.getInstance().getManifest(deltaManifestFile);
            } else {
                deltaManifest = new Manifest();
                deltaManifest.setType("MANIFEST_REPORT");
                shouldSerializeManifest = true;
            }
            List createOrUpdateContainers = HFSUtil.getHFSContainers((List)packageManifest.getContainers());
            List deletedContainers = HFSUtil.getHFSContainers((List)packageManifest.getDeletedContainers());
            if (createOrUpdateContainers.size() == 0 && deletedContainers.size() == 0) {
                this.getProject().log(Messages.BackUpHFSFilesTask_NOTHING_TO_BACK_UP_INFO_MSG, 2);
            } else {
                shouldSerializeManifest = true;
                File targetOutputsDir = BackUpHFSFilesTask.resolveTargetOutputsDir(this.getProject(), this.getRootDir());
                String targetOutputsDirPath = targetOutputsDir.getCanonicalPath();
                boolean addedIncludes = false;
                File includesFile = new File(String.valueOf(manifestDir) + File.separator + "deltaDeployed.asHFSFileSet");
                PrintWriter includesFileOutput = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(includesFile), "UTF-8")));
                if (deletedContainers.size() > 0 && BackUpHFSFilesTask.processFilesToDelete(deletedContainers, targetOutputsDirPath, includesFileOutput, deltaManifest, packageManifest, this.getProject())) {
                    addedIncludes = true;
                }
                if (this.processFilesToCreateOrUpdate(createOrUpdateContainers, targetOutputsDirPath, includesFileOutput, deltaManifest)) {
                    addedIncludes = true;
                }
                includesFileOutput.flush();
                includesFileOutput.close();
                if (addedIncludes) {
                    FileSet fileSet = new FileSet();
                    fileSet.setProject(this.getProject());
                    fileSet.setDir(targetOutputsDir);
                    fileSet.setIncludesfile(includesFile);
                    HFSUtil.createTar(Arrays.asList(fileSet), (File)new File(this.outputDir, this.outputFile), (String)"HFS", (Project)this.getProject());
                }
                includesFile.delete();
            }
            if (!shouldSerializeManifest) return;
            HFSUtil.serializeManifest((Manifest)deltaManifest, (File)deltaManifestFile);
            return;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static boolean processFilesToDelete(List<Container> containers, String outputsDirPath, PrintWriter includesFileOutput, Manifest deltaManifest, Manifest packageManifest, Project project) {
        if (containers.isEmpty()) {
            return false;
        }
        HashMap<String, Container> deltaContainerMapping = new HashMap<String, Container>();
        if (deltaManifest != null) {
            for (Container deltaContainer : HFSUtil.getHFSContainers((List)deltaManifest.getDeletedContainers(), (boolean)true)) {
                deltaContainerMapping.put(deltaContainer.getName(), deltaContainer);
            }
        }
        boolean addedIncludes = false;
        for (Container container : containers) {
            Iterator resources = container.getResourcesIterator();
            while (resources.hasNext()) {
                Resource resource = (Resource)resources.next();
                String relativePath = HFSUtil.getNormalizedPath((Container)container, (Resource)resource);
                FileSet fileSet = new FileSet();
                fileSet.setProject(project);
                fileSet.setDir(new File(outputsDirPath));
                fileSet.createInclude().setName(relativePath);
                HashMap<String, HashSet<Resource>> directoryToResourceMapping = new HashMap<String, HashSet<Resource>>();
                BackUpHFSFilesTask.scanFiles(fileSet, outputsDirPath, directoryToResourceMapping, project, resource);
                ArrayList<String> deletedFiles = new ArrayList<String>();
                if (directoryToResourceMapping.size() > 0) {
                    Set<String> containerNames = directoryToResourceMapping.keySet();
                    for (String containerName : containerNames) {
                        boolean containerIsOutputsDir = false;
                        if (!containerName.startsWith(String.valueOf(outputsDirPath) + File.separator) && !(containerIsOutputsDir = containerName.equals(outputsDirPath))) continue;
                        String deltaContainerName = containerIsOutputsDir ? "." : containerName.substring(outputsDirPath.length() + 1);
                        boolean isNewContainer = false;
                        Container deltaContainer = (Container)deltaContainerMapping.get(deltaContainerName);
                        if (deltaContainer == null) {
                            isNewContainer = true;
                            deltaContainer = new Container();
                            deltaContainer.setType("directory");
                            deltaContainer.setChangeType("DELETE");
                            deltaContainer.setName(deltaContainerName);
                        }
                        for (Resource newResource : directoryToResourceMapping.get(containerName)) {
                            if (deltaManifest != null) {
                                deltaContainer.addResource(newResource);
                            }
                            String includePath = containerIsOutputsDir ? newResource.getName() : String.valueOf(deltaContainer.getName()) + File.separator + newResource.getName();
                            if (deltaManifest != null) {
                                deletedFiles.add(includePath);
                            }
                            includesFileOutput.println(includePath);
                            addedIncludes = true;
                        }
                        if (deltaManifest == null || !isNewContainer || !deltaContainer.getResourcesIterator().hasNext()) continue;
                        deltaManifest.addDeletedContainer(deltaContainer);
                        deltaContainerMapping.put(deltaContainer.getName(), deltaContainer);
                    }
                }
                if (deltaManifest == null) continue;
                for (Container pkgContainer : HFSUtil.getHFSContainers((List)packageManifest.getDeletedContainers())) {
                    boolean isNewContainer = false;
                    Container deltaContainer = (Container)deltaContainerMapping.get(pkgContainer.getName());
                    if (deltaContainer == null) {
                        isNewContainer = true;
                        deltaContainer = new Container();
                        deltaContainer.setType("directory");
                        deltaContainer.setChangeType("DELETE");
                        deltaContainer.setName(pkgContainer.getName());
                    }
                    Iterator pkgResources = pkgContainer.getResourcesIterator();
                    while (pkgResources.hasNext()) {
                        String path;
                        Resource newResource;
                        Resource pkgResource = (Resource)pkgResources.next();
                        if (pkgResource.getName().contains("*") || pkgResource.getName().contains("?") || deletedFiles.contains(path = HFSUtil.getNormalizedPath((Container)pkgContainer, (Resource)pkgResource)) || new File(String.valueOf(outputsDirPath) + File.separator + path).exists()) continue;
                        newResource = new Resource(pkgResource);
                        newResource.setMissing("true");
                        deltaContainer.addResource(newResource);
                    }
                    if (!isNewContainer || !deltaContainer.getResourcesIterator().hasNext()) continue;
                    deltaManifest.addDeletedContainer(deltaContainer);
                    deltaContainerMapping.put(deltaContainer.getName(), deltaContainer);
                }
            }
        }
        return addedIncludes;
    }

    private boolean processFilesToCreateOrUpdate(List<Container> containers, String outputsDirPath, PrintWriter includesFileOutput, Manifest deltaManifest) {
        if (containers.isEmpty()) {
            return false;
        }
        boolean addedIncludes = false;
        HashMap<String, Container> createdContainers = new HashMap<String, Container>();
        HashMap<String, Container> updatedContainers = new HashMap<String, Container>();
        for (Container container : containers) {
            Iterator resources = container.getResourcesIterator();
            while (resources.hasNext()) {
                Container newContainer;
                Resource resource = (Resource)resources.next();
                String relativePath = HFSUtil.getNormalizedPath((Container)container, (Resource)resource);
                File file = new File(String.valueOf(outputsDirPath) + File.separator + relativePath);
                if (file.exists()) {
                    newContainer = (Container)updatedContainers.get(container.getName());
                    if (newContainer == null) {
                        newContainer = new Container();
                        newContainer.setName(container.getName());
                        newContainer.setType("directory");
                        newContainer.setChangeType("UPDATE");
                        updatedContainers.put(newContainer.getName(), newContainer);
                    }
                    includesFileOutput.println(relativePath);
                    addedIncludes = true;
                } else {
                    newContainer = (Container)createdContainers.get(container.getName());
                    if (newContainer == null) {
                        newContainer = new Container();
                        newContainer.setName(container.getName());
                        newContainer.setType("directory");
                        newContainer.setChangeType("ADD");
                        createdContainers.put(newContainer.getName(), newContainer);
                    }
                }
                Resource newResource = new Resource(resource);
                newContainer.addResource(newResource);
            }
        }
        deltaManifest.getCreatedContainers().addAll(createdContainers.values());
        deltaManifest.getUpdatedContainers().addAll(updatedContainers.values());
        return addedIncludes;
    }

    private static void scanFiles(FileSet fileSet, String outputsDirPath, HashMap<String, HashSet<Resource>> directoryToResourceMapping, Project project, Resource originalResource) {
        String[] resolvedFiles;
        DirectoryScanner scanner = fileSet.getDirectoryScanner(project);
        String[] stringArray = resolvedFiles = scanner.getIncludedFiles();
        int n = resolvedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String resolvedFile = stringArray[n2];
            int lastIndexOfSlash = resolvedFile.lastIndexOf(File.separator);
            if (lastIndexOfSlash != -1) {
                HFSUtil.collectFileInformation((String)(String.valueOf(outputsDirPath) + File.separator + resolvedFile.substring(0, lastIndexOfSlash)), (String)resolvedFile.substring(lastIndexOfSlash + 1), null, directoryToResourceMapping, (Project)project, (Resource)originalResource);
            } else {
                HFSUtil.collectFileInformation((String)outputsDirPath, (String)resolvedFile, null, directoryToResourceMapping, (Project)project, (Resource)originalResource);
            }
            ++n2;
        }
    }

    public static File resolveTargetOutputsDir(Project project, String targetDirParameter) {
        File outputsDir;
        if (targetDirParameter != null && !targetDirParameter.isEmpty()) {
            outputsDir = new File(targetDirParameter);
        } else {
            String outputsDirProperty = project.getProperty("team.enterprise.deployment.hfs.runtimeRoot.dir");
            if (outputsDirProperty == null || outputsDirProperty.trim().isEmpty()) {
                throw new BuildException(NLS.bind((String)Messages.BackUpHFSFilesTask_MISSING_HFS_OUTPUTS_DIR_PROPERTY, (Object)"team.enterprise.deployment.hfs.runtimeRoot.dir"));
            }
            outputsDir = new File(outputsDirProperty);
        }
        if (!outputsDir.exists()) {
            project.log("HFS target directory " + outputsDir.getPath() + " does not exist - attempting to create it", 4);
            if (!outputsDir.mkdirs()) {
                throw new BuildException(NLS.bind((String)Messages.BackUpHFSFilesTask_HFS_OUTPUTS_DIR_COULD_NOT_CREATE, (Object)outputsDir.getAbsolutePath()));
            }
        }
        if (!outputsDir.isDirectory()) {
            throw new BuildException(NLS.bind((String)Messages.BackUpHFSFilesTask_HFS_OUTPUTS_DIR_NOT_A_DIR, (Object)outputsDir.getAbsolutePath()));
        }
        return outputsDir;
    }

    public void setManifest(File manifest) {
        this.manifestFile = manifest;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }
}

