/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.ant;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.automation.ant.RepositoryTask;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.deployment.ant.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class RecordDeployedObjectsTask
extends RepositoryTask {
    private File localPackageDir;
    private String filesystemType;
    private String buildEngineUUID;
    private String buildResultUUID;
    private String packageLabel;

    public void execute() throws BuildException {
        try {
            File deltaDeployedManifestFile = new File(this.localPackageDir, "deltaDeployed.xml");
            if (deltaDeployedManifestFile.exists()) {
                Resource resource;
                IBuildResultContribution contribution;
                Iterator resourceIterator;
                Manifest deltaDeployedManifest = ManifestReader.getInstance().getManifest(deltaDeployedManifestFile);
                HashSet<String> workItemUUIDs = new HashSet<String>();
                List createdContainers = deltaDeployedManifest.getCreatedContainers();
                List updatedContainers = deltaDeployedManifest.getUpdatedContainers();
                ArrayList<IBuildResultContribution> contributions = new ArrayList<IBuildResultContribution>();
                IBuildResultContribution summaryContribution = BuildItemFactory.createBuildResultContribution();
                IBuildEngine buildEngine = this.getBuildEngine();
                String hostname = buildEngine.getConfigurationElement("com.ibm.rational.buildforge.buildagent").getConfigurationProperty("com.ibm.rational.buildforge.buildagent.hostname").getValue();
                summaryContribution.setLabel(this.filesystemType);
                summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_LABEL, this.packageLabel);
                summaryContribution.setExtendedContributionTypeId(AutomationResultContribution.DEPLOYMENT_OVERVIEW_EXTENDED_CONTRIBUTION_ID);
                summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_HOST_NAME, hostname);
                summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_DIR, this.localPackageDir.getAbsolutePath());
                summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, this.convert2Timestamp(this.packageLabel));
                contributions.add(summaryContribution);
                for (Container createdContainer : createdContainers) {
                    resourceIterator = createdContainer.getResourcesIterator();
                    while (resourceIterator.hasNext()) {
                        contribution = BuildItemFactory.createBuildResultContribution();
                        contribution.setExtendedContributionTypeId(AutomationResultContribution.DEPLOYED_OBJECT_EXTENDED_CONTRIBUTION_ID);
                        resource = (Resource)resourceIterator.next();
                        contribution.setLabel(resource.getName());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER, createdContainer.getName());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_LAST_MODIFIED, resource.getLastModifiedTimestamp());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM, resource.getWorkItemId());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM_UUID, resource.getWorkitemUUID());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTTYPE, resource.getIbmiType());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTSUBTYPE, resource.getIbmiAttrribute());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CHANGE_TYPE, "Created");
                        if (resource.getWorkitemUUID() != null) {
                            workItemUUIDs.add(resource.getWorkitemUUID());
                        }
                        contributions.add(contribution);
                    }
                }
                for (Container updatedContainer : updatedContainers) {
                    resourceIterator = updatedContainer.getResourcesIterator();
                    while (resourceIterator.hasNext()) {
                        contribution = BuildItemFactory.createBuildResultContribution();
                        contribution.setExtendedContributionTypeId(AutomationResultContribution.DEPLOYED_OBJECT_EXTENDED_CONTRIBUTION_ID);
                        resource = (Resource)resourceIterator.next();
                        contribution.setLabel(resource.getName());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER, updatedContainer.getName());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_LAST_MODIFIED, resource.getLastModifiedTimestamp());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM, resource.getWorkItemId());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM_UUID, resource.getWorkitemUUID());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTTYPE, resource.getIbmiType());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTSUBTYPE, resource.getIbmiAttrribute());
                        contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CHANGE_TYPE, "Updated");
                        if (resource.getWorkitemUUID() != null) {
                            workItemUUIDs.add(resource.getWorkitemUUID());
                        }
                        contributions.add(contribution);
                    }
                }
                IBuildResult buildResult = this.getBuildResult();
                ITeamRepository teamRepository = this.getTeamRepository();
                ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).addBuildResultContributions((IBuildResultHandle)buildResult, contributions.toArray(new IBuildResultContribution[contributions.size()]), null);
            }
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private IBuildEngine getBuildEngine() throws BuildException {
        if (this.buildEngineUUID == null) {
            throw new BuildException(Messages.RecordDeployedObjectsTask_BUILD_ENGINE_UUID_NULL_ERROR);
        }
        try {
            IBuildEngineHandle buildEngineHandle = (IBuildEngineHandle)IBuildEngine.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.buildEngineUUID), null);
            return (IBuildEngine)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildEngineHandle, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private IBuildResult getBuildResult() throws BuildException {
        if (this.buildResultUUID == null) {
            throw new BuildException(Messages.RecordDeployedObjectsTask_BUILD_RESULT_UUID_NULL_ERROR);
        }
        try {
            IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.buildResultUUID), null);
            return (IBuildResult)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String convert2Timestamp(String packageLabel) {
        try {
            return String.valueOf(new SimpleDateFormat("yyyyMMdd-HHmmssSSSS").parse(packageLabel).getTime());
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setLocalPackageDir(File localPackageDir) {
        this.localPackageDir = localPackageDir;
    }

    public void setFilesystemType(String filesystemType) {
        this.filesystemType = filesystemType;
    }

    public void setBuildEngineUUID(String buildEngineUUID) {
        this.buildEngineUUID = buildEngineUUID;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    public void setPackageLabel(String packageLabel) {
        this.packageLabel = packageLabel;
    }
}

